/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.search;

import org.apache.log4j.Logger;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.model.search.VeriniceQuery;
import sernet.verinice.model.search.VeriniceSearchResult;
import sernet.verinice.rcp.search.Messages;
import sernet.verinice.rcp.search.SearchView;

public class SearchJob
extends WorkspaceJob {
    private static final Logger LOG = Logger.getLogger(SearchJob.class);
    private VeriniceQuery query;
    private SearchView searchView;

    public SearchJob(VeriniceQuery query, SearchView searchView) {
        super(Messages.SearchView_5);
        this.query = query;
        this.searchView = searchView;
    }

    public IStatus runInWorkspace(IProgressMonitor mon) throws CoreException {
        final long startTime = System.currentTimeMillis();
        try {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SearchJob.this.searchView.disableSearch();
                }
            });
            Activator.inheritVeriniceContextState();
            final VeriniceSearchResult result = ServiceFactory.lookupSearchService().query(this.query);
            result.setVeriniceQuery(this.query);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SearchJob.this.searchView.updateResultCombobox(result);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("executing search for " + SearchJob.this.query.getQuery() + " lasts:\t" + String.valueOf((System.currentTimeMillis() - startTime) / 1000L) + " seconds"));
                    }
                }
            });
        }
        catch (Throwable throwable) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SearchJob.this.searchView.enableSearch();
                }
            });
            throw throwable;
        }
        Display.getDefault().asyncExec(new /* invalid duplicate definition of identical inner class */);
        return Status.OK_STATUS;
    }
}

