/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.search;

import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import sernet.verinice.model.search.VeriniceSearchResult;
import sernet.verinice.model.search.VeriniceSearchResultTable;
import sernet.verinice.rcp.search.Messages;
import sernet.verinice.rcp.search.SearchView;
import sernet.verinice.rcp.search.VeriniceSearchResultComparator;

public class SearchComboViewer
extends ComboViewer
implements IStructuredContentProvider,
ISelectionChangedListener {
    private SearchView searchView;

    public SearchComboViewer(Composite searchComboComposite, SearchView searchView) {
        super(searchComboComposite, 780);
        this.searchView = searchView;
        this.setContentProvider((IContentProvider)this);
        this.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                VeriniceSearchResultTable veriniceSearchResult = (VeriniceSearchResultTable)element;
                return this.getLabelText(veriniceSearchResult);
            }

            private String getLabelText(VeriniceSearchResultTable result) {
                StringBuilder sb = new StringBuilder();
                sb.append(result.getEntityName()).append(" (").append(result.getHits());
                if (result.getHits() >= result.getLimit()) {
                    sb.append(", ").append(Messages.SearchComboViewer_2);
                }
                sb.append(")").toString();
                return sb.toString();
            }
        });
        this.addSelectionChangedListener(this);
        this.setComparator(this.setSearchViewerComparator());
    }

    private ViewerComparator setSearchViewerComparator() {
        return new ViewerComparator(){
            VeriniceSearchResultComparator comparator = new VeriniceSearchResultComparator();

            public int compare(Viewer viewer, Object object1, Object object2) {
                if (object1 instanceof VeriniceSearchResultTable && object2 instanceof VeriniceSearchResultTable) {
                    VeriniceSearchResultTable vResultObject1 = (VeriniceSearchResultTable)object1;
                    VeriniceSearchResultTable vResultObject2 = (VeriniceSearchResultTable)object2;
                    return this.comparator.compare(vResultObject1, vResultObject2);
                }
                return this.compare(viewer, object1, object2);
            }
        };
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof VeriniceSearchResult) {
            VeriniceSearchResult veriniceSearchResult = (VeriniceSearchResult)inputElement;
            VeriniceSearchResultTable[] input = new VeriniceSearchResultTable[veriniceSearchResult.getAllVeriniceSearchTables().size()];
            return veriniceSearchResult.getAllVeriniceSearchTables().toArray(input);
        }
        return new VeriniceSearchResultTable[0];
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (!event.getSelection().isEmpty()) {
            VeriniceSearchResultTable veriniceSearchResultTable = (VeriniceSearchResultTable)((StructuredSelection)event.getSelection()).getFirstElement();
            this.searchView.setTableViewer(veriniceSearchResultTable);
            this.searchView.enableExport2CSVAction(true);
        } else {
            VeriniceSearchResultTable firstResult = (VeriniceSearchResultTable)this.getElementAt(0);
            this.searchView.setTableViewer(firstResult);
            this.searchView.enableExport2CSVAction(true);
        }
    }
}

