/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.search;

import org.apache.log4j.Logger;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.rcp.search.Messages;

public class ReIndexJob
extends WorkspaceJob {
    private final Action reindex;
    private final Logger LOG = Logger.getLogger(ReIndexJob.class);
    private IProgressMonitor mon;

    public ReIndexJob(Action reindex) {
        super(Messages.IndexJob_0);
        this.reindex = reindex;
    }

    public IStatus runInWorkspace(IProgressMonitor mon) throws CoreException {
        this.mon = mon;
        try {
            this.deactivateReindexButton();
            Activator.inheritVeriniceContextState();
            ServiceFactory.lookupSearchService().reindex();
            mon.done();
        }
        finally {
            this.activateReIndexButton();
        }
        return Status.OK_STATUS;
    }

    private void activateReIndexButton() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ReIndexJob.this.reindex.setEnabled(true);
            }
        });
    }

    private void deactivateReindexButton() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ReIndexJob.this.reindex.setEnabled(false);
            }
        });
    }

    protected void canceling() {
        this.mon.setCanceled(true);
        this.getThread().interrupt();
        this.LOG.debug((Object)"reindexing was cancelled");
    }
}

