/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.search;

import java.io.File;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import sernet.gs.service.FileUtil;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.preferences.PreferenceConstants;
import sernet.verinice.model.search.VeriniceSearchResultTable;
import sernet.verinice.rcp.search.SearchResultTableConverter;
import sernet.verinice.rcp.search.column.ColumnStore;
import sernet.verinice.rcp.search.column.ColumnStoreFactory;
import sernet.verinice.service.csv.CsvExport;
import sernet.verinice.service.csv.CsvExportException;

public class CsvExportHandler {
    private static final Logger LOG = Logger.getLogger(CsvExportHandler.class);
    private static final String CSV = ".csv";
    public static final String FILE_NAME_DEFAULT = "verinice-search-result.csv";
    Shell shell;
    VeriniceSearchResultTable result;

    public CsvExportHandler(VeriniceSearchResultTable veriniceSearchResultTable, Shell shell) {
        this.result = veriniceSearchResultTable;
        this.shell = shell;
    }

    public void run() throws CsvExportException {
        try {
            String filePath = this.createFilePath();
            if (this.check(filePath)) {
                this.export(filePath);
                if (filePath != null) {
                    Activator.getDefault().getPreferenceStore().setValue("default_folder_csv_export", FileUtil.getFolderFromPath((String)filePath));
                }
            }
        }
        catch (Exception e) {
            String message = "An error occurred during export.";
            LOG.error((Object)message, (Throwable)e);
            ExceptionUtil.log(e, message);
        }
    }

    private void export(String filePath) throws CsvExportException {
        ColumnStore columnStore = ColumnStoreFactory.getColumnStore(this.result.getEntityTypeId());
        List<String[]> simpleTable = SearchResultTableConverter.convertTable(this.result, columnStore);
        CsvExport exporter = new CsvExport();
        exporter.setFilePath(filePath);
        exporter.setSeperator(this.getSeperator());
        exporter.setCharset(PreferenceConstants.getCharsetPreference("search_csv_export_encoding"));
        exporter.exportToFile(simpleTable);
    }

    private char getSeperator() {
        String seperator = Activator.getDefault().getPreferenceStore().getString("search_csv_export_seperator");
        if (StringUtils.isEmpty((String)seperator)) {
            return ";".charAt(0);
        }
        return seperator.charAt(0);
    }

    private String createFilePath() {
        FileDialog dialog = new FileDialog(this.shell, 8192);
        dialog.setText("Export to CSV file");
        try {
            dialog.setFilterPath(this.getDirectory());
            dialog.setFileName(FILE_NAME_DEFAULT);
        }
        catch (Exception e1) {
            LOG.debug((Object)("Error with file path: " + this.getDirectory()), (Throwable)e1);
            dialog.setFileName("");
        }
        dialog.setFilterExtensions(new String[]{"*.csv"});
        dialog.setFilterNames(new String[]{"CSV table (.csv)"});
        dialog.setFilterIndex(0);
        String filePath = dialog.open();
        return filePath;
    }

    private boolean check(String filePath) {
        if (filePath == null) {
            return false;
        }
        File file = new File(filePath);
        if (file.exists()) {
            MessageBox mb = new MessageBox(this.shell, 200);
            mb.setText("File exists");
            mb.setMessage(String.valueOf(filePath) + " already exists. Do you want to replace it?");
            return mb.open() == 64;
        }
        return true;
    }

    private String getDirectory() {
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        String dir = prefs.getString("default_folder_csv_export");
        if (dir == null || dir.isEmpty()) {
            dir = System.getProperty("user.home");
        }
        if (!dir.endsWith(System.getProperty("file.separator"))) {
            dir = String.valueOf(dir) + System.getProperty("file.separator");
        }
        return dir;
    }

    public void setVeriniceSearchResultObject(VeriniceSearchResultTable veriniceSearchResultTable) {
        this.result = veriniceSearchResultTable;
    }
}

