/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.risk;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import sernet.hui.common.VeriniceContext;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.rcp.risk.Messages;
import sernet.verinice.rcp.risk.OrganizationPage;
import sernet.verinice.service.risk.RiskAnalysisConfiguration;
import sernet.verinice.service.risk.RiskAnalysisService;

public class RiskAnalysisIsoWizard
extends Wizard {
    private static final Logger log = Logger.getLogger(RiskAnalysisIsoWizard.class);
    private RiskAnalysisConfiguration configuration;
    private CnATreeElement selectedOrganization = null;
    private OrganizationPage organizationPage;
    private RiskAnalysisService riskAnalysisService;

    public RiskAnalysisIsoWizard() {
        this.init();
    }

    public RiskAnalysisIsoWizard(CnATreeElement selectedOrganization) {
        this();
        this.selectedOrganization = selectedOrganization;
    }

    private void init() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.RiskAnalysisIsoWizard_WindowTitle);
    }

    public void addPages() {
        this.organizationPage = new OrganizationPage(this.selectedOrganization);
        this.addPage((IWizardPage)this.organizationPage);
    }

    public boolean performFinish() {
        try {
            this.organizationPage.setMessage(Messages.RiskAnalysisIsoWizard_IsRunningMessage, 1);
            this.createConfiguration();
            this.runRiskAnalysis();
        }
        catch (InterruptedException | InvocationTargetException e) {
            log.error((Object)"InvocationTargetException or InterruptedException while running ISO/IEC 27005 risk analysis", (Throwable)e);
            this.organizationPage.setMessage(Messages.RiskAnalysisIsoWizard_ErrorMessage, 3);
            return false;
        }
        return true;
    }

    private void createConfiguration() {
        this.configuration = new RiskAnalysisConfiguration(new Integer[0]);
        List<Integer> organizationIds = this.organizationPage.getOrganizationIds();
        Integer[] organizationIdArray = organizationIds.toArray(new Integer[organizationIds.size()]);
        this.configuration.setOrganizationDbIds(organizationIdArray);
    }

    private void runRiskAnalysis() throws InvocationTargetException, InterruptedException {
        this.getContainer().run(true, false, new IRunnableWithProgress(){

            public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
                progressMonitor.beginTask(Messages.RiskAnalysisIsoWizard_IsRunningTaskMessage, -1);
                RiskAnalysisIsoWizard.this.getRiskAnalysisService().runRiskAnalysis(RiskAnalysisIsoWizard.this.configuration);
                progressMonitor.done();
            }
        });
    }

    public IWizardPage getStartingPage() {
        return this.organizationPage;
    }

    public RiskAnalysisConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(RiskAnalysisConfiguration configuration) {
        this.configuration = configuration;
    }

    private RiskAnalysisService getRiskAnalysisService() {
        if (this.riskAnalysisService == null) {
            this.riskAnalysisService = (RiskAnalysisService)VeriniceContext.get((String)"riskAnalysisService");
        }
        return this.riskAnalysisService;
    }
}

