/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.risk;

import org.apache.log4j.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.iso27k.Organization;
import sernet.verinice.rcp.NonModalWizardDialog;
import sernet.verinice.rcp.RightsEnabledActionDelegate;
import sernet.verinice.rcp.risk.Messages;
import sernet.verinice.rcp.risk.RiskAnalysisIsoWizard;

public class RiskAnalysisActionDelegate
extends RightsEnabledActionDelegate
implements IWorkbenchWindowActionDelegate {
    private static final Logger log = Logger.getLogger(RiskAnalysisActionDelegate.class);
    private CnATreeElement selectedOrganization;
    private Shell shell;

    @Override
    public void doRun(IAction action) {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(true);
            TitleAreaDialog wizardDialog = this.openWizard();
            if (wizardDialog.open() == 0) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.RiskAnalysisAction_FinishDialogTitle, (String)Messages.RiskAnalysisAction_FinishDialogMessage);
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.RiskAnalysisAction_ErrorDialogTitle, (String)Messages.RiskAnalysisAction_ErrorDialogMessage);
        }
    }

    public String getRightID() {
        return "riskanalysis";
    }

    public void init(IWorkbenchWindow window) {
        try {
            this.shell = window.getShell();
        }
        catch (Exception t) {
            log.error((Object)"Error creating RiskAnalysisActionDelegate", (Throwable)t);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof ITreeSelection) {
            this.selectedOrganization = null;
            ITreeSelection selectionCurrent = (ITreeSelection)selection;
            for (Object selectedObject : selectionCurrent) {
                if (!this.isOrganization(selectedObject)) continue;
                this.selectedOrganization = (CnATreeElement)selectedObject;
            }
        }
    }

    private boolean isOrganization(Object element) {
        return element instanceof Organization;
    }

    private Shell getShell() {
        return this.shell;
    }

    private TitleAreaDialog openWizard() {
        RiskAnalysisIsoWizard wizard = new RiskAnalysisIsoWizard(this.selectedOrganization);
        return new NonModalWizardDialog(this.getShell(), (IWizard)wizard);
    }
}

