/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.risk;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.gs.ui.rcp.main.actions.RightsEnabledAction;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.common.model.IModelLoadListener;
import sernet.verinice.model.bp.elements.BpModel;
import sernet.verinice.model.bsi.BSIModel;
import sernet.verinice.model.catalog.CatalogModel;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.iso27k.ISO27KModel;
import sernet.verinice.model.iso27k.Organization;
import sernet.verinice.rcp.NonModalWizardDialog;
import sernet.verinice.rcp.risk.Messages;
import sernet.verinice.rcp.risk.RiskAnalysisIsoWizard;

public class RiskAnalysisAction
extends RightsEnabledAction
implements ISelectionListener {
    public static final String ID = "sernet.gs.ui.rcp.main.runriskanalysisaction";
    private CnATreeElement selectedOrganization;

    public RiskAnalysisAction(IWorkbenchWindow window) {
        super("riskanalysis", Messages.RiskAnalysisAction_Text);
        this.setId(ID);
        this.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("sweetie-verinice/png/16-paper-calculate-percent.png"));
        this.addLoadListener();
        window.getSelectionService().addSelectionListener((ISelectionListener)this);
    }

    @Override
    public void doRun() {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(true);
            TitleAreaDialog wizardDialog = this.openWizard();
            if (wizardDialog.open() == 0) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.RiskAnalysisAction_FinishDialogTitle, (String)Messages.RiskAnalysisAction_FinishDialogMessage);
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.RiskAnalysisAction_ErrorDialogTitle, (String)Messages.RiskAnalysisAction_ErrorDialogMessage);
        }
    }

    private TitleAreaDialog openWizard() {
        RiskAnalysisIsoWizard wizard = new RiskAnalysisIsoWizard(this.selectedOrganization);
        return new NonModalWizardDialog(this.getShell(), (IWizard)wizard);
    }

    private void addLoadListener() {
        CnAElementFactory.getInstance().addLoadListener(new IModelLoadListener(){

            @Override
            public void closed(BSIModel model) {
                RiskAnalysisAction.this.setEnabled(false);
            }

            @Override
            public void loaded(BSIModel model) {
            }

            @Override
            public void loaded(ISO27KModel model) {
                RiskAnalysisAction.this.setEnabled(RiskAnalysisAction.this.checkRights());
            }

            @Override
            public void loaded(BpModel model) {
            }

            @Override
            public void loaded(CatalogModel model) {
            }
        });
    }

    public void selectionChanged(IWorkbenchPart arg0, ISelection selection) {
        if (selection instanceof ITreeSelection) {
            this.selectedOrganization = null;
            ITreeSelection selectionCurrent = (ITreeSelection)selection;
            for (Object selectedObject : selectionCurrent) {
                if (!this.isOrganization(selectedObject)) continue;
                this.selectedOrganization = (CnATreeElement)selectedObject;
            }
        }
    }

    private boolean isOrganization(Object element) {
        return element instanceof Organization;
    }

    private Shell getShell() {
        return Display.getCurrent().getActiveShell();
    }
}

