/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.risk;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.iso27k.rcp.OrganizationMultiselectWidget;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.rcp.account.BaseWizardPage;
import sernet.verinice.rcp.risk.Messages;

public class OrganizationPage
extends BaseWizardPage {
    private static final Logger LOG = Logger.getLogger(OrganizationPage.class);
    public static final String PAGE_NAME = "risk-analysis-wizard-organization-page";
    private ITreeSelection selection;
    private CnATreeElement selectedElement;
    private List<Integer> organizationIds = new LinkedList<Integer>();
    private OrganizationMultiselectWidget organizationWidget = null;

    public OrganizationPage() {
        this((CnATreeElement)null);
    }

    public OrganizationPage(ITreeSelection selection) {
        this((CnATreeElement)null);
        this.selection = selection;
    }

    public OrganizationPage(CnATreeElement selectedOrganization) {
        super(PAGE_NAME);
        this.selectedElement = selectedOrganization;
    }

    @Override
    protected void initGui(Composite composite) {
        int layoutMarginWidth = 10;
        int layoutMarginHeight = 10;
        this.setTitle(Messages.OrganizationPage_WizardTitle);
        this.setMessage(Messages.OrganizationPage_WizardMessage);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        GridData gd = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gd);
        try {
            this.organizationWidget = new OrganizationMultiselectWidget(composite, this.selection, this.selectedElement);
        }
        catch (CommandException ex) {
            LOG.error((Object)"Error while loading organizations", (Throwable)ex);
            this.setMessage(Messages.OrganizationPage_ErrorMessage, 3);
        }
        SelectionAdapter organizationListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OrganizationPage.this.syncSelectedOrganizations();
                super.widgetSelected(e);
            }
        };
        this.organizationWidget.addSelectionListener((SelectionListener)organizationListener);
        this.syncSelectedOrganizations();
        composite.pack();
    }

    @Override
    protected void initData() throws Exception {
    }

    public boolean isPageComplete() {
        boolean complete;
        boolean bl = complete = !this.organizationIds.isEmpty();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("page complete: " + complete));
        }
        return complete;
    }

    private void syncSelectedOrganizations() {
        this.organizationIds.clear();
        if (this.organizationWidget.getSelectedElementSet() != null) {
            Set selectedOrganizations = this.organizationWidget.getSelectedElementSet();
            for (CnATreeElement organization : selectedOrganizations) {
                this.organizationIds.add(organization.getDbId());
            }
        }
        this.setPageComplete(this.isPageComplete());
    }

    public Set<CnATreeElement> getSelectedElementSet() {
        return this.organizationWidget.getSelectedElementSet();
    }

    public CnATreeElement getSelectedElement() {
        return (CnATreeElement)this.organizationWidget.getSelectedElement();
    }

    public List<Integer> getOrganizationIds() {
        return this.organizationIds;
    }
}

