/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.linktable.ui.multiselectiondialog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import sernet.verinice.rcp.linktable.ui.LinkTableComposite;
import sernet.verinice.rcp.linktable.ui.Messages;
import sernet.verinice.rcp.linktable.ui.multiselectiondialog.LinkTableMultiSelectionControl;
import sernet.verinice.rcp.linktable.ui.multiselectiondialog.LinkTableMultiSelectionDialog;
import sernet.verinice.service.model.IObjectModelService;

public class LinkTableMultiSelectionList {
    private static final Logger LOG = Logger.getLogger(LinkTableMultiSelectionList.class);
    private LinkTableMultiSelectionDialog parent;
    private Composite list;
    private Group group;
    private Map<String, Button> checkboxes = new HashMap<String, Button>();
    private Set<String> allUsedRelationIds;
    private Button allRelations;
    private LinkTableMultiSelectionControl vltMultiSelectionControl;
    private LinkTableComposite vltComposite;
    private List<String> selectedRelations;

    public LinkTableMultiSelectionList(LinkTableMultiSelectionDialog parent) {
        this.parent = parent;
        this.vltMultiSelectionControl = parent.getLTRMultiSelectionControl();
        this.vltComposite = this.vltMultiSelectionControl.getVltParent();
        this.selectedRelations = this.vltComposite.getVeriniceLinkTable().getRelationIds();
        this.create();
    }

    public void refresh() {
        this.list.getParent().dispose();
        this.list = this.createScrolledList();
        int height = this.createButtons();
        GridData gd = (GridData)this.group.getLayoutData();
        gd.heightHint = height;
        this.list.pack();
        this.group.pack();
        this.group.layout();
    }

    private void create() {
        this.allUsedRelationIds = new HashSet<String>(this.vltComposite.getAllUsedRelationIds());
        this.createAllRelationsButton();
        if (this.allUsedRelationIds.isEmpty()) {
            this.allRelations.setSelection(true);
            this.allRelations.setEnabled(false);
            new Label((Composite)this.parent.getDialogShell(), 0).setText(Messages.LinkTableMultiSelectionList_0);
        } else {
            this.group = this.createGroup();
            this.list = this.createScrolledList();
            int height = this.createButtons();
            GridData gd = (GridData)this.group.getLayoutData();
            gd.heightHint = height;
            this.initializeCheckboxes();
            this.list.pack();
            GridDataFactory.swtDefaults().grab(true, true).align(4, 4).applyTo((Control)this.group);
            this.group.layout();
        }
    }

    private void createAllRelationsButton() {
        boolean useAllRelationIds = this.vltComposite.getVeriniceLinkTable().getRelationIds().isEmpty();
        this.allRelations = new Button((Composite)this.parent.getDialogShell(), 16416);
        this.allRelations.setText(Messages.MultiSelectionControl_2);
        SelectionListener allRelationIDsListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                LOG.debug((Object)(String.valueOf(LinkTableMultiSelectionList.this.allRelations.getText()) + " selected: " + LinkTableMultiSelectionList.this.allRelations.getSelection()));
                LinkTableMultiSelectionList.this.vltMultiSelectionControl.setUseAllRelationIds(LinkTableMultiSelectionList.this.allRelations.getSelection());
                LinkTableMultiSelectionList.this.updateCheckBoxes();
                LinkTableMultiSelectionList.this.vltMultiSelectionControl.writeToTextField();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        };
        this.allRelations.addSelectionListener(allRelationIDsListener);
        this.allRelations.setSelection(useAllRelationIds);
    }

    private Group createGroup() {
        Group checkboxGroup = new Group((Composite)this.parent.getDialogShell(), 2048);
        GridData groupLData = new GridData();
        groupLData.horizontalIndent = 0;
        GridDataFactory.swtDefaults().align(4, 2).hint(-1, 100).span(4, 1).grab(true, false).indent(0, -1).applyTo((Control)checkboxGroup);
        checkboxGroup.setLayoutData((Object)groupLData);
        checkboxGroup.setText(Messages.MultiSelectionList_0);
        checkboxGroup.setLayout((Layout)new FillLayout(512));
        return checkboxGroup;
    }

    private int createButtons() {
        IObjectModelService modelService = this.vltComposite.getContentService();
        int btnsHeight = 0;
        int i = 0;
        for (String id : this.allUsedRelationIds) {
            ++i;
            Button checkbox = new Button(this.list, 16416);
            checkbox.setText(String.valueOf(id) + " (" + modelService.getRelationLabel(id) + ")");
            checkbox.setData((Object)id);
            checkbox.pack();
            checkbox.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent event) {
                    Set<String> selectedItems = LinkTableMultiSelectionList.this.getSelectedItems();
                    LinkTableMultiSelectionList.this.allRelations.setSelection(selectedItems.isEmpty() || selectedItems.size() == LinkTableMultiSelectionList.this.checkboxes.size());
                    LinkTableMultiSelectionList.this.vltMultiSelectionControl.setUseAllRelationIds(LinkTableMultiSelectionList.this.allRelations.getSelection());
                    LinkTableMultiSelectionList.this.vltMultiSelectionControl.writeToTextField();
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                    this.widgetSelected(event);
                }
            });
            this.checkboxes.put(id, checkbox);
            if (i >= 6) continue;
            btnsHeight = btnsHeight + checkbox.getBounds().height + 5;
        }
        return btnsHeight;
    }

    private Composite createScrolledList() {
        ScrolledComposite scrollPane = new ScrolledComposite((Composite)this.group, 512);
        Composite scrolledList = new Composite((Composite)scrollPane, 0);
        GridLayoutFactory.swtDefaults().numColumns(1).equalWidth(false).generateLayout(scrolledList);
        scrollPane.setContent((Control)scrolledList);
        return scrolledList;
    }

    public Set<String> getSelectedItems() {
        HashSet<String> set = new HashSet<String>();
        for (Map.Entry<String, Button> box : this.checkboxes.entrySet()) {
            if (!box.getValue().getSelection()) continue;
            set.add(box.getKey());
        }
        return set;
    }

    public void initializeCheckboxes() {
        if (this.selectedRelations.isEmpty()) {
            this.selectedRelations = new ArrayList<String>(this.allUsedRelationIds);
        }
        for (String id : this.selectedRelations) {
            Button checkbox = this.checkboxes.get(id);
            if (checkbox != null) {
                checkbox.setSelection(true);
                continue;
            }
            this.selectedRelations.remove(id);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)(String.valueOf(id) + " removed from set"));
        }
    }

    public void updateCheckBoxes() {
        for (Button checkbox : this.checkboxes.values()) {
            checkbox.setSelection(this.allRelations.getSelection());
        }
    }
}

