/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.linktable.ui.multiselectiondialog;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import sernet.verinice.rcp.linktable.ui.LinkTableComposite;
import sernet.verinice.rcp.linktable.ui.Messages;
import sernet.verinice.rcp.linktable.ui.multiselectiondialog.LinkTableMultiSelectionDialog;

public class LinkTableMultiSelectionControl {
    private Composite parent;
    private Text text;
    private LinkTableMultiSelectionDialog dialog;
    private LinkTableComposite vltComposite;
    private Set<String> selectedItems = new HashSet<String>();
    private boolean useAllRelations = false;

    public LinkTableMultiSelectionControl(Composite parent, LinkTableComposite vltParent) {
        this.parent = parent;
        this.vltComposite = vltParent;
        this.useAllRelations = vltParent.getVeriniceLinkTable() == null || vltParent.getVeriniceLinkTable().getRelationIds().isEmpty();
        this.create();
    }

    private void create() {
        Label header = new Label(this.parent, 0);
        header.setText(Messages.MultiSelectionControl_5);
        Composite container = new Composite(this.parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).generateLayout(container);
        GridDataFactory.swtDefaults().align(4, 2).grab(true, false).applyTo((Control)container);
        this.text = new Text(container, 2048);
        this.text.setEditable(false);
        this.text.setLayoutData((Object)new GridData(768));
        this.text.getBackground();
        this.text.getForeground();
        Button editBtn = new Button(container, 8);
        editBtn.setText(Messages.MultiSelectionControl_0);
        editBtn.setEnabled(true);
        editBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                LinkTableMultiSelectionControl.this.showSelectionDialog();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                LinkTableMultiSelectionControl.this.showSelectionDialog();
            }
        });
        this.writeToTextField();
    }

    public void writeToTextField() {
        if (this.useAllRelations) {
            this.text.setText(Messages.MultiSelectionControl_3);
        } else {
            this.text.setText(Messages.MultiSelectionControl_4);
        }
        this.refresh();
    }

    private void refresh() {
        this.text.pack();
        this.parent.pack(true);
        this.parent.layout(true);
    }

    public void showSelectionDialog() {
        Display display = Display.getDefault();
        Shell shell = display.getActiveShell();
        if (this.dialog == null) {
            this.dialog = new LinkTableMultiSelectionDialog(shell, this, 0);
        }
        this.dialog.open();
    }

    public void setFocus() {
        this.text.setFocus();
    }

    public LinkTableComposite getVltParent() {
        return this.vltComposite;
    }

    public Set<String> getSelectedRelationIDs() {
        if (this.useAllRelations) {
            return new HashSet<String>();
        }
        return this.selectedItems;
    }

    public boolean useAllRelationIds() {
        return this.useAllRelations;
    }

    public void setUseAllRelationIds(boolean useAllRelationIds) {
        this.useAllRelations = useAllRelationIds;
    }

    public void setSelectedItems(Set<String> selectedItems) {
        this.selectedItems = selectedItems;
    }
}

