/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.linktable.ui.combo;

import java.util.Collections;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import sernet.verinice.rcp.linktable.ui.LinkTableColumn;
import sernet.verinice.rcp.linktable.ui.combo.LinkTableComboViewer;
import sernet.verinice.rcp.linktable.ui.combo.LinkTableElementComboViewer;
import sernet.verinice.rcp.linktable.ui.combo.LinkTableOperationType;
import sernet.verinice.rcp.linktable.ui.combo.LinkTablePropertyComboViewer;
import sernet.verinice.rcp.linktable.ui.combo.LinkTableRelationPropertyComboViewer;

public class LinkTableOperationTypeComboViewer
extends LinkTableComboViewer {
    private static final Logger LOG = Logger.getLogger(LinkTableOperationTypeComboViewer.class);

    public LinkTableOperationTypeComboViewer(LinkTableComboViewer leftCombo, String relatedID, LinkTableOperationType operationType, LinkTableColumn ltrParent, Composite parent) {
        this(leftCombo, relatedID, operationType, ltrParent, parent, false);
    }

    public LinkTableOperationTypeComboViewer(LinkTableComboViewer leftCombo, String relatedID, LinkTableOperationType operationType, LinkTableColumn ltrParent, Composite parent, boolean isCopy) {
        super(leftCombo, relatedID, operationType, ltrParent, parent);
        if (!isCopy) {
            this.selectFirstElement(true);
        }
        this.getCombo().setToolTipText(LinkTableOperationType.toolTip());
    }

    @Override
    public LinkTableComboViewer createChild(Composite parent) {
        if (this.getSelectedElement() == LinkTableOperationType.PROPERTY) {
            if (this.leftCombo.operationType == LinkTableOperationType.RELATION) {
                return new LinkTableRelationPropertyComboViewer(this, this.relatedID, this.getSelectedElement(), this.ltrColumn, parent);
            }
            return new LinkTablePropertyComboViewer(this, this.relatedID, this.getSelectedElement(), this.ltrColumn, parent);
        }
        return new LinkTableElementComboViewer(this, this.relatedID, this.getSelectedElement(), this.ltrColumn, parent);
    }

    public Object[] getElements(Object inputElement) {
        return LinkTableOperationType.values();
    }

    @Override
    public LinkTableComboViewer createCopy(LinkTableComboViewer leftCombo, LinkTableColumn ltrParent, Composite newParent) {
        return new LinkTableOperationTypeComboViewer(leftCombo, this.relatedID, this.getSelectedElement(), ltrParent, newParent, true);
    }

    public LinkTableOperationType getSelectedElement() {
        StructuredSelection test = (StructuredSelection)this.getSelection();
        return (LinkTableOperationType)test.getFirstElement();
    }

    @Override
    protected void doSelectionChanged() {
        if (LOG.isDebugEnabled()) {
            if (this.operationType != null) {
                LOG.debug((Object)("operationType changed from " + this.operationType.getLabel() + " to " + this.getCurrentSelection()));
            } else {
                LOG.debug((Object)"operationType is null");
            }
        }
        this.operationType = this.getSelectedElement();
        if (this.rightCombo != null) {
            this.rightCombo.dispose();
            this.rightCombo = null;
        }
    }

    @Override
    protected String getLabelText(Object element) {
        if (element instanceof LinkTableOperationType) {
            return ((LinkTableOperationType)element).getOutput();
        }
        return element.toString();
    }

    @Override
    protected void select(String string) {
        StructuredSelection selection = new StructuredSelection((Object)LinkTableOperationType.getOperationType(string));
        this.setSelection((ISelection)selection);
    }

    @Override
    protected Set<String> doGetAllRelationTypes() {
        return Collections.emptySet();
    }

    @Override
    public LinkTableComboViewer copy(LinkTableComboViewer leftCombo, Composite newParent, Control formerElement, LinkTableColumn linkTableColumn) {
        if (this.operationType == LinkTableOperationType.RELATION) {
            Composite newParentComposite = new Composite(newParent, 0);
            newParentComposite.setLayout((Layout)new FormLayout());
            newParentComposite.setLayoutData((Object)this.getDefaultFormData(formerElement));
            LinkTableComboViewer newViewer = this.createCopy(leftCombo, linkTableColumn, newParentComposite);
            newViewer.getCombo().select(this.getCombo().getSelectionIndex());
            if (this.rightCombo != null) {
                newViewer.selectionChanged(null);
                newViewer.rightCombo.getCombo().select(this.rightCombo.getCombo().getSelectionIndex());
                newViewer.rightCombo.selectionChanged(null);
                LinkTableComboViewer relationPropertyViewer = newViewer.rightCombo.rightCombo.rightCombo;
                int selectesRelationProperty = this.rightCombo.rightCombo.rightCombo.getCombo().getSelectionIndex();
                relationPropertyViewer.getCombo().select(selectesRelationProperty);
            }
            return newViewer;
        }
        return super.copy(leftCombo, newParent, formerElement, linkTableColumn);
    }
}

