/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.linktable.ui.combo;

import sernet.verinice.rcp.linktable.ui.Messages;
import sernet.verinice.rcp.linktable.ui.combo.ILinkTableOperationType;

public enum LinkTableOperationType implements ILinkTableOperationType
{
    PROPERTY(".", Messages.VeriniceLinkTableOperationType_00, Messages.VeriniceLinkTableOperationType_01),
    RELATION_OBJECT("/", Messages.VeriniceLinkTableOperationType_10, Messages.VeriniceLinkTableOperationType_11),
    RELATION(":", Messages.VeriniceLinkTableOperationType_20, Messages.VeriniceLinkTableOperationType_21),
    GROUP("<", Messages.VeriniceLinkTableOperationType_30, Messages.VeriniceLinkTableOperationType_31),
    CHILD(">", Messages.VeriniceLinkTableOperationType_40, Messages.VeriniceLinkTableOperationType_41);

    private final String output;
    private final String label;
    private final String defaultMessage;

    private LinkTableOperationType(String output, String label, String defaultMessage) {
        this.output = output;
        this.label = label;
        this.defaultMessage = defaultMessage;
    }

    @Override
    public String getLabel() {
        return String.valueOf(this.output) + " " + this.label;
    }

    @Override
    public String getOutput() {
        return this.output;
    }

    @Override
    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    @Override
    public String toString() {
        return this.getOutput();
    }

    public static LinkTableOperationType getOperationType(String value) {
        LinkTableOperationType[] linkTableOperationTypeArray = LinkTableOperationType.values();
        int n = linkTableOperationTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            LinkTableOperationType type = linkTableOperationTypeArray[n2];
            if (type.output.equalsIgnoreCase(value)) {
                return type;
            }
            ++n2;
        }
        throw new IllegalArgumentException("unsupported value " + value);
    }

    public static boolean isRelation(ILinkTableOperationType type) {
        return type == RELATION || type == RELATION_OBJECT;
    }

    public static boolean isRelation(String type) {
        return type.equals(RELATION_OBJECT.getOutput()) || type.equals(RELATION.getOutput());
    }

    public static String toolTip() {
        StringBuilder builder = new StringBuilder();
        LinkTableOperationType[] linkTableOperationTypeArray = LinkTableOperationType.values();
        int n = linkTableOperationTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            LinkTableOperationType type = linkTableOperationTypeArray[n2];
            builder.append(String.valueOf(type.getLabel()) + "\n");
            ++n2;
        }
        return builder.toString();
    }
}

