/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.linktable.ui.combo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import sernet.verinice.model.common.Domain;
import sernet.verinice.rcp.linktable.ui.LinkTableColumn;
import sernet.verinice.rcp.linktable.ui.combo.LinkTableComboViewer;
import sernet.verinice.rcp.linktable.ui.combo.LinkTableOperationType;
import sernet.verinice.rcp.linktable.ui.combo.LinkTableOperationTypeComboViewer;
import sernet.verinice.service.commands.CnATypeMapper;
import sernet.verinice.service.model.IObjectModelService;

public class LinkTableElementComboViewer
extends LinkTableComboViewer {
    private static final Logger LOG = Logger.getLogger(LinkTableElementComboViewer.class);
    private boolean isDefault;

    public LinkTableElementComboViewer(LinkTableColumn ltrParent, Composite parent) {
        this(null, null, null, ltrParent, parent);
    }

    public LinkTableElementComboViewer(LinkTableComboViewer leftCombo, String relatedID, LinkTableOperationType operationType, LinkTableColumn ltrParent, Composite parent) {
        this(leftCombo, relatedID, operationType, ltrParent, parent, false);
    }

    public LinkTableElementComboViewer(LinkTableComboViewer leftCombo, String relatedID, LinkTableOperationType operationType, LinkTableColumn ltrParent, Composite parent, boolean isFirstElement) {
        super(leftCombo, relatedID, operationType, ltrParent, parent);
        if (isFirstElement || this.isDefault) {
            this.selectFirstElement(!this.isDefault);
        }
    }

    @Override
    public LinkTableComboViewer createChild(Composite parent) {
        if (this.operationType == LinkTableOperationType.PROPERTY) {
            return null;
        }
        if (this.operationType == LinkTableOperationType.RELATION) {
            LinkTableOperationTypeComboViewer opType = new LinkTableOperationTypeComboViewer(this, this.getCurrentSelection(), this.operationType, this.ltrColumn, parent);
            opType.select(LinkTableOperationType.PROPERTY.getOutput());
            opType.getCombo().setEnabled(false);
            opType.selectionChanged(null);
            return opType;
        }
        return new LinkTableOperationTypeComboViewer(this, this.getCurrentSelection(), this.operationType, this.ltrColumn, parent);
    }

    public Object[] getElements(Object inputElement) {
        String[] typeIDs;
        IObjectModelService objectService = this.ltrColumn.getContentService();
        if (this.leftCombo == null || this.relatedID.isEmpty()) {
            typeIDs = new ArrayList(objectService.getAllTypeIDs()).toArray(new String[0]);
        } else {
            switch (this.operationType) {
                case CHILD: {
                    typeIDs = objectService.getPossibleChildren(this.relatedID).toArray(new String[0]);
                    break;
                }
                case GROUP: {
                    typeIDs = objectService.getPossibleParents(this.relatedID).toArray(new String[0]);
                    break;
                }
                case RELATION: {
                    typeIDs = objectService.getPossibleRelationPartners(this.relatedID).toArray(new String[0]);
                    break;
                }
                case RELATION_OBJECT: {
                    typeIDs = objectService.getPossibleRelationPartners(this.relatedID).toArray(new String[0]);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("not supported type " + this.operationType);
                }
            }
            if (typeIDs.length == 0) {
                typeIDs = new String[]{this.operationType.getDefaultMessage()};
                this.isDefault = true;
            }
        }
        Map<Domain, List<String>> typeIDsByDomain = Arrays.stream(typeIDs).collect(Collectors.groupingBy(CnATypeMapper::getDomainFromTypeId));
        return Stream.of(Domain.BASE_PROTECTION, Domain.ISM, Domain.BASE_PROTECTION_OLD, Domain.DATA_PROTECTION).flatMap(domain -> {
            List typeIDsForDomain = (List)typeIDsByDomain.get(domain);
            if (typeIDsForDomain == null) {
                return Stream.empty();
            }
            String[] sortedTypeIDsForDomain = this.sortElementsByLabel(typeIDsForDomain.toArray(new String[typeIDsForDomain.size()]));
            return Stream.of(sortedTypeIDsForDomain);
        }).toArray(String[]::new);
    }

    @Override
    public LinkTableComboViewer createCopy(LinkTableComboViewer leftCombo, LinkTableColumn ltrParent, Composite newParent) {
        return new LinkTableElementComboViewer(leftCombo, this.relatedID, this.operationType, ltrParent, newParent, false);
    }

    @Override
    protected void doSelectionChanged() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("selection changed to " + this.getCurrentSelection()));
        }
        if (this.rightCombo != null) {
            this.rightCombo.relatedID = this.getCurrentSelection();
        }
    }

    @Override
    protected String getLabelText(Object element) {
        StringBuilder sb;
        if (this.isDefault) {
            return element.toString();
        }
        String typeId = element.toString();
        IObjectModelService contentService = this.ltrColumn.getContentService();
        String typeLabel = contentService.getLabel(typeId);
        Domain domain = CnATypeMapper.getDomainFromTypeId((String)typeId);
        if (domain == Domain.DATA_PROTECTION) {
            String domainLabel = Domain.getLabelObsolete();
            sb = new StringBuilder(typeLabel.length() + domainLabel.length() + 3);
            sb.append(typeLabel).append(" (").append(domainLabel).append(")");
        } else {
            String domainLabel = domain.getLabel();
            sb = new StringBuilder(typeLabel.length() + domainLabel.length() + typeId.length() + 5);
            sb.append(typeLabel).append(" (").append(domainLabel).append(": ").append(typeId).append(")");
        }
        return sb.toString();
    }

    @Override
    protected void refreshCombo() {
        this.getCombo().setEnabled(!this.isDefault);
        super.refreshCombo();
    }

    @Override
    protected void select(String string) {
        StructuredSelection selection = new StructuredSelection((Object)string);
        this.setSelection((ISelection)selection);
    }

    @Override
    protected Set<String> doGetAllRelationTypes() {
        HashSet<String> relationIDs = new HashSet<String>();
        if (LinkTableOperationType.isRelation(this.operationType)) {
            relationIDs.addAll(this.ltrColumn.getContentService().getRelations(this.relatedID, this.getCurrentSelection()));
        }
        return relationIDs;
    }
}

