/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.linktable.ui.combo;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import sernet.verinice.rcp.linktable.ui.LinkTableColumn;
import sernet.verinice.rcp.linktable.ui.combo.LinkTableOperationType;

public abstract class LinkTableComboViewer
extends ComboViewer
implements IStructuredContentProvider,
ISelectionChangedListener {
    protected LinkTableColumn ltrColumn;
    protected LinkTableComboViewer rightCombo = null;
    protected LinkTableComboViewer leftCombo = null;
    Composite parentComposite = null;
    protected String relatedID;
    protected LinkTableOperationType operationType;
    protected boolean interactive = true;

    public LinkTableComboViewer(LinkTableComboViewer leftCombo, String relatedID, LinkTableOperationType operationType, LinkTableColumn ltrParent, Composite parent) {
        super(new Combo(parent, 8));
        this.getCombo().addListener(37, event -> {
            boolean bl = event.doit = false;
        });
        this.parentComposite = parent;
        this.ltrColumn = ltrParent;
        this.setContentProvider((IContentProvider)this);
        this.relatedID = relatedID;
        this.operationType = operationType;
        this.leftCombo = leftCombo;
        if (leftCombo != null) {
            this.interactive = leftCombo.interactive;
        }
        this.addSelectionChangedListener(this);
        this.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return LinkTableComboViewer.this.getLabelText(element).replace("\n", "");
            }
        });
        this.setInput(new Object());
        this.refreshCombo();
    }

    protected abstract String getLabelText(Object var1);

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
        if (this.leftCombo != null) {
            this.parentComposite.dispose();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.doSelectionChanged();
        if (this.rightCombo != null) {
            this.rightCombo.selectionChanged(event);
        } else if (this.interactive) {
            Control newComposite = this.createRightCombo();
            this.refreshViewer();
            this.ltrColumn.getLtrParent().showComposite(newComposite);
        }
    }

    private Control createRightCombo() {
        Composite newParent = new Composite(this.parentComposite, 0);
        newParent.setLayout((Layout)new FormLayout());
        newParent.setLayoutData((Object)this.getDefaultFormData((Control)this.getCombo()));
        this.rightCombo = this.createChild(newParent);
        newParent.pack(true);
        newParent.layout(true);
        return newParent;
    }

    protected abstract void doSelectionChanged();

    protected abstract LinkTableComboViewer createChild(Composite var1);

    public LinkTableComboViewer copy(LinkTableComboViewer leftCombo, Composite newParent, Control formerElement, LinkTableColumn linkTableColumn) {
        Composite newParentComposite = new Composite(newParent, 0);
        newParentComposite.setLayout((Layout)new FormLayout());
        newParentComposite.setLayoutData((Object)this.getDefaultFormData(formerElement));
        LinkTableComboViewer newViewer = this.createCopy(leftCombo, linkTableColumn, newParentComposite);
        newViewer.getCombo().select(this.getCombo().getSelectionIndex());
        if (this.rightCombo != null) {
            newViewer.rightCombo = this.rightCombo.copy(newViewer, newParentComposite, (Control)newViewer.getCombo(), linkTableColumn);
            newViewer.rightCombo.leftCombo = newViewer;
        }
        return newViewer;
    }

    protected FormData getDefaultFormData(Control formerElement) {
        FormData comboData = new FormData();
        comboData.left = new FormAttachment(formerElement, 6);
        comboData.top = new FormAttachment(formerElement, 0, 0x1000000);
        return comboData;
    }

    protected abstract LinkTableComboViewer createCopy(LinkTableComboViewer var1, LinkTableColumn var2, Composite var3);

    public String getValue() {
        return this.getCombo().getText();
    }

    public String getCurrentSelection() {
        StructuredSelection selection = (StructuredSelection)this.getSelection();
        return selection != null && selection.getFirstElement() != null ? selection.getFirstElement().toString() : "";
    }

    public void refreshViewer() {
        super.refresh();
        this.getCombo().pack(true);
        if (this.parentComposite != null && !this.parentComposite.isDisposed()) {
            this.parentComposite.pack(true);
            this.parentComposite.layout(true);
        }
        this.ltrColumn.refresh();
        this.getCombo().layout(true);
        if (this.rightCombo != null) {
            this.rightCombo.refresh();
        }
    }

    public String toString() {
        StringBuilder toString = new StringBuilder("Comboviewer " + ((Object)((Object)this)).getClass().getSimpleName());
        if (this.leftCombo != null) {
            toString.append(", leftCombo of type " + ((Object)((Object)this.leftCombo)).getClass().getSimpleName());
            toString.append(", selected: '" + this.leftCombo.getCurrentSelection());
            toString.append("', disposed: ");
            if (this.leftCombo.parentComposite != null) {
                toString.append(this.leftCombo.parentComposite.isDisposed());
            } else {
                toString.append("true");
            }
        } else {
            toString.append(", leftCombo is null");
        }
        return toString.toString();
    }

    protected String[] sortElementsByLabel(String[] typeIDs) {
        String[] result = new String[typeIDs.length];
        System.arraycopy(typeIDs, 0, result, 0, typeIDs.length);
        HashMap<String, String> translations = new HashMap<String, String>(typeIDs.length);
        String[] stringArray = typeIDs;
        int n = typeIDs.length;
        int n2 = 0;
        while (n2 < n) {
            String typeID = stringArray[n2];
            translations.put(typeID, this.ltrColumn.getContentService().getLabel(typeID));
            ++n2;
        }
        Arrays.sort(result, (o1, o2) -> ((String)translations.get(o1)).compareTo((String)translations.get(o2)));
        return result;
    }

    protected void selectFirstElement(boolean selectionChangedEvent) {
        this.getCombo().select(0);
        if (selectionChangedEvent) {
            this.selectionChanged(null);
        }
    }

    protected void refreshCombo() {
        this.getCombo().pack(true);
    }

    public String getColumnPath() {
        String message = this.getCurrentSelection();
        if (this.rightCombo != null) {
            message = String.valueOf(message) + this.rightCombo.getColumnPath();
        }
        return message;
    }

    public void setColumnPath(List<String> path) {
        if (!path.isEmpty()) {
            this.select(path.get(0));
            if (path.size() > 1) {
                this.createRightCombo();
                this.rightCombo.setColumnPath(path.subList(1, path.size()));
            }
        }
    }

    public void setColumnPath(String firstElement, List<String> path) {
        if (!path.isEmpty()) {
            this.select(firstElement);
            if (path.size() > 1) {
                this.createRightCombo();
                this.rightCombo.setColumnPath(path.subList(1, path.size()));
            }
        }
    }

    protected abstract void select(String var1);

    public Set<String> getAllUsedRelationIds() {
        HashSet<String> set = new HashSet<String>();
        set.addAll(this.doGetAllRelationTypes());
        if (this.rightCombo != null) {
            set.addAll(this.rightCombo.getAllUsedRelationIds());
        }
        return set;
    }

    protected abstract Set<String> doGetAllRelationTypes();

    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
        if (this.rightCombo != null) {
            this.rightCombo.setInteractive(interactive);
        }
    }
}

