/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.linktable.ui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import sernet.verinice.rcp.linktable.ui.LinkTableColumn;
import sernet.verinice.rcp.linktable.ui.LinkTableFieldListener;
import sernet.verinice.rcp.linktable.ui.Messages;
import sernet.verinice.rcp.linktable.ui.UpdateLinkTable;
import sernet.verinice.rcp.linktable.ui.multiselectiondialog.LinkTableMultiSelectionControl;
import sernet.verinice.service.linktable.ColumnPathParser;
import sernet.verinice.service.linktable.vlt.VeriniceLinkTable;
import sernet.verinice.service.model.IObjectModelService;

public class LinkTableComposite
extends Composite {
    private static final Logger logger = Logger.getLogger(LinkTableComposite.class);
    private static final Point DEFAULT_MARGIN = new Point(10, 10);
    private static final Point DEFAULT_MARGIN_CONTENT = new Point(10, 10);
    private VeriniceLinkTable veriniceLinkTable = null;
    private ArrayList<LinkTableColumn> columns = new ArrayList();
    private final Composite rootContainer;
    private Composite columnsContainer;
    private LinkTableColumn selectedColumn;
    private Composite mainBody;
    private Composite subBody;
    private ScrolledComposite scrolledBody;
    private LinkTableMultiSelectionControl multiControl;
    private Label loadingLabel;
    private ProgressBar progressBar;
    private IObjectModelService objectModelService;
    private List<LinkTableFieldListener> listeners = new ArrayList<LinkTableFieldListener>();
    private boolean fireUpdate = false;
    private boolean fireValidation = false;
    private int numCols = 0;
    private boolean useAllScopes = true;
    private boolean followLinksOutsideOfScope;

    public LinkTableComposite(VeriniceLinkTable vltContent, IObjectModelService objectModelService, Composite parent) {
        super(parent, 0);
        this.objectModelService = objectModelService;
        this.veriniceLinkTable = vltContent;
        this.useAllScopes = vltContent.useAllScopes();
        this.followLinksOutsideOfScope = vltContent.followLinksOutsideOfScope();
        this.rootContainer = new Composite((Composite)this, 0);
        this.createContent();
    }

    private void createContent() {
        this.numCols = 0;
        this.clearComposite(this.rootContainer);
        this.createFilterArea(this.rootContainer);
        this.createToolbar(this.rootContainer);
        this.createBody(this.rootContainer);
        this.rootContainer.setLayoutData((Object)new GridData(1808));
        this.getDefaultLayoutFactory().generateLayout(this.rootContainer);
        this.rootContainer.layout();
    }

    private void clearComposite(Composite composite) {
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        this.columns.clear();
    }

    private GridLayoutFactory getDefaultLayoutFactory() {
        return GridLayoutFactory.fillDefaults();
    }

    private void createFilterArea(Composite parent) {
        Composite filterArea = new Composite(parent, 2048);
        this.setScopeComposite(filterArea);
        this.setRelationsComposite(filterArea);
        this.getDefaultLayoutFactory().numColumns(2).margins(DEFAULT_MARGIN).generateLayout(filterArea);
    }

    private void setScopeComposite(Composite head) {
        Composite scopeButtons = new Composite(head, this.getStyle());
        final Button useAllScopesButton = new Button(scopeButtons, 16);
        useAllScopesButton.setText(Messages.VeriniceLinkTableComposite_0);
        useAllScopesButton.setToolTipText(Messages.VeriniceLinkTableComposite_Query_All_Scopes_ToolTip);
        Button useSelectedScopesButton = new Button(scopeButtons, 16);
        useSelectedScopesButton.setText(Messages.VeriniceLinkTableComposite_1);
        useSelectedScopesButton.setToolTipText(Messages.VeriniceLinkTableComposite_Query_Selected_Scopes_Only_ToolTip);
        final Button followLinksButton = new Button(scopeButtons, 16);
        followLinksButton.setText(Messages.VeriniceLinkTableComposite_Follow_Links_To_Other_Scopes);
        followLinksButton.setToolTipText(Messages.VeriniceLinkTableComposite_Follow_Links_To_Other_Scopes_ToolTip);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button selected = (Button)event.widget;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(String.valueOf(selected.getText()) + " is selected"));
                }
                LinkTableComposite.this.useAllScopes = selected == useAllScopesButton;
                LinkTableComposite.this.followLinksOutsideOfScope = selected == followLinksButton;
                LinkTableComposite.this.updateAndValidateVeriniceContent(UpdateLinkTable.USE_ALL_SCOPES, UpdateLinkTable.FOLLOW_LINKS_BUTTON);
            }
        };
        useAllScopesButton.addSelectionListener((SelectionListener)listener);
        useSelectedScopesButton.addSelectionListener((SelectionListener)listener);
        followLinksButton.addSelectionListener((SelectionListener)listener);
        useAllScopesButton.setSelection(this.useAllScopes && !this.followLinksOutsideOfScope);
        useSelectedScopesButton.setSelection(!this.useAllScopes && !this.followLinksOutsideOfScope);
        followLinksButton.setSelection(!this.useAllScopes && this.followLinksOutsideOfScope);
        this.getDefaultLayoutFactory().margins(DEFAULT_MARGIN).numColumns(1).generateLayout(scopeButtons);
    }

    private void setRelationsComposite(Composite head) {
        Composite multiControlContainer = new Composite(head, this.getStyle());
        this.multiControl = new LinkTableMultiSelectionControl(multiControlContainer, this);
        this.getDefaultLayoutFactory().numColumns(2).generateLayout(multiControlContainer);
        GridData multiControlContainerData = new GridData(2);
        multiControlContainer.setLayoutData((Object)multiControlContainerData);
        this.getDefaultLayoutFactory().numColumns(2).margins(DEFAULT_MARGIN).generateLayout(head);
    }

    private void createToolbar(Composite parent) {
        Composite toolbar = new Composite(parent, 0);
        Button moveUpButton = new Button(toolbar, 8);
        moveUpButton.setText(Messages.LinkTableComposite_moveUpButton);
        moveUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LinkTableComposite.this.moveUp();
            }
        });
        Button moveDownButton = new Button(toolbar, 8);
        moveDownButton.setText(Messages.LinkTableComposite_moveDownButton);
        moveDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LinkTableComposite.this.moveDown();
            }
        });
        Button addButton = new Button(toolbar, 8);
        addButton.setText(Messages.VeriniceLinkTableComposite_2);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LinkTableComposite.this.addColumn(null);
                LinkTableComposite.this.refresh(UpdateLinkTable.COLUMN_PATHS);
            }
        });
        Button duplicateButton = new Button(toolbar, 8);
        duplicateButton.setText(Messages.VeriniceLinkTableComposite_3);
        duplicateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LinkTableComposite.this.duplicate();
            }
        });
        Button removeButton = new Button(toolbar, 8);
        removeButton.setText(Messages.LinkTableComposite_removeButton);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LinkTableComposite.this.remove();
            }
        });
        this.getDefaultLayoutFactory().numColumns(5).generateLayout(toolbar);
    }

    private void createBody(Composite parent) {
        this.scrolledBody = new ScrolledComposite(parent, 2816);
        this.mainBody = new Composite((Composite)this.scrolledBody, this.getStyle());
        this.scrolledBody.setContent((Control)this.mainBody);
        this.scrolledBody.setExpandHorizontal(true);
        this.scrolledBody.setExpandVertical(true);
        this.scrolledBody.setLayoutData((Object)new GridData(1808));
        this.subBody = new Composite(this.mainBody, this.getStyle());
        this.columnsContainer = new Composite(this.subBody, this.getStyle());
        this.getDefaultLayoutFactory().generateLayout(this.columnsContainer);
        GridLayout secondLayout = new GridLayout(1, false);
        secondLayout.marginHeight = 0;
        secondLayout.marginWidth = 3;
        this.columnsContainer.setLayout((Layout)secondLayout);
        if (this.veriniceLinkTable.getColumnPaths() != null && !this.veriniceLinkTable.getColumnPaths().isEmpty()) {
            this.addProgressBar();
            this.addColumnsWithContent();
        } else {
            this.addColumn(null);
        }
        this.getDefaultLayoutFactory().margins(DEFAULT_MARGIN_CONTENT).generateLayout(this.subBody);
        this.getDefaultLayoutFactory().margins(0, 0).generateLayout(this.mainBody);
        this.getDefaultLayoutFactory().margins(DEFAULT_MARGIN).generateLayout((Composite)this.scrolledBody);
    }

    public void addProgressBar() {
        this.loadingLabel = new Label(this.columnsContainer, 0);
        this.loadingLabel.setText(Messages.LinkTableComposite_loading);
        this.progressBar = new ProgressBar(this.columnsContainer, 0);
        this.progressBar.setLayoutData((Object)new GridData(768));
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(this.veriniceLinkTable.getColumnPaths().size());
    }

    public void removeProgressBar() {
        this.loadingLabel.dispose();
        this.progressBar.dispose();
    }

    private void addColumnsWithContent() {
        this.progressBar.setSelection(0);
        Thread addColumnThread = new Thread(){

            @Override
            public void run() {
                for (String column : LinkTableComposite.this.veriniceLinkTable.getColumnPaths()) {
                    List path = ColumnPathParser.getColumnPathAsList((String)column, (boolean)true);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Element " + path));
                    }
                    LinkTableComposite.this.addColumn(path);
                    Display.getDefault().asyncExec(() -> LinkTableComposite.this.progressBar.setSelection(LinkTableComposite.this.progressBar.getSelection() + 1));
                }
                Display.getDefault().asyncExec(() -> {
                    LinkTableComposite.this.removeProgressBar();
                    LinkTableComposite.this.refresh(UpdateLinkTable.COLUMN_PATHS);
                    LinkTableComposite.this.disableFirstCombos();
                });
            }
        };
        addColumnThread.start();
    }

    private void disableFirstCombos() {
        if (this.columns == null) {
            return;
        }
        if (this.columns.size() > 1) {
            this.columns.stream().forEach(column -> column.getFirstCombo().getCombo().setEnabled(false));
        }
    }

    private void addColumn(List<String> path) {
        LinkTableColumn column;
        boolean isNewColumn = true;
        if (path == null) {
            column = new LinkTableColumn(this, this.getStyle(), ++this.numCols);
        } else {
            column = new LinkTableColumn(path, this, ++this.numCols);
            isNewColumn = false;
        }
        this.columns.add(column);
        if (isNewColumn) {
            this.configureColumns(true);
        }
    }

    private void configureColumns(boolean isNewColumn) {
        boolean oneColumn = this.columns.size() <= 1;
        LinkTableColumn firstColumn = this.columns.get(0);
        firstColumn.getFirstCombo().getCombo().setEnabled(oneColumn);
        if (!oneColumn) {
            LinkTableColumn lastColumn = this.columns.get(this.columns.size() - 1);
            lastColumn.getFirstCombo().getCombo().setEnabled(false);
            if (isNewColumn) {
                lastColumn.getFirstCombo().getCombo().select(firstColumn.getFirstCombo().getCombo().getSelectionIndex());
                lastColumn.getFirstCombo().selectionChanged(null);
            }
        } else if (isNewColumn) {
            firstColumn.getFirstCombo().getCombo().select(0);
            firstColumn.getFirstCombo().selectionChanged(null);
        }
    }

    private void renameColumns() {
        int columnCounter = 1;
        for (LinkTableColumn column : this.columns) {
            column.setColumnNumber(columnCounter++);
        }
    }

    public void refresh() {
        this.createContent();
        GridLayoutFactory.fillDefaults().generateLayout((Composite)this);
    }

    public void refresh(UpdateLinkTable ... updateVeriniceLinkTable) {
        this.columnsContainer.pack(true);
        this.subBody.pack(true);
        this.mainBody.pack(true);
        this.subBody.pack(true);
        this.scrolledBody.setMinSize(this.subBody.getClientArea().width, this.subBody.getClientArea().height);
        this.mainBody.layout(true);
        this.subBody.layout(true);
        this.columnsContainer.layout(true);
        this.updateAndValidateVeriniceContent(updateVeriniceLinkTable);
    }

    public void updateAndValidateVeriniceContent(UpdateLinkTable ... updateVeriniceLinkTable) {
        Set set = Stream.of(updateVeriniceLinkTable).collect(Collectors.toSet());
        if (this.veriniceLinkTable == null) {
            this.veriniceLinkTable = new VeriniceLinkTable.Builder().build();
        }
        this.fireValidation = false;
        this.fireUpdate = false;
        if (set.contains((Object)UpdateLinkTable.USE_ALL_SCOPES)) {
            this.updateUseAllScopes();
        }
        if (set.contains((Object)UpdateLinkTable.FOLLOW_LINKS_BUTTON)) {
            this.updateFollowLinksOutsideOfScope();
        }
        if (set.contains((Object)UpdateLinkTable.RELATION_IDS)) {
            this.updateRelationIds();
        }
        if (set.contains((Object)UpdateLinkTable.COLUMN_PATHS)) {
            this.updateColumnPaths();
        }
        if (this.fireUpdate) {
            this.fireFieldChangedEvent();
        }
        if (this.fireValidation) {
            this.fireValidationEvent();
        }
    }

    private void updateColumnPaths() {
        ArrayList<String> columnPaths = new ArrayList<String>(this.columns.size());
        for (LinkTableColumn column : this.columns) {
            String path = column.getColumnPath();
            columnPaths.add(path);
        }
        if (!this.veriniceLinkTable.getColumnPaths().equals(columnPaths)) {
            this.veriniceLinkTable.setColumnPaths(columnPaths);
            this.fireUpdate = true;
            this.fireValidation = true;
        }
    }

    private void updateUseAllScopes() {
        if (this.veriniceLinkTable.useAllScopes() != this.useAllScopes) {
            this.veriniceLinkTable.setAllScopes(this.useAllScopes);
            if (this.useAllScopes) {
                this.veriniceLinkTable.getScopeIds().clear();
            }
            this.fireUpdate = true;
        }
    }

    private void updateFollowLinksOutsideOfScope() {
        if (this.veriniceLinkTable.followLinksOutsideOfScope() != this.followLinksOutsideOfScope) {
            this.veriniceLinkTable.setFollowLinksOutsideOfScope(this.followLinksOutsideOfScope);
            this.fireUpdate = true;
        }
    }

    private void updateRelationIds() {
        if (this.multiControl != null) {
            ArrayList<String> relationIds = new ArrayList<String>(this.multiControl.getSelectedRelationIDs());
            if (!this.veriniceLinkTable.getRelationIds().equals(relationIds)) {
                this.veriniceLinkTable.setRelationIds(relationIds);
                this.fireUpdate = true;
            }
        }
    }

    private void moveUp() {
        int index = this.columns.indexOf(this.selectedColumn);
        if (index < 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Column " + this.selectedColumn + " not found"));
            }
            return;
        }
        if (index == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Column " + this.selectedColumn + " is first column, not possible to move up"));
            }
            return;
        }
        LinkTableColumn prevElement = this.columns.get(index - 1);
        this.columns.set(index - 1, this.selectedColumn);
        this.columns.set(index, prevElement);
        this.selectedColumn.getColumnContainer().moveAbove((Control)prevElement.getColumnContainer());
        this.renameColumns();
        this.refresh(UpdateLinkTable.COLUMN_PATHS);
    }

    private void moveDown() {
        int index = this.columns.indexOf(this.selectedColumn);
        if (index < 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Column " + this.selectedColumn + "not found"));
            }
            return;
        }
        if (index == this.columns.size() - 1) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Column " + this.selectedColumn + " is last column, not possible to move down"));
            }
            return;
        }
        LinkTableColumn nextElement = this.columns.get(index + 1);
        this.columns.set(index + 1, this.selectedColumn);
        this.columns.set(index, nextElement);
        this.selectedColumn.getColumnContainer().moveBelow((Control)nextElement.getColumnContainer());
        this.renameColumns();
        this.refresh(UpdateLinkTable.COLUMN_PATHS);
    }

    private void duplicate() {
        LinkTableColumn lastColumn = this.columns.get(this.columns.size() - 1);
        LinkTableColumn duplicatedColumn = new LinkTableColumn(lastColumn, ++this.numCols);
        this.columns.add(duplicatedColumn);
        this.configureColumns(false);
        this.refresh(UpdateLinkTable.COLUMN_PATHS);
    }

    private void remove() {
        if (this.selectedColumn == null) {
            return;
        }
        boolean delete = this.columns.remove(this.selectedColumn);
        this.configureColumns(false);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Deleted " + delete));
        }
        this.selectedColumn.getColumnContainer().dispose();
        this.numCols = this.columns.size();
        this.renameColumns();
        this.refresh(UpdateLinkTable.COLUMN_PATHS);
    }

    protected Composite getColumnsContainer() {
        return this.columnsContainer;
    }

    public void showComposite(Control composite) {
        this.scrolledBody.showControl(composite);
    }

    public VeriniceLinkTable getVeriniceLinkTable() {
        return this.veriniceLinkTable;
    }

    public void setVeriniceLinkTable(VeriniceLinkTable veriniceLinkTable) {
        this.veriniceLinkTable = veriniceLinkTable;
    }

    public Set<String> getAllUsedRelationIds() {
        HashSet<String> relationIDs = new HashSet<String>();
        for (LinkTableColumn column : this.columns) {
            relationIDs.addAll(column.getFirstCombo().getAllUsedRelationIds());
        }
        return relationIDs;
    }

    public IObjectModelService getContentService() {
        return this.objectModelService;
    }

    public void addListener(LinkTableFieldListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    private void fireFieldChangedEvent() {
        for (LinkTableFieldListener l : this.listeners) {
            l.fieldValueChanged();
        }
        this.fireUpdate = false;
    }

    public void fireValidationEvent() {
        for (LinkTableFieldListener listener : this.listeners) {
            listener.validate();
        }
        this.fireValidation = false;
    }

    public List<LinkTableColumn> getColumns() {
        return this.columns;
    }

    public void setSelectedColumn(LinkTableColumn selectedColumn) {
        this.selectedColumn = selectedColumn;
    }
}

