/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.linktable.ui;

import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import sernet.verinice.rcp.linktable.ui.LinkTableComposite;
import sernet.verinice.rcp.linktable.ui.UpdateLinkTable;
import sernet.verinice.rcp.linktable.ui.combo.LinkTableElementComboViewer;
import sernet.verinice.rcp.linktable.ui.combo.LinkTableOperationType;
import sernet.verinice.service.linktable.ColumnPathParser;
import sernet.verinice.service.model.HUIObjectModelService;
import sernet.verinice.service.model.IObjectModelService;

public class LinkTableColumn {
    private static final Logger logger = Logger.getLogger(LinkTableColumn.class);
    public static final int DEFAULT_GAP = 6;
    private LinkTableComposite ltrParent;
    private int columnNumber;
    private String name;
    private String alias;
    private Button deleteButton;
    private Composite columnContainer;
    private Button selectButton;
    private IObjectModelService contentService;
    private LinkTableElementComboViewer firstCombo;
    private static final Pattern COLUMN_NAVIGATOR_TOKEN = Pattern.compile("[.<>/:]");

    public LinkTableColumn(LinkTableColumn copy, int number) {
        this.ltrParent = copy.ltrParent;
        this.columnNumber = number;
        this.contentService = copy.getContentService();
        this.createColumn();
        this.firstCombo = (LinkTableElementComboViewer)copy.getFirstCombo().copy(null, this.columnContainer, (Control)this.selectButton, this);
    }

    public LinkTableColumn(LinkTableComposite parent, int style, int number) {
        this.ltrParent = parent;
        this.columnNumber = number;
        this.contentService = parent.getContentService();
        this.createColumn();
        this.addFirstCombo();
    }

    public LinkTableColumn(List<String> path, LinkTableComposite parent, int number) {
        this.ltrParent = parent;
        this.columnNumber = number;
        this.contentService = parent.getContentService();
        Display.getDefault().asyncExec(() -> {
            this.createColumn();
            this.addFirstCombo();
            this.firstCombo.setInteractive(false);
            this.firstCombo.setColumnPath(ColumnPathParser.removeAlias((List)path));
            this.alias = ColumnPathParser.extractAlias((List)path);
            this.firstCombo.setInteractive(true);
        });
    }

    private void addFirstCombo() {
        this.firstCombo = new LinkTableElementComboViewer(this, this.columnContainer);
        FormData comboData = new FormData();
        comboData.left = new FormAttachment((Control)this.selectButton, 6);
        comboData.top = new FormAttachment((Control)this.selectButton, 0, 0x1000000);
        this.firstCombo.getCombo().setLayoutData((Object)comboData);
        this.columnContainer.layout(true);
    }

    private void createColumn() {
        this.columnContainer = new Composite(this.ltrParent.getColumnsContainer(), 0x400000);
        FormLayout layoutColumn = new FormLayout();
        layoutColumn.marginHeight = 5;
        layoutColumn.marginWidth = 0;
        this.columnContainer.setLayout((Layout)layoutColumn);
        SelectColumnListener radioGroup = new SelectColumnListener(this);
        this.selectButton = new Button(this.columnContainer, 16);
        FormData selectButtonFormData = new FormData();
        this.selectButton.setLayoutData((Object)selectButtonFormData);
        this.selectButton.addListener(13, (Listener)radioGroup);
    }

    public void setColumnNumber(int num) {
        this.columnNumber = num;
        this.columnContainer.pack(true);
        this.columnContainer.layout(true);
    }

    Button getDeleteButton() {
        return this.deleteButton;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.columnNumber;
        result = 31 * result + (this.selectButton == null ? 0 : this.selectButton.hashCode());
        result = 31 * result + (this.ltrParent == null ? 0 : ((Object)((Object)this.ltrParent)).hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LinkTableColumn other = (LinkTableColumn)obj;
        if (this.columnNumber != other.columnNumber) {
            return false;
        }
        if (this.selectButton == null ? other.selectButton != null : !this.selectButton.equals(other.selectButton)) {
            return false;
        }
        if (this.ltrParent == null ? other.ltrParent != null : !((Object)((Object)this.ltrParent)).equals((Object)other.ltrParent)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public Composite getColumnContainer() {
        return this.columnContainer;
    }

    public void refresh() {
        if (!this.columnContainer.isDisposed()) {
            this.columnContainer.pack(true);
            this.columnContainer.layout(true);
        }
        this.ltrParent.refresh(UpdateLinkTable.COLUMN_PATHS);
    }

    public LinkTableElementComboViewer getFirstCombo() {
        return this.firstCombo;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public IObjectModelService getContentService() {
        return this.contentService;
    }

    public LinkTableComposite getLtrParent() {
        return this.ltrParent;
    }

    public void clearAlias() {
        this.alias = null;
    }

    public String getColumnPath() {
        String columnPath = this.firstCombo.getColumnPath();
        if (this.alias == null) {
            this.alias = this.buildAlias(columnPath);
        }
        return String.valueOf(columnPath) + " AS " + this.alias;
    }

    private String buildAlias(String columnPath) {
        String message;
        String[] columnPathElements = COLUMN_NAVIGATOR_TOKEN.split(columnPath);
        int numberOfTokens = columnPathElements.length;
        if (numberOfTokens >= 2) {
            String propertyId = columnPathElements[numberOfTokens - 1];
            String element = columnPathElements[numberOfTokens - 2];
            if (logger.isDebugEnabled()) {
                logger.debug((Object)columnPath);
                logger.debug((Object)("Element:" + element));
                logger.debug((Object)("Property:" + propertyId));
            }
            message = columnPath.contains(LinkTableOperationType.RELATION.getOutput()) ? HUIObjectModelService.getCnaLinkPropertyMessage((String)propertyId) : String.valueOf(this.getContentService().getLabel(propertyId)) + " (" + this.getContentService().getLabel(element) + ")";
        } else {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Cannot use String split approach for column path " + columnPath + ", using old way"));
            }
            int propertyBeginning = columnPath.lastIndexOf(LinkTableOperationType.PROPERTY.getOutput());
            String propertyId = columnPath.substring(propertyBeginning + 1);
            message = columnPath.contains(":") ? HUIObjectModelService.getCnaLinkPropertyMessage((String)propertyId) : this.getContentService().getLabel(propertyId);
        }
        message = StringUtils.replaceEachRepeatedly((String)message, (String[])new String[]{"/", ":", ".", "<", ">"}, (String[])new String[]{"", "", "", "", ""});
        message = message.replace(" ", "__");
        return message;
    }

    public Button getSelectButton() {
        return this.selectButton;
    }

    private final class SelectColumnListener
    implements Listener {
        private LinkTableColumn selectedColumn;

        public SelectColumnListener(LinkTableColumn selectedColumn) {
            this.selectedColumn = selectedColumn;
        }

        public void handleEvent(Event event) {
            for (LinkTableColumn column : LinkTableColumn.this.ltrParent.getColumns()) {
                column.getSelectButton().setSelection(false);
            }
            Button selectedButton = (Button)event.widget;
            selectedButton.setSelection(true);
            LinkTableColumn.this.ltrParent.setSelectedColumn(this.selectedColumn);
        }
    }
}

