/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.linktable.ui;

import java.io.File;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import sernet.gs.service.FileUtil;
import sernet.gs.service.StringUtil;
import sernet.gs.ui.rcp.main.Activator;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.iso27k.rcp.ScopeMultiselectWidget;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.rcp.linktable.LinkTableUtil;
import sernet.verinice.rcp.linktable.ui.Messages;
import sernet.verinice.service.linktable.vlt.VeriniceLinkTable;

public class CsvExportDialog
extends TitleAreaDialog {
    private static final Logger LOG = Logger.getLogger(CsvExportDialog.class);
    private static final String DEFAULT_ORGANIZATION_TITLE = "organization";
    private ITreeSelection selection;
    private CnATreeElement selectedElement;
    private String filePath;
    private ScopeMultiselectWidget organizationWidget = null;
    private Text txtLocation;
    private String defaultFolder;
    private String organizationTitle = "organization";
    private VeriniceLinkTable veriniceLinkTable;
    private String label;

    public CsvExportDialog(Shell activeShell, String label, VeriniceLinkTable veriniceLinkTable) {
        this(activeShell, null, label, veriniceLinkTable);
    }

    public CsvExportDialog(Shell activeShell, CnATreeElement selectedOrganization, String label, VeriniceLinkTable veriniceLinkTable) {
        super(activeShell);
        this.label = label;
        this.veriniceLinkTable = veriniceLinkTable;
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.selectedElement = selectedOrganization;
    }

    protected Control createDialogArea(Composite parent) {
        int layoutMargin = 10;
        int sourceIdCompositeNumColumns = 3;
        int sourceIdCompositeMarginTop = 15;
        int txtLocationMinimumWidth = 302;
        this.initDefaultFolder();
        this.setTitle(Messages.CsvExportDialog_0);
        this.setMessage(Messages.CsvExportDialog_1, 1);
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        GridData gd = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gd);
        try {
            this.organizationWidget = new ScopeMultiselectWidget(composite, this.selection, this.selectedElement);
            this.setOrgTitle();
        }
        catch (CommandException ex) {
            LOG.error((Object)"Error while loading organizations", (Throwable)ex);
            this.setMessage(Messages.CsvExportDialog_4, 3);
            return null;
        }
        this.addOrganizationelectionListener();
        Composite sourceIdComposite = new Composite(composite, 0);
        sourceIdComposite.setLayout((Layout)new GridLayout(3, false));
        ((GridLayout)sourceIdComposite.getLayout()).marginTop = 15;
        gd = new GridData(4, 1024, true, false);
        gd.grabExcessHorizontalSpace = true;
        sourceIdComposite.setLayoutData((Object)gd);
        Label labelLocation = new Label(sourceIdComposite, 0);
        labelLocation.setText(Messages.CsvExportDialog_6);
        this.txtLocation = new Text(sourceIdComposite, 2060);
        gd = new GridData(4, 128, true, false);
        gd.grabExcessHorizontalSpace = true;
        gd.minimumWidth = 302;
        this.txtLocation.setLayoutData((Object)gd);
        this.txtLocation.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                CsvExportDialog.this.filePath = CsvExportDialog.this.txtLocation.getText();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        Button buttonBrowseLocations = new Button(sourceIdComposite, 0);
        buttonBrowseLocations.setText(Messages.CsvExportDialog_7);
        buttonBrowseLocations.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CsvExportDialog.this.filePath = LinkTableUtil.createCsvFilePath(CsvExportDialog.this.getShell(), CsvExportDialog.this.label, CsvExportDialog.this.organizationTitle);
                CsvExportDialog.this.txtLocation.setText(CsvExportDialog.this.filePath);
            }
        });
        if (this.organizationWidget.getSelectedElement() != null) {
            this.filePath = String.valueOf(this.defaultFolder) + this.organizationTitle + this.getDefaultExtension();
            this.txtLocation.setText(this.filePath);
        }
        composite.pack();
        return composite;
    }

    private void addOrganizationelectionListener() {
        SelectionAdapter organizationListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button checkbox = (Button)e.getSource();
                if (checkbox.getSelection()) {
                    CsvExportDialog.this.changeFilePathToCurrentSelection();
                }
                super.widgetSelected(e);
            }
        };
        this.organizationWidget.addSelectionListener((SelectionListener)organizationListener);
    }

    private void changeFilePathToCurrentSelection() {
        this.setOrgTitle();
        if (this.txtLocation != null) {
            this.filePath = this.isFilepath() ? String.valueOf(FileUtil.getFolderFromPath((String)this.txtLocation.getText())) + this.organizationTitle + this.getDefaultExtension() : String.valueOf(this.defaultFolder) + this.organizationTitle + this.getDefaultExtension();
            this.txtLocation.setText(this.filePath);
        }
    }

    private void setOrgTitle() {
        String title = null;
        if (this.organizationWidget.getSelectedElement() != null) {
            title = ((CnATreeElement)this.organizationWidget.getSelectedElement()).getTitle();
        }
        this.organizationTitle = title != null ? StringUtil.convertToFileName(title) : DEFAULT_ORGANIZATION_TITLE;
    }

    private boolean isFilepath() {
        return this.txtLocation != null && this.txtLocation.getText() != null && !this.txtLocation.getText().isEmpty();
    }

    private String initDefaultFolder() {
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        this.defaultFolder = prefs.getString("default_folder_csv_export");
        if (this.defaultFolder == null || this.defaultFolder.isEmpty()) {
            this.defaultFolder = System.getProperty("user.home");
        }
        if (!this.defaultFolder.endsWith(System.getProperty("file.separator"))) {
            this.defaultFolder = String.valueOf(this.defaultFolder) + System.getProperty("file.separator");
        }
        return this.defaultFolder;
    }

    private String getDefaultExtension() {
        return ".csv";
    }

    protected void okPressed() {
        String errorMessage = this.createErrorMessage();
        if (errorMessage != null && !errorMessage.isEmpty()) {
            this.showErrorMessage(errorMessage);
        } else {
            this.checkIfFileExistAndSave();
        }
    }

    private void checkIfFileExistAndSave() {
        File file = new File(this.filePath);
        if (file.exists() && !file.isDirectory()) {
            MessageDialog mDialog = new MessageDialog(this.getShell(), NLS.bind((String)Messages.CsvExportDialog_9, (Object)file.getName()), null, NLS.bind((String)Messages.CsvExportDialog_14, (Object)file.getParentFile().getName()), 4, new String[]{Messages.CsvExportDialog_16, Messages.CsvExportDialog_17}, 0);
            int result = mDialog.open();
            if (result == 0) {
                this.saveScopeIdsAndCloseDialog();
            }
        } else {
            this.saveScopeIdsAndCloseDialog();
        }
    }

    private void saveScopeIdsAndCloseDialog() {
        this.veriniceLinkTable.clearScopeIds();
        for (CnATreeElement element : this.getSelectedElementSet()) {
            this.veriniceLinkTable.addScopeId(element.getDbId());
        }
        super.okPressed();
    }

    private String createErrorMessage() {
        StringBuilder sb = new StringBuilder();
        if (this.filePath == null || this.filePath.isEmpty()) {
            sb.append(Messages.CsvExportDialog_10);
        }
        if (this.organizationWidget.getSelectedElement() == null) {
            sb.append(Messages.CsvExportDialog_12);
        }
        return sb.toString();
    }

    private void showErrorMessage(String message) {
        StringBuilder sb = new StringBuilder(message);
        sb.append("\n");
        sb.append(Messages.CsvExportDialog_13);
        this.setMessage(sb.toString(), 3);
    }

    public String getFilePath() {
        return this.filePath;
    }

    private Set<CnATreeElement> getSelectedElementSet() {
        return this.organizationWidget.getSelectedElementSet();
    }
}

