/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.linktable.handlers;

import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import sernet.gs.ui.rcp.main.StatusLine;
import sernet.gs.ui.rcp.main.bsi.editors.EditorFactory;
import sernet.verinice.rcp.RightsEnabledHandler;
import sernet.verinice.rcp.linktable.EditorCloseException;
import sernet.verinice.rcp.linktable.LinkTableEditorInput;
import sernet.verinice.rcp.linktable.LinkTableUtil;
import sernet.verinice.rcp.linktable.Messages;

public abstract class LinkTableHandler
extends RightsEnabledHandler {
    private static final Logger LOG = Logger.getLogger(LinkTableHandler.class);

    public LinkTableHandler() {
        super(false);
    }

    public String getRightID() {
        return "exportlinktable";
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (this.checkRights()) {
            LinkTableEditorInput veriniceLinkTable = this.createLinkTable();
            StatusLine.setMessage("Opening report query " + veriniceLinkTable.getName() + "...");
            if (veriniceLinkTable != null) {
                Display.getDefault().asyncExec(() -> {
                    this.validateInputAndOpenEditor(veriniceLinkTable);
                    StatusLine.setMessage("");
                });
            }
        } else {
            MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"Error", (String)Messages.ExportLinkTableHandler_1);
        }
        return null;
    }

    private void validateInputAndOpenEditor(LinkTableEditorInput veriniceLinkTable) {
        try {
            MessageDialog confirmInvalidInput;
            int open;
            if (!LinkTableUtil.isValidVeriniceLinkTable(veriniceLinkTable.getInput()).isValid() && (open = (confirmInvalidInput = new MessageDialog(Display.getCurrent().getActiveShell(), Messages.LinkTableHandler_1, null, String.valueOf(Messages.LinkTableHandler_2) + Messages.LinkTableHandler_3, 3, new String[]{Messages.LinkTableHandler_4, Messages.LinkTableHandler_5}, 0)).open()) != 0) {
                return;
            }
            EditorFactory.getInstance().updateAndOpenObject(veriniceLinkTable);
        }
        catch (Exception e) {
            if (e.getCause() instanceof EditorCloseException) {
                EditorCloseException ex = (EditorCloseException)e.getCause();
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor(ex.getEditor(), true);
            }
            throw e;
        }
    }

    protected abstract LinkTableEditorInput createLinkTable();
}

