/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.linktable.handlers;

import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.preferences.PreferenceConstants;
import sernet.verinice.iso27k.rcp.JobScheduler;
import sernet.verinice.iso27k.rcp.Mutex;
import sernet.verinice.rcp.RightsEnabledHandler;
import sernet.verinice.rcp.jobs.VeriniceWorkspaceJob;
import sernet.verinice.rcp.linktable.LinkTableUtil;
import sernet.verinice.rcp.linktable.Messages;
import sernet.verinice.service.csv.CsvExport;
import sernet.verinice.service.csv.ICsvExport;
import sernet.verinice.service.linktable.ILinkTableConfiguration;
import sernet.verinice.service.linktable.LinkTableService;
import sernet.verinice.service.linktable.LinkedTableCreator;
import sernet.verinice.service.linktable.generator.GraphLinkedTableCreator;
import sernet.verinice.service.linktable.vlt.VeriniceLinkTable;
import sernet.verinice.service.linktable.vlt.VeriniceLinkTableIO;

public class ExportLinkTableHandler
extends RightsEnabledHandler {
    private LinkTableService linkTableService;
    private ICsvExport csvExportHandler = new CsvExport();
    private Shell shell = null;
    private boolean fromEditor;
    private VeriniceLinkTable veriniceLinkTable;
    private String csvFilePath;
    private LinkedTableCreator linkedTableCreator;

    public ExportLinkTableHandler() {
        this(false, null);
    }

    public ExportLinkTableHandler(boolean fromEditor, VeriniceLinkTable veriniceLinkTable) {
        super(false);
        this.fromEditor = fromEditor;
        this.veriniceLinkTable = veriniceLinkTable;
        this.linkTableService = new LinkTableService();
        this.linkedTableCreator = new GraphLinkedTableCreator();
        this.linkTableService.setLinkTableCreator(this.linkedTableCreator);
        this.csvExportHandler.setCharset(PreferenceConstants.getCharsetPreference("vlt_csv_export_encoding"));
    }

    public String getRightID() {
        return "exportlinktable";
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (this.checkRights()) {
            this.exportToCsv();
        } else {
            MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"Error", (String)Messages.ExportLinkTableHandler_1);
        }
        return null;
    }

    protected VeriniceLinkTable createLinkTable() {
        this.setShell();
        String filePath = LinkTableUtil.createVltFilePath(this.shell, Messages.ExportLinkTableHandler_2, 4096, null);
        VeriniceLinkTable veriniceLinkTableTemp = null;
        if (filePath != null) {
            veriniceLinkTableTemp = VeriniceLinkTableIO.read((String)filePath);
        }
        return veriniceLinkTableTemp;
    }

    public void setShell() {
        if (Display.getCurrent().getActiveShell() != null) {
            this.shell = Display.getCurrent().getActiveShell();
        }
    }

    private void exportToCsv() {
        this.setShell();
        if (!this.fromEditor) {
            this.veriniceLinkTable = this.createLinkTable();
        }
        if (this.veriniceLinkTable == null) {
            return;
        }
        this.csvFilePath = this.veriniceLinkTable.useAllScopes() ? LinkTableUtil.createCsvFilePath(this.shell, Messages.ExportLinkTableHandler_3, null) : LinkTableUtil.createCsvFilePathAndHandleScopes(this.shell, Messages.ExportLinkTableHandler_3, this.veriniceLinkTable);
        if (this.csvFilePath != null) {
            VeriniceWorkspaceJob job = new VeriniceWorkspaceJob(Messages.ExportLinkTableHandler_4, Messages.ExportLinkTableHandler_5){

                @Override
                protected void doRunInWorkspace() {
                    if (ExportLinkTableHandler.this.csvFilePath != null) {
                        Activator.inheritVeriniceContextState();
                        ILinkTableConfiguration conf = VeriniceLinkTableIO.createLinkTableConfiguration((VeriniceLinkTable)ExportLinkTableHandler.this.veriniceLinkTable);
                        List table = ExportLinkTableHandler.this.linkTableService.createTable(conf);
                        ExportLinkTableHandler.this.csvExportHandler.setFilePath(ExportLinkTableHandler.this.csvFilePath);
                        ExportLinkTableHandler.this.csvExportHandler.exportToFile(ExportLinkTableHandler.this.csvExportHandler.convert(table));
                    }
                }
            };
            JobScheduler.scheduleJob(job, new Mutex());
        }
    }
}

