/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.linktable;

import java.io.File;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import sernet.gs.ui.rcp.main.Activator;
import sernet.verinice.rcp.linktable.LinkTableValidationResult;
import sernet.verinice.rcp.linktable.Messages;
import sernet.verinice.rcp.linktable.ui.CsvExportDialog;
import sernet.verinice.rcp.linktable.ui.combo.LinkTableOperationType;
import sernet.verinice.service.linktable.ColumnPathParseException;
import sernet.verinice.service.linktable.ColumnPathParser;
import sernet.verinice.service.linktable.vlt.VeriniceLinkTable;
import sernet.verinice.service.model.HUIObjectModelLoader;
import sernet.verinice.service.model.IObjectModelService;
import sernet.verinice.service.model.ObjectModelValidationException;

public class LinkTableUtil {
    private static final Logger LOG = Logger.getLogger(LinkTableUtil.class);
    private static HashMap<String, String> vltExtensions = null;
    private static HashMap<String, String> csvExtensions = null;
    private static CsvExportDialog csvDialog;
    private static IObjectModelService loader;
    private static final String ALIAS_DELIMITER = " AS ";

    static {
        if (vltExtensions == null) {
            vltExtensions = new HashMap();
            vltExtensions.put("*.vlt", "verinice link table (.vlt)");
        }
        if (csvExtensions == null) {
            csvExtensions = new HashMap();
            csvExtensions.put("*.csv", "CSV table (.csv)");
        }
    }

    private LinkTableUtil() {
    }

    public static String createFilePath(Shell shell, String text, String defaultFolderPreference, Map<String, String> filterExtensions, int style, String defaultFileName) {
        FileDialog dialog = new FileDialog(shell, style);
        String extension = filterExtensions.keySet().iterator().next().substring(1);
        dialog.setText(text);
        dialog.setFilterPath(LinkTableUtil.getDirectory(defaultFolderPreference));
        String filename = defaultFileName != null && style == 8192 ? defaultFileName : String.valueOf(Messages.LinkTableUtil_1) + extension;
        filename = LinkTableUtil.addExtensionIfMissing(extension, filename);
        dialog.setFileName(filename);
        ArrayList<String> extensions = new ArrayList<String>(filterExtensions.keySet());
        extensions.add("*.*");
        dialog.setFilterExtensions(extensions.toArray(new String[0]));
        ArrayList<String> extensionNames = new ArrayList<String>(filterExtensions.values());
        extensionNames.add(Messages.VeriniceLinkTableUtil_1);
        dialog.setFilterNames(extensionNames.toArray(new String[0]));
        dialog.setFilterIndex(0);
        dialog.setOverwrite(true);
        String filePath = dialog.open();
        if (filePath != null) {
            File file = new File(filePath);
            String dir = file.getParent();
            Activator.getDefault().getPreferenceStore().setValue(defaultFolderPreference, dir);
        }
        filePath = LinkTableUtil.addExtensionIfMissing(extension, filePath);
        return filePath;
    }

    private static String addExtensionIfMissing(String extension, String filePath) {
        if (filePath != null && !filePath.endsWith(extension)) {
            filePath = String.valueOf(filePath) + extension;
            return filePath;
        }
        return filePath;
    }

    public static String createFilePath(Shell shell, String text, String defaultFolderPreference, Map<String, String> filterExtensions, int style) {
        return LinkTableUtil.createFilePath(shell, text, defaultFolderPreference, filterExtensions, style, null);
    }

    private static String getDirectory(String defaultFolderPreference) {
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        String dir = prefs.getString(defaultFolderPreference);
        if (dir == null || dir.isEmpty()) {
            dir = System.getProperty("user.home");
        }
        if (!dir.endsWith(System.getProperty("file.separator"))) {
            dir = String.valueOf(dir) + System.getProperty("file.separator");
        }
        return dir;
    }

    public static String createVltFilePath(Shell shell, String text, int style, String defaultFileName) {
        return LinkTableUtil.createFilePath(shell, text, "default_folder_vlt_export", vltExtensions, style, defaultFileName);
    }

    public static String createCsvFilePath(Shell shell, String text, String defaultFileName) {
        return LinkTableUtil.createFilePath(shell, text, "default_folder_csv_export", csvExtensions, 8192, defaultFileName);
    }

    public static String createCsvFilePathAndHandleScopes(Shell shell, String text, VeriniceLinkTable veriniceLinkTable) {
        csvDialog = new CsvExportDialog(Display.getCurrent().getActiveShell(), text, veriniceLinkTable);
        if (csvDialog.open() == 0) {
            return csvDialog.getFilePath();
        }
        return null;
    }

    public static LinkTableValidationResult isValidVeriniceLinkTable(VeriniceLinkTable veriniceLinkTable) {
        LinkTableValidationResult result = new LinkTableValidationResult();
        result.setValid(true);
        try {
            LinkTableUtil.validateColumnPathsElements(veriniceLinkTable.getColumnPaths());
            LinkTableUtil.validateRelationIds(veriniceLinkTable.getRelationIds());
            LinkTableUtil.validateRelations(veriniceLinkTable.getColumnPaths());
        }
        catch (ObjectModelValidationException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)e);
            }
            result.setValid(false);
            result.setMessage(e.getMessage());
        }
        return result;
    }

    private static void validateRelations(List<String> columnPaths) throws ObjectModelValidationException {
        Set<Map.Entry<String, String>> relations = LinkTableUtil.getRelations(columnPaths);
        for (Map.Entry<String, String> relation : relations) {
            Set possibleRelationPartners = LinkTableUtil.getLoader().getPossibleRelationPartners(relation.getKey());
            if (possibleRelationPartners.contains(relation.getValue())) continue;
            throw new ObjectModelValidationException("Relation " + relation.toString() + " not found");
        }
    }

    private static void validateColumnPathsElements(List<String> list) throws ObjectModelValidationException {
        for (String path : list) {
            try {
                LinkTableUtil.validateColumnPath(path);
            }
            catch (Exception e) {
                throw new ObjectModelValidationException(String.valueOf(path) + Messages.LinkTableUtil_2, e);
            }
        }
    }

    public static void validateColumnPath(String path) throws ObjectModelValidationException {
        try {
            ColumnPathParser.throwExceptionIfInvalid((String)path);
        }
        catch (ColumnPathParseException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)e);
            }
            throw new ObjectModelValidationException(String.valueOf(path) + " is no valid column path", (Exception)((Object)e));
        }
        Set objectTypeIds = ColumnPathParser.getObjectTypeIds((String)path);
        for (String id : objectTypeIds) {
            boolean validTypeId = LinkTableUtil.getLoader().isValidTypeId(id);
            if (validTypeId) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(String.valueOf(id) + " is no typeId"));
            }
            throw new ObjectModelValidationException(String.valueOf(validTypeId) + " is no valid type ID");
        }
    }

    public static Set<Map.Entry<String, String>> getRelations(List<String> columnPathes) {
        HashSet<Map.Entry<String, String>> relations = new HashSet<Map.Entry<String, String>>();
        for (String path : columnPathes) {
            List pathElements = ColumnPathParser.getColumnPathAsList((String)path);
            int index = 0;
            for (String element : pathElements) {
                if (LinkTableOperationType.isRelation(element)) {
                    relations.add(new AbstractMap.SimpleEntry<String, String>((String)pathElements.get(index - 1), (String)pathElements.get(index + 1)));
                }
                ++index;
            }
        }
        return relations;
    }

    private static void validateRelationIds(List<String> list) throws ObjectModelValidationException {
        for (String id : list) {
            if (LinkTableUtil.getLoader().isValidRelationId(id)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(String.valueOf(id) + " is no RelationID"));
            }
            throw new ObjectModelValidationException(String.valueOf(id) + " is no valid relation id");
        }
    }

    public static String getCnaLinkPropertyMessage(String cnaLinkProperty) {
        switch (cnaLinkProperty) {
            case "title": {
                return Messages.LinkTableColumn_CnaLink_Property_Title;
            }
            case "description": {
                return Messages.LinkTableColumn_CnaLink_Property_Description;
            }
            case "risk-value-c": {
                return Messages.LinkTableColumn_CnaLink_Property_C;
            }
            case "risk-value-i": {
                return Messages.LinkTableColumn_CnaLink_Property_I;
            }
            case "risk-value-a": {
                return Messages.LinkTableColumn_CnaLink_Property_A;
            }
            case "risk-value-c-with-controls": {
                return Messages.LinkTableColumn_CnaLink_Property_C_With_Controls;
            }
            case "risk-value-i-with-controls": {
                return Messages.LinkTableColumn_CnaLink_Property_I_With_Controls;
            }
            case "risk-value-a-with-controls": {
                return Messages.LinkTableColumn_CnaLink_Property_A_With_Controls;
            }
            case "risk-treatment": {
                return Messages.LinkTableColumn_CnaLink_Property_Risk_Treatment;
            }
        }
        return Messages.LinkTableColumn_CnaLink_Property_Unknown;
    }

    public static String createAlias(String columnPath) {
        String message;
        String[] columnPathElements = columnPath.split("\\.|\\<|\\>|\\/|\\:");
        int lastElement = columnPathElements.length - 1;
        try {
            String propertyId = columnPathElements[lastElement];
            String element = columnPathElements[lastElement - 1];
            LOG.debug((Object)columnPath);
            LOG.debug((Object)("Element:" + columnPathElements[lastElement - 1]));
            LOG.debug((Object)("Property:" + propertyId));
            message = columnPath.contains(LinkTableOperationType.RELATION.getOutput()) ? LinkTableUtil.getCnaLinkPropertyMessage(propertyId) : String.valueOf(loader.getLabel(propertyId)) + " (" + loader.getLabel(element) + ")";
        }
        catch (IndexOutOfBoundsException e) {
            LOG.warn((Object)("String-split did not work, using old way, column path: " + columnPath));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Stackstrace: ", (Throwable)e);
            }
            int propertyBeginning = columnPath.lastIndexOf(LinkTableOperationType.PROPERTY.getOutput());
            String propertyId = columnPath.substring(propertyBeginning + 1);
            message = columnPath.contains(":") ? LinkTableUtil.getCnaLinkPropertyMessage(propertyId) : loader.getLabel(propertyId);
        }
        message = StringUtils.replaceEachRepeatedly((String)message, (String[])new String[]{"/", ":", ".", "<", ">"}, (String[])new String[]{"", "", "", "", ""});
        message = message.replace(" ", "_");
        return String.valueOf(columnPath) + ALIAS_DELIMITER + message;
    }

    public static IObjectModelService getLoader() {
        if (loader == null) {
            loader = LinkTableUtil.createLoader();
        }
        return loader;
    }

    private static IObjectModelService createLoader() {
        loader = HUIObjectModelLoader.getInstance();
        return loader;
    }
}

