/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.linktable;

import java.util.UUID;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.PlatformUI;
import sernet.verinice.rcp.linktable.LinkTableEditor;
import sernet.verinice.service.linktable.vlt.VeriniceLinkTable;

public class LinkTableEditorInput
implements IEditorInput {
    private static final String TOOL_TIP_DEFAULT = "";
    private VeriniceLinkTable veriniceLinkTable;
    private String filePath;
    private String uuid;

    public LinkTableEditorInput(VeriniceLinkTable veriniceLinkTable) {
        this.veriniceLinkTable = veriniceLinkTable;
        this.uuid = UUID.randomUUID().toString();
    }

    public String getName() {
        return LinkTableEditor.getEditorTitle(this.getFilePath());
    }

    public ImageDescriptor getImageDescriptor() {
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE");
    }

    public String getToolTipText() {
        String toolTip = this.getFilePath();
        if (toolTip == null) {
            toolTip = TOOL_TIP_DEFAULT;
        }
        return toolTip;
    }

    public Object getAdapter(Class arg0) {
        return null;
    }

    public boolean exists() {
        return this.getFilePath() != null;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.filePath == null ? 0 : this.filePath.hashCode());
        result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LinkTableEditorInput other = (LinkTableEditorInput)obj;
        if (this.filePath == null ? other.filePath != null : !this.filePath.equals(other.filePath)) {
            return false;
        }
        return !(this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid));
    }

    public String getId() {
        String id = this.getFilePath();
        if (id == null) {
            id = this.uuid;
        }
        return id;
    }

    public VeriniceLinkTable getInput() {
        return this.veriniceLinkTable;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }
}

