/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.linktable;

import java.io.File;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.gs.ui.rcp.main.bsi.editors.EditorRegistry;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.rcp.linktable.LinkTableEditorInput;
import sernet.verinice.rcp.linktable.LinkTableUtil;
import sernet.verinice.rcp.linktable.LinkTableValidationResult;
import sernet.verinice.rcp.linktable.Messages;
import sernet.verinice.rcp.linktable.handlers.ExportLinkTableHandler;
import sernet.verinice.rcp.linktable.ui.LinkTableComposite;
import sernet.verinice.rcp.linktable.ui.LinkTableFieldListener;
import sernet.verinice.service.linktable.vlt.VeriniceLinkTable;
import sernet.verinice.service.linktable.vlt.VeriniceLinkTableIO;

public class LinkTableEditor
extends EditorPart {
    public static final String EDITOR_ID = LinkTableEditor.class.getName();
    public static final String TITLE_DEFAULT = Messages.LinkTableEditor_0;
    private static final Logger LOG = Logger.getLogger(LinkTableEditor.class);
    private LinkTableEditorInput linkTableEditorInput;
    private boolean isDirty = false;
    private LinkTableFieldListener contentObserver;
    private boolean validQuery = false;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof LinkTableEditorInput)) {
            throw new PartInitException("Input is not an instance of " + LinkTableEditorInput.class.getSimpleName());
        }
        this.linkTableEditorInput = (LinkTableEditorInput)input;
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(this.linkTableEditorInput);
    }

    public void createPartControl(Composite parent) {
        try {
            Activator.inheritVeriniceContextState();
            this.createEditor(parent);
        }
        catch (RuntimeException e) {
            LOG.error((Object)"Could not create the editor part", (Throwable)e);
            throw e;
        }
    }

    public void createEditor(Composite parent) {
        Composite container = new Composite(parent, 0);
        Composite buttonContainer = new Composite(container, 0);
        Button exportButton = new Button(buttonContainer, 8);
        exportButton.setText(Messages.VeriniceLinkTableEditor_1);
        exportButton.setToolTipText(Messages.VeriniceLinkTableEditor_2);
        GridDataFactory.swtDefaults().applyTo((Control)exportButton);
        exportButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                ExportLinkTableHandler exportHandler = new ExportLinkTableHandler(true, LinkTableEditor.this.linkTableEditorInput.getInput());
                try {
                    exportHandler.execute(new ExecutionEvent());
                }
                catch (ExecutionException e) {
                    LOG.error((Object)"Error while exporting data", (Throwable)e);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        LinkTableComposite ltr = new LinkTableComposite(this.linkTableEditorInput.getInput(), ServiceFactory.lookupObjectModelService(), container);
        this.contentObserver = new LinkTableFieldListener(){

            @Override
            public void fieldValueChanged() {
                LinkTableEditor.this.isDirty = true;
                LinkTableEditor.this.firePropertyChange(257);
            }

            @Override
            public void validate() {
                LinkTableValidationResult validationResult = LinkTableUtil.isValidVeriniceLinkTable(LinkTableEditor.this.linkTableEditorInput.getInput());
                Image defaultImage = ImageCache.getInstance().getImage("document-table.png");
                if (validationResult.isValid()) {
                    LinkTableEditor.this.setTitleImage(defaultImage);
                    LinkTableEditor.this.setPartName(LinkTableEditor.this.linkTableEditorInput.getName());
                    LinkTableEditor.this.validQuery = true;
                } else {
                    ImageDescriptor[] descriptors = new ImageDescriptor[5];
                    Image warningImage = ImageCache.getInstance().getImage("overlays/error_co.gif");
                    descriptors[2] = ImageDescriptor.createFromImage((Image)warningImage);
                    Image decorated = new DecorationOverlayIcon(defaultImage, descriptors).createImage();
                    LinkTableEditor.this.setTitleImage(decorated);
                    LinkTableEditor.this.setPartName(String.valueOf(LinkTableEditor.this.linkTableEditorInput.getName()) + Messages.VeriniceLinkTableEditor_7);
                    LinkTableEditor.this.firePropertyChange(257);
                    LinkTableEditor.this.validQuery = false;
                }
                LinkTableEditor.this.firePropertyChange(1);
            }
        };
        ltr.addListener(this.contentObserver);
        GridLayoutFactory.fillDefaults().generateLayout((Composite)ltr);
        GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 20, 0).generateLayout(buttonContainer);
        GridLayoutFactory.fillDefaults().margins(10, 10).generateLayout(container);
        this.contentObserver.validate();
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.wantSaveEvenIfInvalid()) {
            String filePath = this.getFilePath(this.linkTableEditorInput, false);
            if (filePath != null) {
                this.executeSave(filePath);
            } else {
                LOG.error((Object)"filePath is null!!!");
            }
        }
    }

    public void doSaveAs() {
        if (this.wantSaveEvenIfInvalid()) {
            String filePath = this.getFilePath(this.linkTableEditorInput, true);
            if (filePath != null) {
                this.executeSave(filePath);
            } else {
                LOG.error((Object)"filePath is null!!!");
            }
        }
    }

    private boolean wantSaveEvenIfInvalid() {
        if (!this.validQuery) {
            MessageDialog confirmInvalidInput = new MessageDialog(Display.getCurrent().getActiveShell(), Messages.LinkTableHandler_1, null, String.valueOf(Messages.LinkTableHandler_2) + Messages.LinkTableHandler_3, 4, new String[]{Messages.LinkTableEditor_1, Messages.LinkTableEditor_2}, 0);
            return confirmInvalidInput.open() == 0;
        }
        return true;
    }

    public static String getEditorTitle(String filePath) {
        String title = TITLE_DEFAULT;
        if (filePath != null) {
            title = filePath.substring(filePath.lastIndexOf(File.separator) + 1, filePath.length());
        }
        return title;
    }

    public void dispose() {
        EditorRegistry.getInstance().closeEditor(((LinkTableEditorInput)this.getEditorInput()).getId());
        super.dispose();
    }

    private void executeSave(String filePath) {
        VeriniceLinkTableIO.write((VeriniceLinkTable)this.linkTableEditorInput.getInput(), (String)filePath);
        this.setPartName(LinkTableEditor.getEditorTitle(filePath));
        this.isDirty = false;
        this.firePropertyChange(257);
        this.contentObserver.validate();
    }

    private String getFilePath(LinkTableEditorInput linkTableEditorInput, boolean isSaveAs) {
        String filePath = linkTableEditorInput.getFilePath();
        if ((isSaveAs || filePath == null) && (filePath = LinkTableUtil.createVltFilePath(Display.getCurrent().getActiveShell(), Messages.VeriniceLinkTableEditor_4, 8192, linkTableEditorInput.getName())) != null) {
            EditorRegistry.getInstance().closeEditor(linkTableEditorInput.getId());
            linkTableEditorInput.setFilePath(filePath);
            EditorRegistry.getInstance().registerOpenEditor(linkTableEditorInput.getId(), (IEditorPart)this);
        }
        return filePath;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void setFocus() {
    }
}

