/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.gsm;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.hui.common.VeriniceContext;
import sernet.springclient.RightsServiceClient;
import sernet.verinice.bpm.rcp.TaskChangeRegistry;
import sernet.verinice.interfaces.RightEnabledUserInteraction;
import sernet.verinice.interfaces.bpm.IGsmValidationResult;
import sernet.verinice.interfaces.bpm.IProcessStartInformation;
import sernet.verinice.model.iso27k.Organization;
import sernet.verinice.rcp.InfoDialogWithShowToggle;
import sernet.verinice.rcp.gsm.Messages;

public class StartGsmExecuteProcess
implements IObjectActionDelegate,
RightEnabledUserInteraction {
    private static final Logger LOG = Logger.getLogger(StartGsmExecuteProcess.class);
    private Integer orgId;
    private int numberOfProcess = 0;
    private Boolean isActive = null;
    private String validationMessage = Messages.StartGsmExecuteProcess_10;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        try {
            if (this.orgId != null) {
                boolean validateProcess;
                boolean startProcess = true;
                boolean bl = validateProcess = !Activator.getDefault().getPreferenceStore().getBoolean("info_processes_validate");
                if (validateProcess) {
                    boolean bl2 = startProcess = 2 == this.validateOrganization();
                }
                if (startProcess) {
                    this.startProcess();
                    if (this.numberOfProcess > 0) {
                        TaskChangeRegistry.tasksAdded();
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while creating process.", (Throwable)e);
            ExceptionUtil.log(e, Messages.StartGsmExecuteProcess_3);
        }
    }

    private void startProcess() {
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        try {
            progressService.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    Activator.inheritVeriniceContextState();
                    IProcessStartInformation info = ServiceFactory.lookupGsmService().startProcessesForOrganization(StartGsmExecuteProcess.this.orgId);
                    StartGsmExecuteProcess.this.numberOfProcess = info.getNumber();
                }
            });
            String message = Messages.bind((String)Messages.StartGsmExecuteProcess_1, (Object)this.numberOfProcess);
            if (this.numberOfProcess == 0) {
                message = Messages.StartGsmExecuteProcess_19;
            }
            InfoDialogWithShowToggle.openInformation(Messages.StartGsmExecuteProcess_0, message, Messages.StartGsmExecuteProcess_4, "info_processes_started");
            if (this.numberOfProcess > 0) {
                TaskChangeRegistry.tasksAdded();
            }
        }
        catch (Exception t) {
            LOG.error((Object)"Error while creating process.", (Throwable)t);
            ExceptionUtil.log(t, Messages.StartGsmExecuteProcess_3);
        }
    }

    private int validateOrganization() throws InvocationTargetException, InterruptedException {
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        progressService.run(true, true, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                Activator.inheritVeriniceContextState();
                IGsmValidationResult validationResult = ServiceFactory.lookupGsmService().validateOrganization(StartGsmExecuteProcess.this.orgId);
                StartGsmExecuteProcess.this.validationMessage = StartGsmExecuteProcess.this.createValidationMessage(validationResult);
            }
        });
        InfoDialogWithShowToggle dialog = InfoDialogWithShowToggle.openYesNoCancelQuestion(Messages.StartGsmExecuteProcess_0, this.validationMessage, Messages.StartGsmExecuteProcess_2, "info_processes_validate");
        return dialog.getReturnCode();
    }

    protected String createValidationMessage(IGsmValidationResult validationResult) {
        StringBuilder sb = new StringBuilder();
        List assetGroupNames = validationResult.getAssetGroupsWithoutLinkedPerson();
        List ungroupedAssets = validationResult.getUngroupedAssets();
        List ungroupedControls = validationResult.getUngroupedControls();
        if (assetGroupNames.isEmpty() && ungroupedAssets.isEmpty() && ungroupedControls.isEmpty()) {
            sb.append(Messages.StartGsmExecuteProcess_11);
        } else {
            sb.append(Messages.StartGsmExecuteProcess_12);
            sb.append("\n\n");
        }
        if (!assetGroupNames.isEmpty()) {
            sb.append(NLS.bind((String)Messages.StartGsmExecuteProcess_9, (Object)assetGroupNames.size(), (Object)this.createList(assetGroupNames)));
            sb.append("\n\n");
        }
        if (!ungroupedAssets.isEmpty()) {
            sb.append(NLS.bind((String)Messages.StartGsmExecuteProcess_8, (Object)ungroupedAssets.size(), (Object)this.createList(ungroupedAssets)));
            sb.append("\n\n");
        }
        if (!ungroupedControls.isEmpty()) {
            sb.append(NLS.bind((String)Messages.StartGsmExecuteProcess_7, (Object)ungroupedControls.size(), (Object)this.createList(ungroupedControls)));
        }
        sb.append("\n\n");
        sb.append(Messages.StartGsmExecuteProcess_5);
        return sb.toString();
    }

    private String createList(List<String> assetGroupNames) {
        return this.createList(assetGroupNames, 10);
    }

    private String createList(List<String> assetGroupNames, Integer limit) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        int n = 1;
        for (String name : assetGroupNames) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            if (limit != null && limit < n) {
                sb.append("...");
                break;
            }
            sb.append(name);
            ++n;
        }
        return sb.toString();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(this.checkRights());
        if (!Activator.getDefault().isStandalone()) {
            if (selection instanceof ITreeSelection) {
                ITreeSelection treeSelection = (ITreeSelection)selection;
                for (Object selectedElement : treeSelection) {
                    if (!(selectedElement instanceof Organization)) continue;
                    this.orgId = ((Organization)selectedElement).getDbId();
                }
            }
        } else {
            action.setEnabled(false);
        }
    }

    public boolean checkRights() {
        RightsServiceClient service = (RightsServiceClient)VeriniceContext.get((String)"rightsService");
        return service.isEnabled(this.getRightID());
    }

    public String getRightID() {
        return "creategreenbonetasks";
    }
}

