/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.group;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.IProgressService;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.rcp.IllegalSelectionException;
import sernet.verinice.rcp.RightsEnabledHandler;
import sernet.verinice.rcp.group.GroupByTagDialog;
import sernet.verinice.rcp.group.Messages;
import sernet.verinice.service.commands.GroupByTags;
import sernet.verinice.service.commands.LoadTagsOfGroupElements;

public class GroupByTagHandler
extends RightsEnabledHandler {
    private static final Logger LOG = Logger.getLogger(GroupByTagHandler.class);
    private CnATreeElement group;
    private Set<String> allTags;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        block7: {
            List<CnATreeElement> selectedElements;
            block6: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Group by tags called...");
                }
                selectedElements = this.getSelectedElements(event);
                if (selectedElements != null && selectedElements.size() == 1) break block6;
                return null;
            }
            this.group = selectedElements.get(0);
            this.allTags = this.loadTagSet(this.group);
            if (this.allTags != null && !this.allTags.isEmpty()) break block7;
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Messages.GroupByTagHandler_1, (String)Messages.GroupByTagHandler_2);
            return null;
        }
        try {
            Set<String> tags;
            GroupByTagDialog dialog = this.openGroupByTagDialog();
            if (dialog.open() == 0 && (tags = dialog.getTagsSelected()) != null && !tags.isEmpty()) {
                this.groupByTags(tags);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error grouping elements.", (Throwable)e);
            MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)Messages.GroupByTagHandler_3, (String)Messages.GroupByTagHandler_4);
        }
        return null;
    }

    private Set<String> loadTagSet(CnATreeElement group) throws InvocationTargetException, InterruptedException {
        if (group == null) {
            return Collections.emptySet();
        }
        LoadTagsOperation operation = new LoadTagsOperation();
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        progressService.busyCursorWhile((IRunnableWithProgress)operation);
        return operation.getTagSet();
    }

    private void groupByTags(Set<String> tags) throws InvocationTargetException, InterruptedException {
        GroupByTagsOperation operation = new GroupByTagsOperation(this.group, tags);
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        progressService.busyCursorWhile((IRunnableWithProgress)operation);
    }

    private GroupByTagDialog openGroupByTagDialog() {
        return new GroupByTagDialog(Display.getCurrent().getActiveShell(), this.allTags);
    }

    private List<CnATreeElement> getSelectedElements(ExecutionEvent event) {
        List elements = Collections.emptyList();
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof StructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            try {
                elements = structuredSelection.toList();
            }
            catch (ClassCastException e) {
                LOG.warn((Object)"One of the selected object is not a CnATreeElement. Will not return any selected object.");
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"stackstrace: ", (Throwable)e);
                }
                throw new IllegalSelectionException("Wrong object selected.");
            }
        }
        return elements;
    }

    public String getRightID() {
        return "groupbytag";
    }

    static class GroupByTagsOperation
    implements IRunnableWithProgress {
        private CnATreeElement group;
        private Set<String> tags;

        public GroupByTagsOperation(CnATreeElement group, Set<String> tags) {
            this.group = group;
            this.tags = tags;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask(Messages.GroupByTagHandler_8, -1);
            Activator.inheritVeriniceContextState();
            GroupByTags command = new GroupByTags(this.group.getUuid(), this.tags);
            try {
                try {
                    ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
                    CnAElementFactory.getInstance().reloadAllModelsFromDatabase();
                }
                catch (CommandException ex) {
                    LOG.error((Object)"Error while grouping by tags", (Throwable)ex);
                    MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Messages.GroupByTagHandler_9, (String)Messages.GroupByTagHandler_10);
                    if (monitor != null) {
                        monitor.done();
                    }
                }
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
    }

    class LoadTagsOperation
    implements IRunnableWithProgress {
        private Set<String> tagSet;

        LoadTagsOperation() {
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask(Messages.GroupByTagHandler_0, -1);
            Activator.inheritVeriniceContextState();
            LoadTagsOfGroupElements command = new LoadTagsOfGroupElements(GroupByTagHandler.this.group.getUuid());
            try {
                try {
                    command = (LoadTagsOfGroupElements)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
                    this.tagSet = command.getTagSet();
                }
                catch (CommandException ex) {
                    LOG.error((Object)"Error while loading tags", (Throwable)ex);
                    MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Messages.GroupByTagHandler_9, (String)Messages.GroupByTagHandler_10);
                    if (monitor != null) {
                        monitor.done();
                    }
                }
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
            }
        }

        public Set<String> getTagSet() {
            return this.tagSet;
        }
    }
}

