/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.group;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import sernet.verinice.rcp.group.Messages;

public class GroupByTagDialog
extends TitleAreaDialog {
    private Set<String> tags;
    private Set<String> tagsSelected;

    public GroupByTagDialog(Shell activeShell, Set<String> tags) {
        super(activeShell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.tags = tags;
    }

    protected Control createDialogArea(Composite parent) {
        int layoutMarginWidth = 10;
        int layoutMarginHeight = 10;
        int gdMinWidth = 400;
        int gdHeightHint = 200;
        this.setTitle(Messages.GroupByTagDialog_0);
        this.setMessage(Messages.GroupByTagDialog_1, 1);
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        GridData gd = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gd);
        Group groupOrganization = new Group(composite, 0);
        groupOrganization.setText(Messages.GroupByTagDialog_2);
        GridLayout groupOrganizationLayout = new GridLayout(1, true);
        groupOrganization.setLayout((Layout)groupOrganizationLayout);
        gd = new GridData(4, 4, true, true);
        gd.minimumWidth = 400;
        gd.heightHint = 200;
        groupOrganization.setLayoutData((Object)gd);
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)groupOrganization, 512);
        scrolledComposite.setLayoutData((Object)new GridData(1808));
        scrolledComposite.setExpandHorizontal(true);
        Composite innerComposite = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)innerComposite);
        innerComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        innerComposite.setLayout((Layout)new GridLayout(1, false));
        SelectionAdapter tagListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button checkbox = (Button)e.getSource();
                String tag = (String)checkbox.getData();
                if (checkbox.getSelection()) {
                    GroupByTagDialog.this.tagsSelected.add(tag);
                } else {
                    GroupByTagDialog.this.tagsSelected.remove(tag);
                }
                super.widgetSelected(e);
            }
        };
        this.tagsSelected = new HashSet<String>();
        for (String tag : this.tags) {
            Button radioOrganization = new Button(innerComposite, 32);
            radioOrganization.setText(tag);
            radioOrganization.setData((Object)tag);
            radioOrganization.setSelection(true);
            this.tagsSelected.add(tag);
            radioOrganization.addSelectionListener((SelectionListener)tagListener);
        }
        scrolledComposite.setVisible(true);
        Point size = innerComposite.computeSize(-1, -1);
        size.y += this.tags.size() * 2;
        innerComposite.setSize(size);
        groupOrganization.layout();
        composite.pack();
        return composite;
    }

    protected void okPressed() {
        super.okPressed();
    }

    public Set<String> getTagsSelected() {
        return this.tagsSelected;
    }
}

