/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.dialogs;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import sernet.verinice.rcp.dialogs.Messages;

public class ScrollableMultilineDialog
extends TitleAreaDialog {
    private String message;
    private String dialogTitle;
    private String dialogMessage;
    private boolean showSaveButton = true;

    public ScrollableMultilineDialog(Shell parentShell, String message, String dialogTitle, String dialogMessage) {
        super(parentShell);
        this.setHelpAvailable(false);
        this.setShellStyle(65552);
        this.message = message;
        this.dialogTitle = dialogTitle;
        this.dialogMessage = dialogMessage;
    }

    protected Control createDialogArea(Composite parent) {
        this.setMessage(this.dialogMessage);
        this.setTitle(this.dialogTitle);
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(1808));
        ScrolledComposite scrolledComposite = new ScrolledComposite(container, 2816);
        scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        StyledText styledText = new StyledText((Composite)scrolledComposite, 2048);
        styledText.setText(this.message);
        scrolledComposite.setContent((Control)styledText);
        scrolledComposite.setMinSize(styledText.computeSize(-1, -1));
        Composite composite = new Composite(container, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        composite.setVisible(this.showSaveButton);
        Composite compositeExport = new Composite(composite, 0);
        GridData gdComposite = new GridData(4, 128, true, false, 1, 1);
        gdComposite.heightHint = 32;
        compositeExport.setLayoutData((Object)gdComposite);
        Button btnNewButton = new Button(composite, 0);
        btnNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(ScrollableMultilineDialog.this.getShell(), 8192);
                String filename = fileDialog.open();
                if (filename != null) {
                    try {
                        FileUtils.writeStringToFile((File)new File(filename), (String)ScrollableMultilineDialog.this.message);
                    }
                    catch (IOException e1) {
                        MessageDialog.openError((Shell)ScrollableMultilineDialog.this.getShell(), (String)"Error writing file.", (String)e1.getLocalizedMessage());
                    }
                }
            }
        });
        btnNewButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        btnNewButton.setAlignment(131072);
        btnNewButton.setText(Messages.ScrollableMultilineDialog_save_button_text);
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(600, 400);
    }

    public void setShowSaveButton(boolean showSaveButton) {
        this.showSaveButton = showSaveButton;
    }
}

