/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.dataprotection;

import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.iso27k.rcp.OrganizationMultiselectWidget;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.rcp.dataprotection.Messages;

public class MigrateDataProtectionDialog
extends TitleAreaDialog {
    private static final Logger LOG = Logger.getLogger(MigrateDataProtectionDialog.class);
    private ITreeSelection selection;
    private CnATreeElement selectedElement;
    private OrganizationMultiselectWidget organizationWidget;
    private boolean showMigrationDialog = true;

    public MigrateDataProtectionDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(2160);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.MigrateDataProtectionDialog_title);
        this.setMessage(Messages.MigrateDataProtectionDialog_message);
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(1808));
        try {
            this.organizationWidget = new OrganizationMultiselectWidget(container, this.selection, this.selectedElement);
            this.organizationWidget.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (MigrateDataProtectionDialog.this.organizationWidget.getSelectedElementSet().isEmpty()) {
                        MigrateDataProtectionDialog.this.setErrorMessage(Messages.MigrateDataProtectionDialog_select_org);
                    } else {
                        MigrateDataProtectionDialog.this.setErrorMessage(null);
                    }
                }
            });
            Composite composite = new Composite(container, 0);
            composite.setLayout((Layout)new GridLayout(1, false));
            composite.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        }
        catch (CommandException ex) {
            LOG.error((Object)"Error while loading organizations", (Throwable)ex);
            this.setMessage(sernet.verinice.rcp.risk.Messages.OrganizationPage_ErrorMessage, 3);
        }
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(766, 568);
    }

    public Set<CnATreeElement> getSelectedElementSet() {
        return this.organizationWidget.getSelectedElementSet();
    }

    public void setSelectedElement(CnATreeElement selectedElement) {
        this.selectedElement = selectedElement;
    }

    public void setSelection(ITreeSelection selection) {
        this.selection = selection;
    }
}

