/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.dataprotection;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import sernet.gs.service.NumericStringComparator;
import sernet.gs.service.RuntimeCommandException;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.iso27k.Organization;
import sernet.verinice.rcp.RightsEnabledActionDelegate;
import sernet.verinice.rcp.dataprotection.Messages;
import sernet.verinice.rcp.dataprotection.MigrateDataProtectionDialog;
import sernet.verinice.rcp.dialogs.ScrollableMultilineDialog;
import sernet.verinice.service.commands.dataprotection.migration.MigrateDataProtectionCommand;

public class MigrateDataProtectionActionDelegate
extends RightsEnabledActionDelegate
implements IWorkbenchWindowActionDelegate {
    private static final Logger LOG = Logger.getLogger(MigrateDataProtectionActionDelegate.class);
    private CnATreeElement selectedOrganization;
    private Shell shell;
    private ITreeSelection selection;

    @Override
    public void doRun(IAction action) {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(true);
            MigrateDataProtectionDialog dialog = new MigrateDataProtectionDialog(this.getShell());
            dialog.setSelectedElement(this.selectedOrganization);
            dialog.setSelection(this.selection);
            if (dialog.open() == 0) {
                Set<CnATreeElement> selectedElementSet = dialog.getSelectedElementSet();
                RunMigration commandRunner = new RunMigration(selectedElementSet);
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)commandRunner);
                MigrateDataProtectionCommand migrationCommand = commandRunner.migrateDataProtectionCommand;
                List processes = migrationCommand.getAffectedProcessNames();
                Collections.sort(migrationCommand.getMissedControlNames(), new NumericStringComparator());
                List missedControls = migrationCommand.getMissedControlNames();
                this.displayFinishedDialog(selectedElementSet, processes, migrationCommand.getAffectedNumberOfControls(), missedControls, migrationCommand.getNumberOfCreatedLinks(), migrationCommand.getNumberOfDeletedLinks());
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error running the dataprotection migration.", (Throwable)e);
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.MigrateDataProtectionActionDelegate_error_dialog_titel, (String)Messages.MigrateDataProtectionActionDelegate_error_dialog_message);
        }
    }

    private void displayFinishedDialog(Set<CnATreeElement> organizations, Collection<String> processes, int controls, Collection<String> missedControls, int createdLinks, int deletedLinks) {
        String listOfMissedControls = StringUtils.join(missedControls, (String)"\n");
        String processNames = StringUtils.join(processes, (String)",\n");
        StringBuilder orgNames = new StringBuilder();
        for (CnATreeElement org : organizations) {
            orgNames.append("'").append(org.getTitle()).append("' ");
        }
        String message = Messages.bind((String)(organizations.size() == 1 ? Messages.MigrateDataProtectionActionDelegate_migration_log_singular : Messages.MigrateDataProtectionActionDelegate_migration_log_plural), (Object[])new String[]{orgNames.toString(), Integer.toString(processes.size()), Integer.toString(controls), Integer.toString(createdLinks), Integer.toString(deletedLinks), processNames, Integer.toString(missedControls.size()), listOfMissedControls});
        ScrollableMultilineDialog multilineDialog = new ScrollableMultilineDialog(Display.getCurrent().getActiveShell(), message, Messages.MigrateDataProtectionActionDelegate_migration_finished_title, Messages.MigrateDataProtectionActionDelegate_migration_finished_message);
        multilineDialog.open();
    }

    public String getRightID() {
        return "migrate_data_protection";
    }

    public void init(IWorkbenchWindow window) {
        try {
            this.shell = window.getShell();
        }
        catch (Exception e) {
            LOG.error((Object)"Error creating ActionDelegate", (Throwable)e);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof ITreeSelection) {
            this.selectedOrganization = null;
            this.selection = (ITreeSelection)selection;
            ITreeSelection selectionCurrent = (ITreeSelection)selection;
            for (Object selectedObject : selectionCurrent) {
                if (!this.isOrganization(selectedObject)) continue;
                this.selectedOrganization = (CnATreeElement)selectedObject;
            }
        }
    }

    private boolean isOrganization(Object element) {
        return element instanceof Organization;
    }

    private Shell getShell() {
        return this.shell;
    }

    private final class RunMigration
    implements IRunnableWithProgress {
        private final Set<CnATreeElement> selectedElementSet;
        private MigrateDataProtectionCommand migrateDataProtectionCommand;

        private RunMigration(Set<CnATreeElement> selectedElementSet) {
            this.selectedElementSet = selectedElementSet;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask(Messages.MigrateDataProtectionActionDelegate_monitor_message, -1);
            MigrateDataProtectionCommand migrationCommand = new MigrateDataProtectionCommand(this.selectedElementSet);
            try {
                this.migrateDataProtectionCommand = (MigrateDataProtectionCommand)ServiceFactory.lookupCommandService().executeCommand((ICommand)migrationCommand);
                monitor.beginTask(Messages.MigrateDataProtectionActionDelegate_monitor_message_refresh, -1);
                CnAElementFactory.getInstance().reloadIsoModelFromDatabase();
            }
            catch (CommandException e) {
                LOG.error((Object)"Error while migrating dataprotection", (Throwable)e);
                throw new RuntimeCommandException((Throwable)e);
            }
            monitor.done();
        }
    }
}

