/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.catalog;

import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.services.IServiceLocator;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.gs.ui.rcp.main.actions.ShowAccessControlEditAction;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.BaseProtectionModelingTransfer;
import sernet.gs.ui.rcp.main.bsi.editors.BSIElementEditorInput;
import sernet.gs.ui.rcp.main.bsi.editors.EditorFactory;
import sernet.gs.ui.rcp.main.bsi.editors.EditorRegistry;
import sernet.gs.ui.rcp.main.bsi.views.BSIModelViewLabelProvider;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.common.model.DefaultModelLoadListener;
import sernet.gs.ui.rcp.main.common.model.IModelLoadListener;
import sernet.verinice.bp.rcp.BaseProtectionTreeComparator;
import sernet.verinice.iso27k.rcp.ILinkedWithEditorView;
import sernet.verinice.iso27k.rcp.JobScheduler;
import sernet.verinice.iso27k.rcp.LinkWithEditorPartListener;
import sernet.verinice.iso27k.rcp.Messages;
import sernet.verinice.iso27k.rcp.action.CollapseAction;
import sernet.verinice.iso27k.rcp.action.DeleteSelectionAction;
import sernet.verinice.iso27k.rcp.action.ExpandAction;
import sernet.verinice.model.bsi.IBSIStrukturElement;
import sernet.verinice.model.bsi.IBSIStrukturKategorie;
import sernet.verinice.model.catalog.CatalogModel;
import sernet.verinice.model.catalog.ICatalogModelListener;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.rcp.RightsEnabledView;
import sernet.verinice.rcp.catalog.CatalogDragListener;
import sernet.verinice.rcp.tree.TreeContentProvider;
import sernet.verinice.rcp.tree.TreeLabelProvider;
import sernet.verinice.rcp.tree.TreeUpdateListener;
import sernet.verinice.service.tree.ElementManager;

public class CatalogView
extends RightsEnabledView
implements ILinkedWithEditorView {
    private static final Logger logger = Logger.getLogger(CatalogView.class);
    protected TreeViewer viewer;
    private TreeContentProvider contentProvider;
    private ElementManager elementManager;
    private Lock lock = new ReentrantLock();
    private IModelLoadListener modelLoadListener;
    private ICatalogModelListener modelUpdateListener;
    private DrillDownAdapter drillDownAdapter;
    private Action doubleClickAction;
    private ExpandAction expandAction;
    private CollapseAction collapseAction;
    private ShowAccessControlEditAction accessControlEditAction;
    private Action linkWithEditorAction;
    private DeleteSelectionAction deleteAction;
    private IPartListener2 linkWithEditorPartListener = new LinkWithEditorPartListener(this);
    private BSIModelViewLabelProvider bsiLableProvider = new BSIModelViewLabelProvider();
    private boolean linkingActive;
    private Action expandAllAction;
    private Action collapseAllAction;
    public static final String ID = "sernet.verinice.rcp.catalog.CatalogView";

    public CatalogView() {
        this.elementManager = new ElementManager();
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        try {
            this.initView(parent);
            this.startInitDataJob();
        }
        catch (Exception e) {
            logger.error((Object)"Error while creating organization view", (Throwable)e);
            ExceptionUtil.log(e, Messages.ISMView_2);
        }
    }

    @Override
    public String getRightID() {
        return "catalogview";
    }

    @Override
    public String getViewId() {
        return ID;
    }

    protected void initView(Composite parent) {
        this.contentProvider = new TreeContentProvider(this.elementManager);
        this.viewer = new TreeViewer(parent, 2818);
        this.viewer.setComparator((ViewerComparator)new BaseProtectionTreeComparator());
        this.drillDownAdapter = new DrillDownAdapter(this.viewer);
        this.viewer.getTree().setLayoutData((Object)new GridData(1808));
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider(){

            @Override
            public Image getImage(Object obj) {
                if (obj instanceof IBSIStrukturElement || obj instanceof IBSIStrukturKategorie) {
                    return CatalogView.this.bsiLableProvider.getImage(obj);
                }
                return super.getImage(obj);
            }

            @Override
            public String getText(Object obj) {
                if (obj instanceof IBSIStrukturElement || obj instanceof IBSIStrukturKategorie) {
                    return CatalogView.this.bsiLableProvider.getText(obj);
                }
                return super.getText(obj);
            }
        });
        this.toggleLinking(Activator.getDefault().getPreferenceStore().getBoolean("link_to_editor"));
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.hookContextMenu();
        this.makeActions();
        this.addActions();
        this.fillToolBar();
        this.addDndListeners();
        this.getSite().getPage().addPartListener(this.linkWithEditorPartListener);
        this.viewer.refresh(true);
    }

    private void addDndListeners() {
        int ops = 3;
        Transfer[] transfers = new Transfer[]{BaseProtectionModelingTransfer.getInstance()};
        this.viewer.addDragSupport(ops, transfers, (DragSourceListener)new CatalogDragListener(this.viewer));
    }

    protected void startInitDataJob() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Catalogview: startInitDataJob");
        }
        WorkspaceJob initDataJob = new WorkspaceJob(Messages.ISMView_InitData){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                IStatus status = Status.OK_STATUS;
                try {
                    try {
                        monitor.beginTask(Messages.ISMView_InitData, -1);
                        CatalogView.this.initData();
                    }
                    catch (Exception e) {
                        logger.error((Object)"Error while loading data for catalog view.", (Throwable)e);
                        status = new Status(4, "sernet.gs.ui.rcp.main", Messages.ISMView_4, (Throwable)e);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
                return status;
            }
        };
        JobScheduler.scheduleInitJob(initDataJob);
    }

    protected void initData() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"MotITBPCatalogVIEW: initData");
        }
        this.lock.lock();
        try {
            if (CnAElementFactory.isModernizedBpCatalogLoaded()) {
                if (this.modelUpdateListener == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Creating modelUpdateListener for MotITBPView.");
                    }
                    this.modelUpdateListener = new TreeUpdateListener(this.viewer, this.elementManager);
                    CnAElementFactory.getInstance().getCatalogModel().addCatalogModelListener(this.modelUpdateListener);
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            CatalogView.this.setInput(CnAElementFactory.getInstance().getCatalogModel());
                            CatalogView.this.viewer.refresh();
                        }
                    });
                }
            } else if (this.modelLoadListener == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"CatalogModel No model loaded, adding model load listener.");
                }
                this.modelLoadListener = new DefaultModelLoadListener(){

                    @Override
                    public void loaded(CatalogModel model) {
                        CatalogView.this.startInitDataJob();
                    }
                };
                CnAElementFactory.getInstance().addLoadListener(this.modelLoadListener);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setInput(CatalogModel catalogModel) {
        this.viewer.setInput((Object)catalogModel);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        MenuListener menuListener = new MenuListener();
        menuMgr.addMenuListener((IMenuListener)menuListener);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)menuListener);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    private void makeActions() {
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = CatalogView.this.viewer.getSelection();
                if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                    Object sel = ((IStructuredSelection)selection).getFirstElement();
                    try {
                        CatalogView.this.openEditorReadOnly(sel);
                    }
                    catch (PartInitException e) {
                        logger.error((Object)("Error opening the BSIElement editor for: " + sel), (Throwable)e);
                    }
                }
            }
        };
        this.doubleClickAction.setText(Messages.CatalogView_open_in_editor);
        this.doubleClickAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("edtsrclkup_co.gif"));
        this.makeExpandAndCollapseActions();
        this.linkWithEditorAction = new Action(Messages.ISMView_5, 2){

            public void run() {
                CatalogView.this.toggleLinking(this.isChecked());
            }
        };
        this.linkWithEditorAction.setChecked(this.isLinkingActive());
        this.linkWithEditorAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("linked.gif"));
        this.deleteAction = new DeleteSelectionAction();
        this.viewer.getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 127 && CatalogView.this.viewer.getTree().getSelectionCount() == 1) {
                    CatalogView.this.deleteAction.run();
                }
            }
        });
        this.accessControlEditAction = new ShowAccessControlEditAction(this.getViewSite(), Messages.CatalogView_AccessControl);
    }

    private void makeExpandAndCollapseActions() {
        this.expandAction = new ExpandAction(this.viewer, this.contentProvider);
        this.expandAction.setText(Messages.ISMView_7);
        this.expandAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("expandall.gif"));
        this.collapseAction = new CollapseAction(this.viewer);
        this.collapseAction.setText(Messages.ISMView_8);
        this.collapseAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("collapseall.gif"));
        this.expandAllAction = new Action(){

            public void run() {
                CatalogView.this.viewer.expandAll();
            }
        };
        this.expandAllAction.setText(Messages.ISMView_9);
        this.expandAllAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("expandall.gif"));
        this.collapseAllAction = new Action(){

            public void run() {
                CatalogView.this.viewer.collapseAll();
            }
        };
        this.collapseAllAction.setText(Messages.ISMView_10);
        this.collapseAllAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("collapseall.gif"));
    }

    protected void openEditorReadOnly(Object sel) throws PartInitException {
        CnATreeElement element = (CnATreeElement)sel;
        IEditorPart editor = EditorRegistry.getInstance().getOpenEditor(element.getId());
        if (editor == null) {
            EditorFactory.getInstance().updateAndOpenObject(element, true);
        } else {
            this.getSite().getPage().openEditor(editor.getEditorInput(), "sernet.gs.ui.rcp.main.bsi.editors.bsielementeditor");
        }
    }

    private void addActions() {
        this.viewer.addDoubleClickListener(event -> this.doubleClickAction.run());
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.expandAction);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.collapseAction);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.deleteAction);
    }

    protected void fillToolBar() {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager manager = bars.getToolBarManager();
        manager.add((IAction)this.expandAllAction);
        manager.add((IAction)this.collapseAllAction);
        this.drillDownAdapter.addNavigationActions(manager);
        manager.add((IAction)this.linkWithEditorAction);
    }

    protected void toggleLinking(boolean checked) {
        this.linkingActive = checked;
        if (checked) {
            Optional.ofNullable(this.getSite().getPage().getActiveEditor()).ifPresent(this::editorActivated);
        }
    }

    protected boolean isLinkingActive() {
        return this.linkingActive;
    }

    @Override
    public void editorActivated(IEditorPart activeEditor) {
        if (!this.isLinkingActive() || !this.getViewSite().getPage().isPartVisible((IWorkbenchPart)this)) {
            return;
        }
        CnATreeElement element = BSIElementEditorInput.extractElement(activeEditor);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Element in editor: " + element.getUuid()));
        }
        if (element == null) {
            return;
        }
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)element), true);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Tree is expanded.");
        }
    }

    public void dispose() {
        this.elementManager.clearCache();
        if (CnAElementFactory.isModernizedBpCatalogLoaded()) {
            CnAElementFactory.getInstance().getCatalogModel().removeCatalogModelListener(this.modelUpdateListener);
        }
        CnAElementFactory.getInstance().removeLoadListener(this.modelLoadListener);
        this.getSite().getPage().removePartListener(this.linkWithEditorPartListener);
        super.dispose();
    }

    private class MenuListener
    implements IMenuListener,
    ISelectionChangedListener {
        private IStructuredSelection selection;

        private MenuListener() {
        }

        public void menuAboutToShow(IMenuManager manager) {
            manager.add((IContributionItem)new GroupMarker("content"));
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)CatalogView.this.doubleClickAction);
            manager.add((IContributionItem)new GroupMarker("additions"));
            manager.add((IContributionItem)new Separator());
            CommandContributionItemParameter copyParameter = new CommandContributionItemParameter((IServiceLocator)PlatformUI.getWorkbench(), null, "org.eclipse.ui.edit.copy", 8);
            copyParameter.icon = ImageCache.getInstance().getImageDescriptor("copy.png");
            CommandContributionItem copyItem = new CommandContributionItem(copyParameter);
            manager.add((IContributionItem)copyItem);
            CommandContributionItemParameter copyWithLinksParameter = new CommandContributionItemParameter((IServiceLocator)PlatformUI.getWorkbench(), null, "sernet.verinice.iso27k.rcp.commands.copywithlinks", 8);
            copyWithLinksParameter.icon = ImageCache.getInstance().getImageDescriptor("copy.png");
            CommandContributionItem copyWithLinksItem = new CommandContributionItem(copyWithLinksParameter);
            manager.add((IContributionItem)copyWithLinksItem);
            if (CnAElementFactory.selectionOnlyContainsScopes(this.selection)) {
                manager.add((IAction)CatalogView.this.deleteAction);
            }
            manager.add((IAction)CatalogView.this.accessControlEditAction);
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)CatalogView.this.expandAction);
            manager.add((IAction)CatalogView.this.collapseAction);
            CatalogView.this.drillDownAdapter.addNavigationActions(manager);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.selection = (IStructuredSelection)event.getSelection();
        }
    }
}

