/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.catalog;

import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.BaseProtectionModelingTransfer;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.VeriniceElementTransfer;

public class CatalogDragListener
implements DragSourceListener {
    private static final Logger log = Logger.getLogger(CatalogDragListener.class);
    private TreeViewer treeViewer;

    public CatalogDragListener(TreeViewer viewer) {
        this.treeViewer = viewer;
    }

    public void dragStart(DragSourceEvent event) {
        if (this.getTreeSelection().isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Can not start dragging. No element in tree is selected.");
            }
            event.doit = false;
        } else {
            boolean isValid = BaseProtectionModelingTransfer.isDraggedDataValid(this.getTreeSelection().toArray());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Dragged data validation state: " + isValid));
            }
            event.doit = isValid;
        }
    }

    public void dragSetData(DragSourceEvent event) {
        if (this.getTransfer().isSupportedType(event.dataType)) {
            event.data = this.getTreeSelection().toArray();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Drag data set: ");
                this.logData((Object[])event.data);
            }
        }
    }

    public void dragFinished(DragSourceEvent event) {
    }

    protected IStructuredSelection getTreeSelection() {
        return (IStructuredSelection)this.treeViewer.getSelection();
    }

    protected VeriniceElementTransfer getTransfer() {
        return BaseProtectionModelingTransfer.getInstance();
    }

    private void logData(Object[] dataArray) {
        Object[] objectArray = dataArray;
        int n = dataArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            log.debug(object);
            ++n2;
        }
    }
}

