/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.bp;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.verinice.model.bp.ISecurityLevelProvider;
import sernet.verinice.model.bp.SecurityLevel;

public class SecurityLevelDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    private static final String IMAGE_BASIC = "overlays/sec_level_b.png";
    private static final String IMAGE_STANDARD = "overlays/sec_level_s.png";
    private static final String IMAGE_HIGH = "overlays/sec_level_e.png";
    private boolean enabled;

    public SecurityLevelDecorator() {
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        this.enabled = preferenceStore.getBoolean("show_security_level_decorator");
        preferenceStore.addPropertyChangeListener(event -> {
            if (event.getProperty().equals("show_security_level_decorator")) {
                this.enabled = (Boolean)event.getNewValue();
                this.updateDecorations();
            }
        });
    }

    public void decorate(Object element, IDecoration decoration) {
        ISecurityLevelProvider securable;
        SecurityLevel level;
        if (this.enabled && element instanceof ISecurityLevelProvider && (level = (securable = (ISecurityLevelProvider)element).getSecurityLevel()) != null) {
            decoration.addOverlay(ImageCache.getInstance().getImageDescriptor(this.getImageFilename(level)));
        }
    }

    private String getImageFilename(SecurityLevel level) {
        switch (level) {
            case BASIC: {
                return IMAGE_BASIC;
            }
            case STANDARD: {
                return IMAGE_STANDARD;
            }
            case HIGH: {
                return IMAGE_HIGH;
            }
        }
        throw new IllegalArgumentException("Security level not supported.");
    }

    private void updateDecorations() {
        this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
    }
}

