/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.accountgroup;

import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.springframework.dao.DataIntegrityViolationException;
import sernet.gs.ui.rcp.main.bsi.views.Messages;
import sernet.verinice.rcp.accountgroup.AccountGroupView;
import sernet.verinice.rcp.accountgroup.CRUDAccountGroupDialog;

class NewGroupDialog
extends CRUDAccountGroupDialog {
    private static final Logger LOG = Logger.getLogger(NewGroupDialog.class);
    private final AccountGroupView groupView;

    public NewGroupDialog(AccountGroupView groupView, Shell parent, String title) {
        super(groupView, parent, title);
        this.groupView = groupView;
    }

    @Override
    protected void okPressed() {
        try {
            if (this.textInputField.getText() == null || this.textInputField.getText().equals("")) {
                return;
            }
            this.groupView.accountGroupDataService.addAccountGroup(this.textInputField.getText());
            super.okPressed();
        }
        catch (DataIntegrityViolationException ex) {
            MessageDialog.openError((Shell)this.groupView.parent.getShell(), (String)Messages.GroupView_23, (String)Messages.GroupView_24);
        }
        catch (Exception ex) {
            MessageDialog.openError((Shell)this.groupView.parent.getShell(), (String)Messages.GroupView_23, (String)ex.getLocalizedMessage());
            LOG.error((Object)"adding group failed", (Throwable)ex);
        }
    }

    @Override
    protected boolean isEditable() {
        return true;
    }
}

