/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.accountgroup;

import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import sernet.gs.ui.rcp.main.bsi.views.Messages;
import sernet.verinice.rcp.IllegalSelectionException;
import sernet.verinice.rcp.accountgroup.AccountGroupView;
import sernet.verinice.rcp.accountgroup.CRUDAccountGroupDialog;

class EditGroupDialog
extends CRUDAccountGroupDialog {
    private static final Logger LOG = Logger.getLogger(EditGroupDialog.class);
    private final AccountGroupView groupView;
    private String selection;

    public EditGroupDialog(AccountGroupView groupView, Shell parent, String title) {
        super(groupView, parent, title);
        this.groupView = groupView;
        if (this.groupView.isStandardGroup()) {
            this.groupView.openStandardGroupWarningDialog(Messages.GroupView_35);
            super.closeTray();
        } else if (this.groupView.isGroupSelected()) {
            this.selection = this.groupView.getSelectedGroup();
        } else {
            throw new IllegalSelectionException("an account group must be selected");
        }
    }

    @Override
    public void create() {
        super.create();
        this.textInputField.setText(this.selection);
    }

    @Override
    protected boolean isEditable() {
        return true;
    }

    @Override
    protected void okPressed() {
        if (this.textInputField.getText() == null || this.textInputField.getText().equals("")) {
            return;
        }
        if (this.textInputField.getText().equals(this.selection)) {
            super.okPressed();
            return;
        }
        if (this.existsGroup()) {
            String msg = String.format(Messages.GroupView_31, this.textInputField.getText());
            MessageDialog messageDialog = new MessageDialog(this.groupView.parent.getShell(), Messages.GroupView_16, null, msg, 3, new String[]{Messages.GroupView_30, Messages.GroupView_27}, 0);
            int result = messageDialog.open();
            if (result == 0) {
                this.groupView.accountGroupDataService.editAccountGroupName(this.textInputField.getText(), this.selection);
            }
        } else {
            try {
                this.groupView.accountGroupDataService.editAccountGroupName(this.textInputField.getText(), this.selection);
            }
            catch (Exception ex) {
                MessageDialog.openError((Shell)this.groupView.parent.getShell(), (String)"Error", (String)ex.getLocalizedMessage());
                LOG.error((Object)"editing account group name failed", (Throwable)ex);
            }
        }
        super.okPressed();
    }

    private boolean existsGroup() {
        return ArrayUtils.contains((Object[])this.groupView.getAllGroupsFromTable(), (Object)this.textInputField.getText());
    }
}

