/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.accountgroup;

import org.apache.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import sernet.gs.ui.rcp.main.bsi.views.Messages;
import sernet.verinice.rcp.accountgroup.AccountGroupView;

class DeleteGroupAction
extends Action {
    private static final Logger LOG = Logger.getLogger(DeleteGroupAction.class);
    private final AccountGroupView groupView;

    DeleteGroupAction(AccountGroupView groupView) {
        this.groupView = groupView;
    }

    public void run() {
        if (this.groupView.isStandardGroup()) {
            this.groupView.openStandardGroupWarningDialog(Messages.GroupView_22);
            return;
        }
        AccountGroupView.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    int connectedAccounts = DeleteGroupAction.this.groupView.accountGroupDataService.getAccountNamesForGroup(DeleteGroupAction.this.groupView.getSelectedGroup()).length;
                    long connectedObjects = DeleteGroupAction.this.groupView.accountService.countConnectObjectsForGroup(DeleteGroupAction.this.groupView.getSelectedGroup());
                    String message = String.format(Messages.GroupView_25, connectedAccounts, connectedObjects);
                    MessageDialog dialog = new MessageDialog(DeleteGroupAction.this.groupView.parent.getShell(), Messages.GroupView_16, null, message, 1, new String[]{Messages.GroupView_26, Messages.GroupView_27}, 0);
                    int result = dialog.open();
                    if (result == 0) {
                        if (!DeleteGroupAction.this.isGroupEmptyAndNotConnectedToObject()) {
                            DeleteGroupAction.this.openSecondWarningDialog();
                        } else {
                            DeleteGroupAction.this.deleteGroup();
                        }
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)"error while deleting group", (Throwable)ex);
                }
            }
        });
    }

    private void openSecondWarningDialog() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                AccountGroupView.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            MessageDialog dialog = new MessageDialog((this).DeleteGroupAction.this.groupView.parent.getShell(), Messages.GroupView_28, null, Messages.GroupView_29, 1, new String[]{Messages.GroupView_26, Messages.GroupView_27}, 0);
                            int result = dialog.open();
                            if (result == 0) {
                                DeleteGroupAction.this.deleteGroup();
                            }
                        }
                        catch (Exception ex) {
                            LOG.error((Object)"error while deleting group", (Throwable)ex);
                        }
                    }
                });
            }
        }).start();
    }

    private boolean isGroupEmptyAndNotConnectedToObject() {
        return this.hasAccounts() && this.hasObjects();
    }

    private boolean hasObjects() {
        return this.groupView.accountService.countConnectObjectsForGroup(this.groupView.getSelectedGroup()) == 0L;
    }

    private boolean hasAccounts() {
        return this.groupView.accountGroupDataService.getAccountNamesForGroup(this.groupView.getSelectedGroup()).length == 0;
    }

    private void deleteGroup() {
        this.groupView.accountGroupDataService.deleteAccountGroup(this.groupView.getSelectedGroup());
        this.groupView.refreshView();
    }
}

