/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.accountgroup;

import java.lang.reflect.InvocationTargetException;
import java.text.Collator;
import java.util.Arrays;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.gs.ui.rcp.main.actions.helper.UpdateConfigurationHelper;
import sernet.gs.ui.rcp.main.bsi.views.Messages;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.common.model.DefaultModelLoadListener;
import sernet.gs.ui.rcp.main.common.model.PlaceHolder;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.IAccountService;
import sernet.verinice.interfaces.IAuthService;
import sernet.verinice.interfaces.IRightsService;
import sernet.verinice.iso27k.rcp.JobScheduler;
import sernet.verinice.model.common.configuration.Configuration;
import sernet.verinice.model.iso27k.ISO27KModel;
import sernet.verinice.rcp.RightsEnabledView;
import sernet.verinice.rcp.account.AccountWizard;
import sernet.verinice.rcp.accountgroup.AccountContentProvider;
import sernet.verinice.rcp.accountgroup.AccountGroupDataService;
import sernet.verinice.rcp.accountgroup.AccountLabelProvider;
import sernet.verinice.rcp.accountgroup.DeleteGroupAction;
import sernet.verinice.rcp.accountgroup.EditGroupDialog;
import sernet.verinice.rcp.accountgroup.IAccountGroupViewDataService;
import sernet.verinice.rcp.accountgroup.NewGroupDialog;
import sernet.verinice.service.account.AccountLoader;

public class AccountGroupView
extends RightsEnabledView {
    private static final Logger LOG = Logger.getLogger(AccountGroupView.class);
    private static final Collator COLLATOR = Collator.getInstance();
    public static final String ID = "sernet.verinice.rcp.accountgroup.GroupView";
    IAccountGroupViewDataService accountGroupDataService;
    IAccountService accountService;
    private Set<String> accountsInGroup = new TreeSet<Object>(COLLATOR);
    private String[] accounts;
    private AccountLabelProvider accountLabelProvider;
    private AccountLabelProvider groupLabelProvider;
    static final Point ADD_REMOVE_BUTTON_SIZE = new Point(30, 30);
    static final Point MARGINS = new Point(5, 5);
    static final Point SPACING = new Point(5, 5);
    static final int GRID_COLUMNS = 4;
    private static final String LEFTWARDS_ARROW = "\u2190";
    private static final String RIGHTWARDS_ARROW = "\u2192";
    private static final String LEFTWARDS_PAIRED_ARROWS = "\u21c7";
    private static final String RIGHTWARDS_PAIRED_ARROWS = "\u21c9";
    private static final String EMPTY_STRING = "";
    Composite parent;
    private Composite container;
    private Text accountGroupsFilter;
    private TableViewer tableAccountGroups;
    private TableViewer tableAccountsInGroup;
    private TableViewer tableAccounts;
    private Button addButton;
    private Button addAllButton;
    private Button removeButton;
    private Button removeAllButton;
    private Button editAccountInAccountsListButton;
    private Button editAccountInAccountsInGroupListButton;
    private Action newGroup;
    private Action deleteGroup;
    private Action editGroup;

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        if (Activator.getDefault().isStandalone()) {
            return;
        }
        this.parent = parent;
        this.accountService = ServiceFactory.lookupAccountService();
        this.setupView();
        this.makeActions();
        this.fillLocalToolBar();
        if (CnAElementFactory.isIsoModelLoaded()) {
            this.initDataService();
        } else {
            DefaultModelLoadListener modelLoadListener = new DefaultModelLoadListener(){

                @Override
                public void loaded(ISO27KModel model) {
                    AccountGroupView.this.initDataService();
                    CnAElementFactory.getInstance().removeLoadListener(this);
                }
            };
            CnAElementFactory.getInstance().addLoadListener(modelLoadListener);
        }
    }

    private void setupView() {
        this.container = new Composite(this.parent, 4);
        this.createAccountGroupsColumn();
        SelectionAdapter scheduleUpdateGroups = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                UpdateGroupsJob updateGroups = new UpdateGroupsJob(Messages.GroupView_13, event);
                JobScheduler.scheduleInitJob(updateGroups);
            }
        };
        this.createAccountsInGroupColumn((SelectionListener)scheduleUpdateGroups);
        this.createButtonsColumn((SelectionListener)scheduleUpdateGroups);
        this.createAccountsColumn((SelectionListener)scheduleUpdateGroups);
        GridLayoutFactory.fillDefaults().numColumns(4).margins(MARGINS).spacing(SPACING).generateLayout(this.container);
        this.switchButtons(false);
        this.updateAllLists();
    }

    private void createAccountGroupsColumn() {
        Group accountGroupsColumn = new Group(this.container, 0);
        accountGroupsColumn.setText(Messages.GroupView_2);
        this.accountGroupsFilter = new Text((Composite)accountGroupsColumn, 2048);
        this.accountGroupsFilter.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                AccountGroupView.this.updateGroupList();
            }
        });
        this.tableAccountGroups = new TableViewer((Composite)accountGroupsColumn, 2052);
        this.tableAccountGroups.setUseHashlookup(true);
        this.tableAccountGroups.setContentProvider((IContentProvider)new AccountContentProvider(this.tableAccountGroups));
        this.tableAccountGroups.setLabelProvider((IBaseLabelProvider)new AccountLabelProvider());
        this.tableAccountGroups.addSelectionChangedListener(event -> {
            SelectionEventHandler handler = new SelectionEventHandler(event);
            handler.handleSelection((EventObject)event);
        });
        this.tableAccountGroups.setInput((Object)new PlaceHolder(Messages.GroupView_41));
        this.tableAccountGroups.refresh(true);
        GridLayoutFactory.fillDefaults().margins(MARGINS).spacing(SPACING).generateLayout((Composite)accountGroupsColumn);
    }

    private void createAccountsInGroupColumn(SelectionListener scheduleUpdateGroups) {
        Group accountsInGroupColumn = new Group(this.container, 0);
        accountsInGroupColumn.setText(Messages.GroupView_3);
        this.tableAccountsInGroup = new TableViewer((Composite)accountsInGroupColumn);
        this.tableAccountsInGroup.setContentProvider((IContentProvider)new AccountContentProvider(this.tableAccountsInGroup));
        this.groupLabelProvider = new AccountLabelProvider();
        this.tableAccountsInGroup.setLabelProvider((IBaseLabelProvider)this.groupLabelProvider);
        this.tableAccountsInGroup.setComparator((ViewerComparator)new AccountComparator());
        this.tableAccountsInGroup.refresh(true);
        this.editAccountInAccountsInGroupListButton = new Button((Composite)accountsInGroupColumn, 8);
        this.editAccountInAccountsInGroupListButton.setText(Messages.GroupView_9);
        this.editAccountInAccountsInGroupListButton.addSelectionListener(scheduleUpdateGroups);
        GridLayoutFactory.fillDefaults().margins(MARGINS).spacing(SPACING).generateLayout((Composite)accountsInGroupColumn);
    }

    private void createButtonsColumn(SelectionListener scheduleUpdateGroups) {
        Composite buttonsColumn = new Composite(this.container, 0);
        this.addButton = new Button(buttonsColumn, 8);
        this.addButton.setText(LEFTWARDS_ARROW);
        this.addButton.setToolTipText(Messages.GroupView_5);
        this.addButton.addSelectionListener(scheduleUpdateGroups);
        GridDataFactory.fillDefaults().hint(ADD_REMOVE_BUTTON_SIZE).applyTo((Control)this.addButton);
        this.removeButton = new Button(buttonsColumn, 8);
        this.removeButton.setText(RIGHTWARDS_ARROW);
        this.removeButton.setToolTipText(Messages.GroupView_7);
        this.removeButton.addSelectionListener(scheduleUpdateGroups);
        GridDataFactory.fillDefaults().hint(ADD_REMOVE_BUTTON_SIZE).applyTo((Control)this.removeButton);
        this.addAllButton = new Button(buttonsColumn, 8);
        this.addAllButton.setText(LEFTWARDS_PAIRED_ARROWS);
        this.addAllButton.setToolTipText(Messages.GroupView_6);
        this.addAllButton.addSelectionListener(scheduleUpdateGroups);
        GridDataFactory.fillDefaults().hint(ADD_REMOVE_BUTTON_SIZE).applyTo((Control)this.addAllButton);
        this.removeAllButton = new Button(buttonsColumn, 8);
        this.removeAllButton.setText(RIGHTWARDS_PAIRED_ARROWS);
        this.removeAllButton.setToolTipText(Messages.GroupView_8);
        this.removeAllButton.addSelectionListener(scheduleUpdateGroups);
        GridDataFactory.fillDefaults().hint(ADD_REMOVE_BUTTON_SIZE).applyTo((Control)this.removeAllButton);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)buttonsColumn);
        GridLayoutFactory.fillDefaults().margins(MARGINS).spacing(SPACING).generateLayout(buttonsColumn);
    }

    private void createAccountsColumn(SelectionListener scheduleUpdateGroups) {
        Group accountsColumn = new Group(this.container, 0);
        accountsColumn.setText(Messages.GroupView_4);
        this.tableAccounts = new TableViewer((Composite)accountsColumn);
        this.tableAccounts.setUseHashlookup(true);
        this.tableAccounts.setContentProvider((IContentProvider)new AccountContentProvider(this.tableAccounts));
        this.accountLabelProvider = new AccountLabelProvider();
        this.tableAccounts.setLabelProvider((IBaseLabelProvider)this.accountLabelProvider);
        this.tableAccounts.setComparator((ViewerComparator)new AccountComparator());
        this.tableAccounts.refresh(true);
        this.editAccountInAccountsListButton = new Button((Composite)accountsColumn, 8);
        this.editAccountInAccountsListButton.setText(Messages.GroupView_9);
        this.editAccountInAccountsListButton.addSelectionListener(scheduleUpdateGroups);
        GridLayoutFactory.fillDefaults().margins(MARGINS).spacing(SPACING).generateLayout((Composite)accountsColumn);
    }

    private void makeActions() {
        this.newGroup = new NewGroupAction();
        this.newGroup.setText(Messages.GroupView_10);
        this.newGroup.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("group_add.png"));
        this.deleteGroup = new DeleteGroupAction(this);
        this.deleteGroup.setText(Messages.GroupView_11);
        this.deleteGroup.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("group_delete.png"));
        this.editGroup = new EditGroupAction();
        this.editGroup.setText(Messages.GroupView_12);
        this.editGroup.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("group_edit.png"));
    }

    private void fillLocalToolBar() {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager manager = bars.getToolBarManager();
        if (this.newGroup != null) {
            manager.add((IAction)this.newGroup);
        }
        if (this.editGroup != null) {
            manager.add((IAction)this.editGroup);
        }
        if (this.deleteGroup != null) {
            manager.add((IAction)this.deleteGroup);
        }
    }

    @Override
    public void setFocus() {
        if (this.container != null) {
            this.container.setFocus();
        }
    }

    void switchButtons(boolean enabled) {
        this.addButton.setEnabled(enabled);
        this.addAllButton.setEnabled(enabled);
        this.removeButton.setEnabled(enabled);
        this.removeAllButton.setEnabled(enabled);
        this.editAccountInAccountsListButton.setEnabled(enabled);
    }

    private void updateAllLists() {
        try {
            if (this.accountGroupDataService != null) {
                this.updateGroupList();
                this.updateGroupToAccountList();
                this.updateAccountList();
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Dataservice not Initialized, cannot update lists");
            }
            this.tableAccounts.refresh(true);
            this.tableAccountGroups.refresh(true);
            this.tableAccountsInGroup.refresh(true);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while setting data to ui widgets", (Throwable)e);
        }
    }

    private void updateAccountList() {
        if (this.accountGroupDataService != null && this.accountGroupDataService.getAllAccounts() != null) {
            this.accounts = this.accountGroupDataService.getAllAccounts();
            for (String account : this.accountsInGroup) {
                if (!ArrayUtils.contains((Object[])this.accounts, (Object)account)) continue;
                this.accounts = (String[])ArrayUtils.remove((Object[])this.accounts, (int)ArrayUtils.indexOf((Object[])this.accounts, (Object)account));
            }
            Arrays.sort(this.accounts, COLLATOR);
            this.tableAccounts.setInput((Object)this.accounts);
        }
    }

    private void updateGroupToAccountList() {
        if (this.isGroupSelected()) {
            this.accountsInGroup.clear();
            String group = this.getSelectedGroup();
            String[] names = this.accountGroupDataService.getAccountNamesForGroup(group);
            this.accountsInGroup.addAll(Arrays.asList(names));
            this.tableAccountsInGroup.setInput(this.accountsInGroup);
        }
    }

    private void updateGroupList() {
        String text = this.accountGroupsFilter.getText();
        if (this.accountGroupDataService != null && this.accountGroupDataService.getAccountGroups() != null) {
            this.applyFilterToAccountGroups(text);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Dataservice not Initialized, cannot update group list");
        }
    }

    private void applyFilterToAccountGroups(String text) {
        String[] accountGroups;
        String[] allAccountGroups;
        boolean isLocalAdmin = this.getAuthService().currentUserHasRole(new String[]{"ROLE_LOCAL_ADMIN"});
        if (isLocalAdmin) {
            List groupNamesForLocalAdmin = AccountLoader.loadGroupNamesForLocalAdmin();
            allAccountGroups = groupNamesForLocalAdmin.toArray(new String[groupNamesForLocalAdmin.size()]);
        } else {
            allAccountGroups = this.accountGroupDataService.getAccountGroups();
        }
        if (text == null || text.isEmpty()) {
            accountGroups = allAccountGroups;
        } else {
            LinkedList<String> filteredList = new LinkedList<String>();
            String[] stringArray = allAccountGroups;
            int n = allAccountGroups.length;
            int n2 = 0;
            while (n2 < n) {
                String group = stringArray[n2];
                if (group.toLowerCase().contains(text.toLowerCase())) {
                    filteredList.add(group);
                }
                ++n2;
            }
            accountGroups = filteredList.toArray(new String[filteredList.size()]);
        }
        Arrays.sort(accountGroups, COLLATOR);
        this.tableAccountGroups.setInput((Object)accountGroups);
    }

    String getSelectedGroup() {
        return (String)((StructuredSelection)this.tableAccountGroups.getSelection()).toList().get(0);
    }

    boolean isGroupSelected() {
        return !((StructuredSelection)this.tableAccountGroups.getSelection()).toList().isEmpty();
    }

    String[] getAllGroupsFromTable() {
        return (String[])this.tableAccountGroups.getInput();
    }

    @Override
    public String getRightID() {
        return "accountsettings";
    }

    @Override
    public String getViewId() {
        return ID;
    }

    static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    void openStandardGroupWarningDialog(String message) {
        new Thread(() -> AccountGroupView.getDisplay().syncExec(() -> {
            try {
                MessageDialog.openWarning((Shell)this.parent.getShell(), (String)Messages.GroupView_23, (String)message);
            }
            catch (Exception ex) {
                LOG.warn((Object)"error while deleting group", (Throwable)ex);
            }
        })).start();
    }

    boolean isStandardGroup() {
        return ArrayUtils.contains((Object[])IRightsService.STANDARD_GROUPS, (Object)this.getSelectedGroup());
    }

    private void initDataService() {
        if (this.accountGroupDataService == null && !Activator.getDefault().isStandalone()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Initializing DataService");
            }
            this.accountGroupDataService = new AccountGroupDataService(this);
        }
    }

    void passServiceToLabelProvider() {
        if (this.accountGroupDataService != null) {
            if (this.accountLabelProvider != null) {
                this.accountLabelProvider.setDataService(this.accountGroupDataService);
            }
            if (this.groupLabelProvider != null) {
                this.groupLabelProvider.setDataService(this.accountGroupDataService);
            }
        }
    }

    void refreshView() {
        this.updateAllLists();
    }

    public void setActionsEnabled(boolean enabled) {
        this.newGroup.setEnabled(enabled);
        this.deleteGroup.setEnabled(enabled);
        this.editGroup.setEnabled(enabled);
    }

    private IAuthService getAuthService() {
        return ServiceFactory.lookupAuthService();
    }

    private class AccountComparator
    extends ViewerComparator {
        private AccountComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            String t1 = AccountGroupView.this.accountGroupDataService.getPrettyPrintAccountName((String)e1);
            String t2 = AccountGroupView.this.accountGroupDataService.getPrettyPrintAccountName((String)e2);
            if (t1 != null && t2 != null) {
                t1 = t1.toLowerCase();
                t2 = t2.toLowerCase();
                return t1.compareTo(t2);
            }
            return 0;
        }
    }

    private class EditGroupAction
    extends Action {
        private EditGroupAction() {
        }

        public void run() {
            EditGroupDialog dialog = new EditGroupDialog(AccountGroupView.this, AccountGroupView.this.parent.getShell(), Messages.GroupView_19);
            dialog.open();
        }
    }

    private class NewGroupAction
    extends Action {
        private NewGroupAction() {
        }

        public void run() {
            NewGroupDialog newGroupDialog = new NewGroupDialog(AccountGroupView.this, AccountGroupView.this.parent.getShell(), Messages.GroupView_18);
            newGroupDialog.open();
        }
    }

    private final class SelectionEventHandler
    implements Runnable {
        private final EventObject event;

        private SelectionEventHandler(SelectionEvent event) {
            this.event = event;
        }

        private SelectionEventHandler(SelectionChangedEvent event) {
            this.event = event;
        }

        @Override
        public void run() {
            try {
                try {
                    AccountGroupView.this.switchButtons(false);
                    this.handleSelection(this.event);
                }
                catch (RuntimeException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    LOG.error((Object)String.format("problems with updating group view: %s", ex.getLocalizedMessage()), (Throwable)ex);
                    AccountGroupView.this.switchButtons(true);
                }
            }
            finally {
                AccountGroupView.this.switchButtons(true);
            }
        }

        private void handleSelection(EventObject event) {
            if (AccountGroupView.this.isGroupSelected()) {
                AccountGroupView.this.switchButtons(true);
                if (event.getSource() == AccountGroupView.this.tableAccountGroups) {
                    String[] accountNames = AccountGroupView.this.accountGroupDataService.getAccountNamesForGroup(AccountGroupView.this.getSelectedGroup());
                    AccountGroupView.this.accountsInGroup.clear();
                    AccountGroupView.this.accountsInGroup.addAll(Arrays.asList(accountNames));
                } else if (event.getSource() == AccountGroupView.this.tableAccountsInGroup) {
                    AccountGroupView.this.tableAccounts.setSelection((ISelection)new StructuredSelection());
                } else if (event.getSource() == AccountGroupView.this.tableAccounts) {
                    AccountGroupView.this.tableAccountsInGroup.setSelection((ISelection)new StructuredSelection());
                } else if (event.getSource() == AccountGroupView.this.addButton) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)AccountGroupView.this.tableAccounts.getSelection();
                    this.addAccounts((String[])Arrays.copyOf(structuredSelection.toArray(), structuredSelection.toArray().length, String[].class));
                } else if (event.getSource() == AccountGroupView.this.addAllButton) {
                    this.addAllAccounts(AccountGroupView.this.accounts);
                } else if (event.getSource() == AccountGroupView.this.removeButton) {
                    IStructuredSelection selection = (IStructuredSelection)AccountGroupView.this.tableAccountsInGroup.getSelection();
                    this.removeAccounts((String[])Arrays.copyOf(selection.toArray(), selection.toArray().length, String[].class));
                } else if (event.getSource() == AccountGroupView.this.removeAllButton) {
                    Set set = (Set)AccountGroupView.this.tableAccountsInGroup.getInput();
                    this.removeAllAccounts((String[])Arrays.copyOf(set.toArray(), set.size(), String[].class));
                }
                AccountGroupView.this.updateAllLists();
            } else {
                AccountGroupView.this.switchButtons(false);
            }
            if (event.getSource() == AccountGroupView.this.editAccountInAccountsListButton || event.getSource() == AccountGroupView.this.editAccountInAccountsInGroupListButton) {
                this.initAccountWizard(event);
            }
        }

        private void initAccountWizard(EventObject event) {
            String selectedAccountName = AccountGroupView.EMPTY_STRING;
            if (event.getSource() == AccountGroupView.this.editAccountInAccountsListButton) {
                selectedAccountName = this.getAccountSelectedInAccountsList();
            } else if (event.getSource() == AccountGroupView.this.editAccountInAccountsInGroupListButton) {
                selectedAccountName = this.getAccountSelectedInAccountsInGroupList();
            }
            if (!selectedAccountName.isEmpty()) {
                Configuration configuration = AccountGroupView.this.accountService.getAccountByName(selectedAccountName);
                AccountWizard wizard = new AccountWizard(configuration);
                WizardDialog accountDialog = new WizardDialog(AccountGroupView.getDisplay().getActiveShell(), (IWizard)wizard);
                if (accountDialog.open() != 0) {
                    return;
                }
                try {
                    PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)new UpdateConfigurationCallbackHelper(configuration));
                }
                catch (Exception e) {
                    LOG.error((Object)Messages.GroupView_15, (Throwable)e);
                }
            } else {
                MessageDialog.openWarning((Shell)AccountGroupView.this.parent.getShell(), (String)Messages.GroupView_16, (String)Messages.GroupView_17);
            }
        }

        private String getAccountSelectedInAccountsList() {
            IStructuredSelection selection;
            if (AccountGroupView.this.tableAccounts.getSelection() != null && !(selection = (IStructuredSelection)AccountGroupView.this.tableAccounts.getSelection()).isEmpty()) {
                return (String)selection.getFirstElement();
            }
            return AccountGroupView.EMPTY_STRING;
        }

        private String getAccountSelectedInAccountsInGroupList() {
            IStructuredSelection selection;
            if (AccountGroupView.this.tableAccountsInGroup.getSelection() != null && !(selection = (IStructuredSelection)AccountGroupView.this.tableAccountsInGroup.getSelection()).isEmpty()) {
                return (String)selection.getFirstElement();
            }
            return AccountGroupView.EMPTY_STRING;
        }

        private void addAllAccounts(String[] items) {
            int result = new MessageDialog(AccountGroupView.this.parent.getShell(), Messages.GroupView_33, null, Messages.GroupView_34, 3, new String[]{Messages.GroupView_32, Messages.GroupView_27}, 0).open();
            if (result == 0) {
                this.addAccounts(items);
            }
        }

        private void addAccounts(String[] selectedAccounts) {
            String[] accountGroupData;
            String[] stringArray = accountGroupData = AccountGroupView.this.accountGroupDataService.saveAccountGroupData(AccountGroupView.this.getSelectedGroup(), selectedAccounts);
            int n = accountGroupData.length;
            int n2 = 0;
            while (n2 < n) {
                String account = stringArray[n2];
                if (!AccountGroupView.this.accountsInGroup.contains(account)) {
                    AccountGroupView.this.accountsInGroup.add(account);
                }
                ++n2;
            }
        }

        private void removeAllAccounts(String[] items) {
            int result = new MessageDialog(AccountGroupView.this.parent.getShell(), Messages.GroupView_38, null, Messages.GroupView_36, 3, new String[]{Messages.GroupView_37, Messages.GroupView_27}, 0).open();
            if (result == 0) {
                this.removeAccounts(items);
            }
        }

        private void removeAccounts(String[] accounts) {
            String[] items;
            String[] stringArray = items = AccountGroupView.this.accountGroupDataService.deleteAccountGroupData(AccountGroupView.this.getSelectedGroup(), accounts);
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                String i = stringArray[n2];
                AccountGroupView.this.accountsInGroup.remove(i);
                ++n2;
            }
        }
    }

    private class UpdateConfigurationCallbackHelper
    extends UpdateConfigurationHelper {
        public UpdateConfigurationCallbackHelper(Configuration configuration) {
            super(configuration);
        }

        @Override
        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            super.run(monitor);
            AccountGroupView.this.refreshView();
        }
    }

    private final class UpdateGroupsJob
    extends WorkspaceJob {
        private final SelectionEvent event;

        private UpdateGroupsJob(String name, SelectionEvent event) {
            super(name);
            this.event = event;
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) {
            IStatus status = Status.OK_STATUS;
            try {
                try {
                    monitor.beginTask(Messages.GroupView_13, -1);
                    Activator.inheritVeriniceContextState();
                    this.updateGroups(this.event);
                }
                catch (Exception e) {
                    LOG.error((Object)Messages.GroupView_1, (Throwable)e);
                    status = new Status(4, "sernet.gs.ui.rcp.main", Messages.GroupView_1, (Throwable)e);
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
            return status;
        }

        private void updateGroups(SelectionEvent event) {
            AccountGroupView.getDisplay().syncExec((Runnable)new SelectionEventHandler(event));
        }
    }
}

