/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.accountgroup;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import sernet.gs.service.NumericStringComparator;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.IAccountSearchParameter;
import sernet.verinice.interfaces.IAccountService;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.ICommandService;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.common.PersonAdapter;
import sernet.verinice.model.common.accountgroup.AccountGroup;
import sernet.verinice.model.common.configuration.Configuration;
import sernet.verinice.rcp.accountgroup.AccountGroupView;
import sernet.verinice.rcp.accountgroup.IAccountGroupViewDataService;
import sernet.verinice.rcp.accountgroup.Messages;
import sernet.verinice.service.account.AccountSearchParameter;
import sernet.verinice.service.commands.LoadVisibleAccounts;

public class AccountGroupDataService
implements IAccountGroupViewDataService {
    private static final Logger logger = Logger.getLogger(AccountGroupDataService.class);
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private IAccountService accountService = ServiceFactory.lookupAccountService();
    private ICommandService commandService;
    private Map<String, Set<String>> accountGroupToConfiguration;
    private Set<String> accounts;
    private Map<String, String> prettyAccountNames;
    private AccountGroupView view;

    public AccountGroupDataService() {
        this.runLoadDataJob();
    }

    public AccountGroupDataService(AccountGroupView view) {
        this();
        this.view = view;
    }

    @Override
    public String[] getAccountGroups() {
        if (this.accountGroupToConfiguration != null && this.accountGroupToConfiguration.keySet() != null) {
            return this.convertToStringArray(this.accountGroupToConfiguration.keySet());
        }
        return EMPTY_STRING_ARRAY;
    }

    @Override
    public String[] getAllAccounts() {
        if (this.accounts != null) {
            return this.convertToStringArray(this.accounts);
        }
        return EMPTY_STRING_ARRAY;
    }

    @Override
    public final void runLoadDataJob() {
        final class LoadAccountGroupDataJob
        extends Job {
            public LoadAccountGroupDataJob(String name) {
                super(name);
            }

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    AccountGroupDataService.this.loadData();
                }
                catch (Exception e) {
                    logger.error((Object)"Error loading account group data", (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        }
        new LoadAccountGroupDataJob(Messages.loadDataJoblabel).schedule();
    }

    public void loadData() throws CommandException {
        Activator.inheritVeriniceContextState();
        List accountGroups = this.accountService.listGroups();
        this.accountGroupToConfiguration = new TreeMap<String, Set<String>>((Comparator<String>)new NumericStringComparator());
        this.accounts = this.loadVisibleLoginNames();
        for (AccountGroup accountGroup : accountGroups) {
            this.accountGroupToConfiguration.put(accountGroup.getName(), new HashSet());
        }
        List allAccounts = this.accountService.findAccounts((IAccountSearchParameter)AccountSearchParameter.newInstance());
        this.prettyAccountNames = new HashMap<String, String>(allAccounts.size());
        for (Configuration conf : allAccounts) {
            String user = conf.getUser();
            for (String role : conf.getRoles()) {
                if (!this.accountGroupToConfiguration.containsKey(role)) continue;
                this.accountGroupToConfiguration.get(role).add(user);
            }
            this.prettyAccountNames.put(user, AccountGroupDataService.createPrettyAccountName(conf));
        }
        if (this.view != null) {
            Display.getDefault().syncExec(() -> {
                this.view.passServiceToLabelProvider();
                this.view.refreshView();
                this.view.switchButtons(true);
            });
        }
    }

    private Set<String> loadVisibleLoginNames() throws CommandException {
        LoadVisibleAccounts loadVisibleAccounts = new LoadVisibleAccounts();
        loadVisibleAccounts = (LoadVisibleAccounts)this.getCommandService().executeCommand((ICommand)loadVisibleAccounts);
        HashSet<String> loginNames = new HashSet<String>();
        for (Configuration account : loadVisibleAccounts.getAccountList()) {
            loginNames.add(account.getUser());
        }
        return loginNames;
    }

    @Override
    public String[] getAccountNamesForGroup(String accountGroupName) {
        return this.convertToStringArray(this.accountGroupToConfiguration.get(accountGroupName));
    }

    private <T> String[] convertToStringArray(Set<T> accountGroupOrConfiguration) {
        TreeSet<String> set = new TreeSet<String>((Comparator<String>)new NumericStringComparator());
        for (T accountOrGroup : accountGroupOrConfiguration) {
            if (accountOrGroup instanceof AccountGroup) {
                set.add(((AccountGroup)accountOrGroup).getName());
                continue;
            }
            if (accountOrGroup instanceof Configuration) {
                set.add(((Configuration)accountOrGroup).getUser());
                continue;
            }
            if (accountOrGroup instanceof String) {
                set.add((String)accountOrGroup);
                continue;
            }
            throw new IllegalArgumentException(String.format("%s is not supported", accountOrGroup.getClass().getSimpleName()));
        }
        String[] result = new String[set.size()];
        set.toArray(result);
        return result;
    }

    @Override
    public void addAccountGroup(String accountGroupName) {
        if (!this.accountGroupToConfiguration.containsKey(accountGroupName)) {
            this.accountGroupToConfiguration.put(accountGroupName, new TreeSet(new NumericStringComparator()));
        }
        this.accountService.createAccountGroup(accountGroupName);
    }

    @Override
    public String[] saveAccountGroupData(String groupName, String[] accountNames) {
        try {
            Set selectedAccounts = this.accountService.addRole(new HashSet<String>(Arrays.asList(accountNames)), groupName);
            for (String account : selectedAccounts) {
                this.accountGroupToConfiguration.get(groupName).add(account);
            }
            return this.convertToStringArray(this.accountGroupToConfiguration.get(groupName));
        }
        catch (Exception ex) {
            logger.error((Object)"updated view for account groups failed", (Throwable)ex);
            return new String[0];
        }
    }

    @Override
    public void editAccountGroupName(String newRoleName, String oldRoleName) {
        if (newRoleName.equals(oldRoleName)) {
            throw new IllegalArgumentException(String.format("name is not changed: %s", newRoleName));
        }
        if (!this.accountGroupToConfiguration.containsKey(newRoleName)) {
            this.accountGroupToConfiguration.put(newRoleName, new TreeSet(new NumericStringComparator()));
            this.accountService.createAccountGroup(newRoleName);
        }
        this.accountGroupToConfiguration.get(newRoleName).addAll((Collection<String>)this.accountGroupToConfiguration.get(oldRoleName));
        this.accountGroupToConfiguration.remove(oldRoleName);
        this.accountService.deleteAccountGroup(oldRoleName);
        this.accountService.deleteRole(this.accountGroupToConfiguration.get(newRoleName), oldRoleName);
        this.accountService.addRole(this.accountGroupToConfiguration.get(newRoleName), newRoleName);
        this.accountService.updatePermissions(newRoleName, oldRoleName);
    }

    @Override
    public Set<String> deleteAccountGroup(String role) {
        Set<String> evictedAccounts = this.accountGroupToConfiguration.get(role);
        this.accountGroupToConfiguration.remove(role);
        this.accountService.deleteAccountGroup(role);
        this.accountService.deletePermissions(role);
        return this.accountService.deleteRole(evictedAccounts, role);
    }

    @Override
    public String[] deleteAccountGroupData(String groupName, String[] userNames) {
        this.accountGroupToConfiguration.get(groupName).removeAll(new HashSet<String>(Arrays.asList(userNames)));
        Set deletedAccounts = this.accountService.deleteRole(new HashSet<String>(Arrays.asList(userNames)), groupName);
        return this.convertToStringArray(deletedAccounts);
    }

    @Override
    public String getPrettyPrintAccountName(String account) {
        this.initPrettyAccountNames();
        if (this.prettyAccountNames.containsKey(account)) {
            return this.prettyAccountNames.get(account);
        }
        return account;
    }

    private void initPrettyAccountNames() {
        if (this.prettyAccountNames == null) {
            this.prettyAccountNames = new HashMap<String, String>(0);
            for (Configuration conf : this.accountService.findAccounts((IAccountSearchParameter)AccountSearchParameter.newInstance())) {
                this.prettyAccountNames.put(conf.getUser(), AccountGroupDataService.createPrettyAccountName(conf));
            }
        }
    }

    private static String createPrettyAccountName(Configuration account) {
        StringBuilder sb = new StringBuilder(PersonAdapter.getFullName((CnATreeElement)account.getPerson()));
        sb.append(" [").append(account.getUser()).append("]");
        return sb.toString();
    }

    public ICommandService getCommandService() {
        if (this.commandService == null) {
            this.commandService = ServiceFactory.lookupCommandService();
        }
        return this.commandService;
    }
}

