/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.account;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import sernet.hui.common.VeriniceContext;
import sernet.verinice.interfaces.IRightsServiceClient;
import sernet.verinice.model.auth.ProfileRef;
import sernet.verinice.model.auth.Userprofile;
import sernet.verinice.rcp.ProfileLabelProvider;
import sernet.verinice.rcp.ProfileTableComparator;
import sernet.verinice.rcp.account.BaseWizardPage;
import sernet.verinice.rcp.account.Messages;

public class ProfilePage
extends BaseWizardPage {
    private static final Logger LOG = Logger.getLogger(ProfilePage.class);
    public static final String PAGE_NAME = "account-wizard-profile-page";
    private String login;
    Set<ProfileRef> profileSet;
    private TableViewer table;
    private IRightsServiceClient rightsService;

    protected ProfilePage() {
        super(PAGE_NAME);
    }

    @Override
    protected void initGui(Composite composite) {
        this.setTitle(Messages.ProfilePage_1);
        this.setMessage(Messages.ProfilePage_2);
        Label label = new Label(composite, 0);
        label.setText(Messages.ProfilePage_3);
        this.table = this.createTable(composite, Messages.ProfilePage_4);
        this.table.setLabelProvider((IBaseLabelProvider)new ProfileLabelProvider());
        this.table.setComparator((ViewerComparator)new ProfileTableComparator());
        this.table.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.table.refresh(true);
    }

    private TableViewer createTable(Composite parent, String title) {
        Label label = new Label(parent, 64);
        label.setText(title);
        label.setLayoutData((Object)new GridData(4, 128, true, false));
        TableViewer table0 = new TableViewer(parent, 2818);
        GridData gd = new GridData(4, 4, true, true);
        table0.getControl().setLayoutData((Object)gd);
        table0.setUseHashlookup(true);
        return table0;
    }

    @Override
    protected void initData() throws Exception {
        this.profileSet = new HashSet<ProfileRef>();
        List userProfileList = this.getRightService().getUserprofile(this.login);
        for (Userprofile userprofile : userProfileList) {
            this.profileSet.addAll(userprofile.getProfileRef());
        }
        this.table.setInput(this.profileSet);
    }

    public boolean isPageComplete() {
        boolean complete = true;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("page complete: " + complete));
        }
        return complete;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    private IRightsServiceClient getRightService() {
        if (this.rightsService == null) {
            this.rightsService = (IRightsServiceClient)VeriniceContext.get((String)"rightsService");
        }
        return this.rightsService;
    }
}

