/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.account;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import sernet.gs.service.RetrieveInfo;
import sernet.gs.service.Retriever;
import sernet.gs.service.RuntimeCommandException;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.iso27k.rcp.ComboModel;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.common.configuration.Configuration;
import sernet.verinice.rcp.ElementSelectionComponent;
import sernet.verinice.rcp.account.BaseWizardPage;
import sernet.verinice.rcp.account.GenericPerson;
import sernet.verinice.rcp.account.Messages;
import sernet.verinice.service.commands.LoadCnAElementByEntityTypeId;
import sernet.verinice.service.commands.LoadConfiguration;
import sernet.verinice.service.commands.RetrieveCnATreeElement;

public class PersonPage
extends BaseWizardPage {
    private static final Logger LOG = Logger.getLogger(PersonPage.class);
    public static final String PAGE_NAME = "account-wizard-person-page";
    private CnATreeElement person;
    private CnATreeElement group;
    private CnATreeElement scope;
    private ComboModel<CnATreeElement> comboModelScope;
    private Combo comboScope;
    private ComboModel<CnATreeElement> comboModelGroup;
    private Combo comboGroup;
    private ElementSelectionComponent personComponent;
    private Label personLabel;
    private boolean isNewAccount = false;

    protected PersonPage() {
        super(PAGE_NAME);
    }

    @Override
    protected void initGui(Composite parent) {
        this.setTitle(Messages.PersonPage_1);
        this.selectMessage();
        Label label = new Label(parent, 0);
        label.setText(Messages.PersonPage_0);
        this.comboScope = new Combo(parent, 12);
        this.comboScope.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.comboScope.setEnabled(this.isNewAccount());
        this.comboScope.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = PersonPage.this.comboScope.getSelectionIndex();
                if (selectionIndex == 0) {
                    PersonPage.this.person = null;
                }
                PersonPage.this.comboModelScope.setSelectedIndex(selectionIndex);
                PersonPage.this.scope = PersonPage.this.comboModelScope.getSelectedObject();
                PersonPage.this.checkIfScopeIsPersonScope();
                PersonPage.this.personComponent.setTypeIds(PersonPage.this.getPersonTypeIds());
                PersonPage.this.personComponent.setScopeId(PersonPage.this.getScopeId());
                PersonPage.this.personComponent.loadElements();
                PersonPage.this.loadGroups();
            }
        });
        label = new Label(parent, 0);
        label.setText(Messages.PersonPage_5);
        this.comboGroup = new Combo(parent, 12);
        this.comboGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.comboGroup.setEnabled(this.isNewAccount());
        this.comboGroup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PersonPage.this.comboModelGroup.setSelectedIndex(PersonPage.this.comboGroup.getSelectionIndex());
                PersonPage.this.group = PersonPage.this.comboModelGroup.getSelectedObject();
                PersonPage.this.personComponent.setGroupId(PersonPage.this.getGroupId());
                PersonPage.this.personComponent.loadElements();
            }
        });
        Composite personComposite = this.createEmptyComposite(parent);
        this.personComponent = new ElementSelectionComponent(personComposite, this.getPersonTypeIds(), this.getScopeId(), this.getGroupId());
        this.personComponent.setScopeOnly(true);
        this.personComponent.setShowScopeCheckbox(false);
        this.personComponent.setHeight(200);
        this.personComponent.init();
        this.personComponent.getViewer().addSelectionChangedListener(event -> this.selectPerson());
        this.personLabel = new Label(parent, 0);
        this.showSelectedPerson();
    }

    protected void checkIfScopeIsPersonScope() {
        if (this.scope != null && this.person != null && !this.scope.getDbId().equals(this.person.getScopeId())) {
            this.deselectPerson();
        }
    }

    private void deselectPerson() {
        this.personComponent.deselectElements();
        this.selectPerson();
    }

    private void selectMessage() {
        if (this.isNewAccount()) {
            this.setMessage(Messages.PersonPage_2);
        } else {
            this.setMessage(Messages.PersonPage_3, 1);
        }
    }

    private void selectPerson() {
        this.setErrorMessage(null);
        if (!this.isNewAccount()) {
            return;
        }
        List<CnATreeElement> selectedElements = this.personComponent.getSelectedElements();
        this.person = selectedElements != null && !selectedElements.isEmpty() ? selectedElements.get(0) : null;
        this.validatePerson();
        this.showSelectedPerson();
        this.setPageComplete(this.isPageComplete());
    }

    private void validatePerson() {
        try {
            if (this.person != null) {
                LoadConfiguration command = new LoadConfiguration(this.person);
                command = (LoadConfiguration)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
                Configuration account = command.getConfiguration();
                if (account != null) {
                    this.person = null;
                    this.setErrorMessage(Messages.PersonPage_4);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while validating person", (Throwable)e);
        }
    }

    private void showSelectedPerson() {
        if (this.person != null) {
            this.person = Retriever.checkRetrieveElement((CnATreeElement)this.person);
            GenericPerson genericPerson = new GenericPerson(this.person);
            this.personLabel.setText(String.valueOf(Messages.PersonPage_6) + genericPerson.getName());
        } else {
            this.personLabel.setText(Messages.PersonPage_7);
        }
        this.personLabel.pack();
    }

    @Override
    protected void initData() throws Exception {
        this.comboModelScope = new ComboModel<CnATreeElement>(CnATreeElement::getTitle);
        this.comboModelGroup = new ComboModel<CnATreeElement>(CnATreeElement::getTitle);
        this.loadScopes();
        this.personComponent.loadElements();
    }

    public boolean isPageComplete() {
        boolean complete;
        boolean bl = complete = this.getPerson() != null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("page complete: " + complete));
        }
        return complete;
    }

    private List<CnATreeElement> loadEntitiesByTypeId(String typeId) throws CommandException {
        LoadCnAElementByEntityTypeId command = new LoadCnAElementByEntityTypeId(typeId);
        return ((LoadCnAElementByEntityTypeId)this.getCommandService().executeCommand((ICommand)command)).getElements();
    }

    private void loadScopes() throws CommandException {
        this.comboModelScope.clear();
        this.comboModelScope.addAll(this.loadEntitiesByTypeId("org"));
        this.comboModelScope.addAll(this.loadEntitiesByTypeId("it-verbund"));
        this.comboModelScope.addAll(this.loadEntitiesByTypeId("bp_itnetwork"));
        this.comboModelScope.sort();
        this.comboModelScope.addNoSelectionObject(Messages.PersonPage_8);
        PersonPage.getDisplay().syncExec(() -> {
            this.comboScope.setItems(this.comboModelScope.getLabelArray());
            if (this.scope != null) {
                this.comboModelScope.setSelectedObject(this.scope);
                this.comboScope.select(this.comboModelScope.getSelectedIndex());
                this.personComponent.setScopeId(this.getScopeId());
                this.loadGroups();
            } else {
                this.comboScope.select(0);
                this.comboModelScope.setSelectedIndex(this.comboScope.getSelectionIndex());
            }
        });
    }

    private static String findGroupTypeIdByPersonTypeId(String personTypeId) {
        switch (personTypeId) {
            case "person-iso": {
                return "persongroup";
            }
            case "bp_person": {
                return "bp_person_group";
            }
        }
        return null;
    }

    private void loadGroups() {
        try {
            this.comboModelGroup.clear();
            Set<String> groupTypeIds = this.getPersonTypeIds().stream().map(PersonPage::findGroupTypeIdByPersonTypeId).filter(Objects::nonNull).collect(Collectors.toSet());
            if (!groupTypeIds.isEmpty()) {
                this.loadPersonGroups(groupTypeIds);
            }
            PersonPage.getDisplay().syncExec(() -> {
                this.comboGroup.setItems(this.comboModelGroup.getLabelArray());
                if (this.group != null) {
                    this.comboModelGroup.setSelectedObject(this.group);
                    this.selectFirstIfNoGroupIsSelected();
                    this.comboGroup.select(this.comboModelGroup.getSelectedIndex());
                } else {
                    this.comboGroup.select(0);
                    this.comboModelGroup.setSelectedIndex(this.comboGroup.getSelectionIndex());
                }
                this.group = this.comboModelGroup.getSelectedObject();
                this.personComponent.setGroupId(this.getGroupId());
                this.personComponent.loadElementsAndSelect(this.person);
            });
        }
        catch (Exception e) {
            LOG.error((Object)"Error while loading groups", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void loadPersonGroups(Set<String> typeIds) {
        List elements = typeIds.stream().flatMap(typeId -> {
            LoadCnAElementByEntityTypeId command = new LoadCnAElementByEntityTypeId(typeId, this.getScopeId());
            try {
                command = (LoadCnAElementByEntityTypeId)this.getCommandService().executeCommand((ICommand)command);
            }
            catch (CommandException e) {
                throw new RuntimeCommandException((Throwable)e);
            }
            return command.getElements().stream();
        }).collect(Collectors.toList());
        this.comboModelGroup.addAll(elements);
        this.comboModelGroup.sort();
        this.comboModelGroup.addNoSelectionObject(Messages.PersonPage_9);
    }

    private void selectFirstIfNoGroupIsSelected() {
        if (this.comboModelGroup.getSelectedIndex() == -1) {
            this.comboModelGroup.setSelectedIndex(0);
        }
    }

    private void loadGroup(CnATreeElement person) {
        try {
            String personTypeId = person.getTypeId();
            String groupTypeId = PersonPage.findGroupTypeIdByPersonTypeId(personTypeId);
            if (groupTypeId != null) {
                RetrieveCnATreeElement retrieveCommand = new RetrieveCnATreeElement(groupTypeId, person.getParentId(), RetrieveInfo.getPropertyInstance());
                retrieveCommand = (RetrieveCnATreeElement)this.getCommandService().executeCommand((ICommand)retrieveCommand);
                this.group = retrieveCommand.getElement();
            }
        }
        catch (CommandException e) {
            LOG.error((Object)"Error while loading group.", (Throwable)e);
        }
    }

    private void loadScope(String personTypeId) {
        try {
            String typeId = "bp_person".equals(personTypeId) ? "bp_itnetwork" : ("person".equals(personTypeId) ? "itverbund" : "org");
            RetrieveCnATreeElement retrieveCommand = new RetrieveCnATreeElement(typeId, this.getScopeId(), RetrieveInfo.getPropertyInstance());
            retrieveCommand = (RetrieveCnATreeElement)this.getCommandService().executeCommand((ICommand)retrieveCommand);
            this.scope = retrieveCommand.getElement();
        }
        catch (CommandException e) {
            LOG.error((Object)"Error while loading group.", (Throwable)e);
        }
    }

    private Integer getScopeId() {
        Integer id = null;
        if (this.scope != null) {
            id = this.scope.getDbId();
        }
        if (this.person != null) {
            id = this.person.getScopeId();
        }
        return id;
    }

    private Integer getGroupId() {
        Integer id = null;
        if (this.group != null) {
            id = this.group.getDbId();
        }
        return id;
    }

    private Set<String> getPersonTypeIds() {
        if (this.person != null) {
            return Collections.singleton(this.person.getTypeId());
        }
        if (this.scope == null) {
            return new HashSet<String>(Arrays.asList("person", "person-iso", "bp_person"));
        }
        if (this.scope.isItNetwork()) {
            return Collections.singleton("bp_person");
        }
        if (this.scope.isItVerbund()) {
            return Collections.singleton("person");
        }
        return Collections.singleton("person-iso");
    }

    private static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public CnATreeElement getPerson() {
        return this.person;
    }

    public void setPerson(CnATreeElement person) {
        this.person = person;
        if (person != null) {
            this.loadScope(person.getTypeId());
            this.loadGroup(person);
        }
    }

    public boolean isNewAccount() {
        return this.isNewAccount;
    }

    public void setNewAccount(boolean isNewAccount) {
        this.isNewAccount = isNewAccount;
    }
}

