/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.account;

import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import sernet.verinice.interfaces.IRightsService;
import sernet.verinice.model.common.configuration.Configuration;
import sernet.verinice.rcp.account.AccountWizard;
import sernet.verinice.rcp.account.BaseWizardPage;
import sernet.verinice.rcp.account.GroupPage;
import sernet.verinice.rcp.account.Messages;

public class LimitationPage
extends BaseWizardPage {
    private static final Logger LOG = Logger.getLogger(LimitationPage.class);
    public static final String PAGE_NAME = "account-wizard-limitation-page";
    private Configuration account;
    private boolean isAdmin = false;
    private boolean isLocalAdmin = false;
    private boolean isScopeOnly = false;
    private boolean isDesktop = true;
    private boolean isWeb = true;
    private boolean isDeactivated = false;
    private Button cbAdmin;
    private Button cbLocalAdmin;
    private Button cbScopeOnly;
    private Button cbDesktop;
    private Button cbWeb;
    private Button cbDeactivated;

    protected LimitationPage(Configuration account) {
        super(PAGE_NAME);
        this.account = account;
    }

    @Override
    protected void initGui(Composite composite) {
        this.setTitle(Messages.LimitationPage_1);
        this.setMessage(Messages.LimitationPage_2);
        this.cbAdmin = this.createCheckbox(composite, Messages.LimitationPage_3, this.isAdmin);
        this.cbAdmin.setEnabled(!AccountWizard.isCurrentUserLocalAdmin() && !this.isLocalAdmin);
        this.cbAdmin.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LimitationPage.this.isAdmin = LimitationPage.this.cbAdmin.getSelection();
                LimitationPage.this.cbLocalAdmin.setEnabled(!LimitationPage.this.isAdmin && !LimitationPage.this.isScopeOnly);
                LimitationPage.this.configureGroups();
            }
        });
        this.cbLocalAdmin = this.createCheckbox(composite, Messages.LimitationPage_8, this.isLocalAdmin);
        this.cbLocalAdmin.setEnabled(!this.isAdmin && !this.isScopeOnly);
        this.cbLocalAdmin.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LimitationPage.this.isLocalAdmin = LimitationPage.this.cbLocalAdmin.getSelection();
                LimitationPage.this.cbAdmin.setEnabled(!AccountWizard.isCurrentUserLocalAdmin() && !LimitationPage.this.isLocalAdmin);
                LimitationPage.this.cbScopeOnly.setEnabled(!LimitationPage.this.isLocalAdmin);
                LimitationPage.this.configureGroups();
            }
        });
        this.cbScopeOnly = this.createCheckbox(composite, Messages.LimitationPage_4, this.isScopeOnly);
        if (AccountWizard.isCurrentUserLocalAdmin()) {
            this.cbScopeOnly.setEnabled(!this.isAdmin && !this.isLocalAdmin);
        } else {
            this.cbScopeOnly.setEnabled(!this.isLocalAdmin);
        }
        this.cbScopeOnly.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LimitationPage.this.isScopeOnly = LimitationPage.this.cbScopeOnly.getSelection();
                LimitationPage.this.cbLocalAdmin.setEnabled(!LimitationPage.this.isAdmin && !LimitationPage.this.isScopeOnly);
                LimitationPage.this.configureGroups();
            }
        });
        this.cbDesktop = this.createCheckbox(composite, Messages.LimitationPage_5, this.isDesktop);
        this.cbDesktop.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LimitationPage.this.isDesktop = LimitationPage.this.cbDesktop.getSelection();
            }
        });
        this.cbWeb = this.createCheckbox(composite, Messages.LimitationPage_6, this.isWeb);
        this.cbWeb.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LimitationPage.this.isWeb = LimitationPage.this.cbWeb.getSelection();
            }
        });
        this.cbDeactivated = this.createCheckbox(composite, Messages.LimitationPage_7, this.isDeactivated);
        this.cbDeactivated.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LimitationPage.this.isDeactivated = LimitationPage.this.cbDeactivated.getSelection();
            }
        });
    }

    public void configureGroups() {
        if (!AccountWizard.isCurrentUserLocalAdmin()) {
            this.configureStandartGroup();
            this.changeGroupPage();
        }
    }

    private void changeGroupPage() {
        GroupPage groupPage = (GroupPage)this.getNextPage();
        Set standartGroupsOfAccount = this.account.getStandartGroups();
        groupPage.reSelectStandartGroups(standartGroupsOfAccount);
    }

    private void configureStandartGroup() {
        this.deleteStandartGroups();
        if (this.isAdmin()) {
            this.configureAdminGroup();
        } else if (this.isLocalAdmin()) {
            this.configureLocalAdminGroup();
        } else {
            this.configureUserGroup();
        }
    }

    private void configureAdminGroup() {
        if (this.isScopeOnly()) {
            this.account.addRole("admin-scope-default-group");
        } else {
            this.account.addRole("admin-default-group");
        }
    }

    private void configureLocalAdminGroup() {
        this.account.addRole("admin-local-default-group");
    }

    private void configureUserGroup() {
        if (this.isScopeOnly()) {
            this.account.addRole("user-scope-default-group");
        } else {
            this.account.addRole("user-default-group");
        }
    }

    private void deleteStandartGroups() {
        Set rolesInAccount = this.account.getRoles(false);
        for (String role : rolesInAccount) {
            if (!LimitationPage.isStandardGroup(role)) continue;
            this.account.deleteRole(role);
        }
    }

    private static boolean isStandardGroup(String role) {
        return ArrayUtils.contains((Object[])IRightsService.STANDARD_GROUPS, (Object)role);
    }

    @Override
    protected void initData() throws Exception {
    }

    public boolean isPageComplete() {
        boolean complete = true;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("page complete: " + complete));
        }
        return complete;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public void setAdmin(boolean isAdmin) {
        this.isAdmin = isAdmin;
    }

    public boolean isLocalAdmin() {
        return this.isLocalAdmin;
    }

    public void setLocalAdmin(boolean isLocalAdmin) {
        this.isLocalAdmin = isLocalAdmin;
    }

    public boolean isScopeOnly() {
        return this.isScopeOnly;
    }

    public void setScopeOnly(boolean isScopeOnly) {
        this.isScopeOnly = isScopeOnly;
    }

    public boolean isDesktop() {
        return this.isDesktop;
    }

    public void setDesktop(boolean isDesktop) {
        this.isDesktop = isDesktop;
    }

    public boolean isWeb() {
        return this.isWeb;
    }

    public boolean isDeactivated() {
        return this.isDeactivated;
    }

    public void setDeactivated(boolean isDeactivated) {
        this.isDeactivated = isDeactivated;
    }

    public void setWeb(boolean isWeb) {
        this.isWeb = isWeb;
    }
}

