/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.account;

import java.time.LocalDate;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.licensemanagement.ILicenseManagementService;
import sernet.verinice.model.common.configuration.Configuration;
import sernet.verinice.model.licensemanagement.LicenseManagementEntry;
import sernet.verinice.model.licensemanagement.LicenseManagementException;
import sernet.verinice.rcp.account.AccountWizard;
import sernet.verinice.rcp.account.BaseWizardPage;
import sernet.verinice.rcp.account.Messages;

public class LicenseMgmtPage
extends BaseWizardPage {
    private static final Logger LOG = Logger.getLogger(LicenseMgmtPage.class);
    private static final String BASIC_LICENSE_FORMAT = "%s - %s - (%s/%s)";
    public static final String PAGE_NAME = "account-wizard-license-mgmt-page";
    ILicenseManagementService licenseService = ServiceFactory.lookupLicenseManagementService();
    private String user;
    private Set<String> assignedLicenseIds;
    private Set<Button> checkboxes = new HashSet<Button>();
    private boolean sendEmail;
    private Configuration account;

    public LicenseMgmtPage(Configuration account) {
        super(PAGE_NAME);
        this.account = account;
    }

    @Override
    protected void initGui(Composite composite) {
        GridData containerGridData = new GridData();
        containerGridData.horizontalAlignment = 16384;
        containerGridData.verticalAlignment = 0x1000000;
        containerGridData.grabExcessHorizontalSpace = true;
        containerGridData.grabExcessVerticalSpace = true;
        composite.setLayoutData((Object)containerGridData);
        composite.setEnabled(!AccountWizard.isCurrentUserLocalAdmin());
        this.setTitle(Messages.LicenseMgmtPage_Title);
        this.setMessage(Messages.LicenseMgmtPage_Text);
        try {
            Set licenseList = this.licenseService.getExistingLicenses();
            List lEntries = licenseList.stream().map(this::createLicenseEntry).sorted((o1, o2) -> o1.toLicenseLabel(0).compareTo(o2.toLicenseLabel(0))).collect(Collectors.toList());
            lEntries.stream().forEach(le -> {
                le.index = lEntries.indexOf(le) + 1;
                this.createCheckbox(composite, (LicenseEntry)le);
            });
            if (lEntries.isEmpty()) {
                Label label = new Label(composite, 0);
                label.setText(Messages.LicenseMgmtPage_NoLicenseAvailable);
            }
            Composite emailComposite = new Composite(composite, 2048);
            GridData emailGridData = new GridData();
            emailGridData.horizontalAlignment = 16384;
            emailGridData.verticalAlignment = 1024;
            emailGridData.grabExcessHorizontalSpace = true;
            emailGridData.grabExcessVerticalSpace = true;
            emailComposite.setLayoutData((Object)emailGridData);
            Button sendEmailButton = new Button(emailComposite, 32);
            GridLayout gridLayout = new GridLayout(1, false);
            gridLayout.marginWidth = 5;
            gridLayout.marginHeight = 5;
            gridLayout.verticalSpacing = 0;
            gridLayout.horizontalSpacing = 0;
            emailComposite.setLayout((Layout)gridLayout);
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 16384;
            gridData.verticalAlignment = 1024;
            gridData.grabExcessHorizontalSpace = true;
            gridData.grabExcessVerticalSpace = true;
            sendEmailButton.setLayoutData((Object)gridData);
            sendEmailButton.setText(Messages.LicenseMgmtPage_Notification);
            sendEmailButton.setSelection(this.isSendEmail());
            sendEmailButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (e.getSource() instanceof Button) {
                        Button button = (Button)e.getSource();
                        LicenseMgmtPage.this.setSendEmail(button.getSelection());
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            sendEmailButton.setEnabled(!licenseList.isEmpty());
        }
        catch (LicenseManagementException e) {
            String msg = "Error getting vnl-License-Data";
            ExceptionUtil.log(e, msg);
            LOG.error((Object)msg, (Throwable)e);
        }
    }

    @Override
    protected void initData() throws Exception {
    }

    public boolean isPageComplete() {
        return true;
    }

    public void setAssignedLicenseIds(Set<String> assignedLicenseIds) {
        this.assignedLicenseIds = assignedLicenseIds;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public static String getLicenseLabelString(String licenseId) {
        String licenseIdDelimiter = "###";
        StringTokenizer tokenizer = new StringTokenizer(licenseId, "###");
        if (tokenizer.countTokens() != 3) {
            return licenseId;
        }
        String contentId = tokenizer.nextToken();
        String validUntil = tokenizer.nextToken();
        String validUsers = tokenizer.nextToken();
        String assignedUsers = String.valueOf(ServiceFactory.lookupLicenseManagementService().getLicenseIdAllocationCount(licenseId));
        return String.format(BASIC_LICENSE_FORMAT, contentId, validUntil, validUsers, assignedUsers);
    }

    public boolean isSendEmail() {
        return this.sendEmail;
    }

    public void setSendEmail(boolean sendEmail) {
        this.sendEmail = sendEmail;
    }

    public void setAccount(Configuration account) {
        this.account = account;
    }

    private void createCheckbox(Composite composite, final LicenseEntry licenseEntry) {
        final Button checkbox = new Button(composite, 32);
        this.checkboxes.add(checkbox);
        boolean isLicenseAssigned = this.assignedLicenseIds.contains(licenseEntry.plainLicenseId);
        final Integer uncheckOffset = isLicenseAssigned ? -1 : 0;
        final Integer checkOffset = isLicenseAssigned ? 0 : 1;
        checkbox.setSelection(isLicenseAssigned);
        checkbox.setEnabled(licenseEntry.currentUser < licenseEntry.validUser || isLicenseAssigned);
        checkbox.setText(licenseEntry.toLicenseLabel(0));
        checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (checkbox.getSelection()) {
                    LicenseMgmtPage.this.account.addLicensedContentId(licenseEntry.plainLicenseId);
                    LicenseMgmtPage.this.assignedLicenseIds.add(licenseEntry.plainLicenseId);
                    checkbox.setText(licenseEntry.toLicenseLabel(checkOffset));
                } else {
                    LicenseMgmtPage.this.account.removeLicensedContentId(licenseEntry.plainLicenseId);
                    LicenseMgmtPage.this.assignedLicenseIds.remove(licenseEntry.plainLicenseId);
                    checkbox.setText(licenseEntry.toLicenseLabel(uncheckOffset));
                }
            }
        });
    }

    private LicenseEntry createLicenseEntry(LicenseManagementEntry entry) {
        LicenseEntry dh = new LicenseEntry();
        dh.plainLicenseId = (String)this.licenseService.decrypt(entry, "licenseID");
        dh.contentId = (String)this.licenseService.decrypt(entry, "contentId");
        dh.validUntil = (LocalDate)this.licenseService.decrypt(entry, "validUntil");
        dh.validUser = (Integer)this.licenseService.decrypt(entry, "validUsers");
        dh.currentUser = this.licenseService.getLicenseIdAllocationCount(dh.plainLicenseId);
        dh.validMsg = dh.validUntil.isBefore(LocalDate.now()) ? Messages.LicenseMgmtPage_License_Expired : "";
        return dh;
    }

    private static class LicenseEntry {
        private static final String LICENSE_FORMAT = "%d. %s - %s - (%d/%d) %s";
        private Integer index;
        private Integer currentUser;
        private String plainLicenseId;
        private LocalDate validUntil;
        private Integer validUser;
        private String contentId;
        private String validMsg;

        private LicenseEntry() {
        }

        private String toLicenseLabel(Integer offset) {
            return String.format(LICENSE_FORMAT, this.index, this.contentId, this.validUntil, this.currentUser + offset, this.validUser, this.validMsg);
        }
    }
}

