/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.account;

import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.swt.widgets.Composite;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.IAccountService;
import sernet.verinice.model.common.accountgroup.AccountGroup;
import sernet.verinice.model.common.configuration.Configuration;
import sernet.verinice.rcp.account.AccountGroupMultiselectWidget;
import sernet.verinice.rcp.account.BaseWizardPage;
import sernet.verinice.rcp.account.Messages;

public class GroupPage
extends BaseWizardPage {
    private static final Logger LOG = Logger.getLogger(GroupPage.class);
    public static final String PAGE_NAME = "account-wizard-group-page";
    private Configuration account;
    private AccountGroupMultiselectWidget groupWidget;
    private IAccountService accountService;

    protected GroupPage() {
        super(PAGE_NAME);
    }

    protected GroupPage(Configuration account) {
        super(PAGE_NAME);
        this.account = account;
    }

    @Override
    protected void initGui(Composite composite) {
        this.setTitle(Messages.GroupPage_1);
        this.setMessage(Messages.GroupPage_2);
        this.groupWidget = new AccountGroupMultiselectWidget(composite, this.account);
    }

    @Override
    protected void initData() throws Exception {
    }

    public void syncCheckboxesToAccountGroups() {
        this.account.deleteAllRoles();
        for (AccountGroup accountGroup : this.getGroupsFromWidget()) {
            this.account.addRole(accountGroup.getName());
        }
    }

    public void reSelectStandartGroups(Set<String> standartGroupSet) {
        this.deselectStandartGroups();
        this.groupWidget.resetData();
    }

    private void deselectStandartGroups() {
        Set allStandartAccountGroups = AccountGroup.createStandartGroupSet();
        for (AccountGroup accountGroup : allStandartAccountGroups) {
            this.groupWidget.removeSelectedElements(accountGroup);
        }
    }

    public void selectStandartGroups(Set<String> standartGroupNames) {
        Set accountGroupSet = AccountGroup.createSetForNames(standartGroupNames);
        for (AccountGroup accountGroup : accountGroupSet) {
            this.groupWidget.selectCheckboxForElement(accountGroup);
        }
    }

    public boolean isPageComplete() {
        boolean complete = true;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("page complete: " + complete));
        }
        return complete;
    }

    public Set<AccountGroup> getGroupsFromWidget() {
        return this.groupWidget.getSelectedElementSet();
    }

    public void setAccount(Configuration account) {
        this.account = account;
        this.groupWidget.setAccount(account);
    }

    public IAccountService getAccountService() {
        if (this.accountService == null) {
            this.accountService = this.createAccountServive();
        }
        return this.accountService;
    }

    private IAccountService createAccountServive() {
        return ServiceFactory.lookupAccountService();
    }
}

