/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.account;

import org.apache.log4j.Logger;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.ICommandService;

public abstract class BaseWizardPage
extends WizardPage {
    private static final Logger LOG = Logger.getLogger(BaseWizardPage.class);
    private static final int MIN_WIDTH_TEXT = 100;
    private ICommandService commandService;

    public BaseWizardPage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        try {
            Composite composite = this.createEmptyComposite(parent);
            this.initGui(composite);
            composite.pack();
            this.initData();
            this.setControl((Control)composite);
            this.setPageComplete(false);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while opening person page.", (Throwable)e);
        }
    }

    protected abstract void initGui(Composite var1);

    protected abstract void initData() throws Exception;

    protected Composite createEmptyComposite(Composite parent) {
        int marginWidth = 10;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gd);
        return composite;
    }

    protected void createLabel(Composite composite, String labelText) {
        Label label = new Label(composite, 64);
        label.setText(labelText);
    }

    protected Text createTextfield(Composite composite) {
        return this.createText(composite, 2048);
    }

    protected Text createPasswordField(Composite composite) {
        return this.createText(composite, 0x400800);
    }

    protected Text createText(Composite composite, int style) {
        Text textfield = new Text(composite, style);
        textfield.setLayoutData((Object)this.getTextGridData());
        return textfield;
    }

    protected Button createCheckbox(Composite composite, String label) {
        return this.createCheckbox(composite, label, false);
    }

    protected Button createCheckbox(Composite composite, String label, boolean selected) {
        Button cb = new Button(composite, 32);
        cb.setText(label);
        cb.setSelection(selected);
        return cb;
    }

    protected GridData getTextGridData() {
        GridData gridData = new GridData(4, 0, true, false);
        gridData.minimumWidth = 100;
        return gridData;
    }

    protected void setText(Text text, String s) {
        if (s != null) {
            text.setText(s);
        }
    }

    protected ICommandService getCommandService() {
        if (this.commandService == null) {
            this.commandService = this.createCommandServive();
        }
        return this.commandService;
    }

    private ICommandService createCommandServive() {
        return ServiceFactory.lookupCommandService();
    }
}

