/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.account;

import org.apache.log4j.Logger;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import sernet.gs.service.StringUtil;
import sernet.verinice.rcp.account.AccountWizard;
import sernet.verinice.rcp.account.BaseWizardPage;
import sernet.verinice.rcp.account.Messages;

public class AuthenticationPage
extends BaseWizardPage {
    private static final Logger LOG = Logger.getLogger(AuthenticationPage.class);
    public static final String PAGE_NAME = "account-wizard-authentication-page";
    private String login;
    private String password;
    private String password2;
    private String email;
    private Text textLogin;
    private Text textPassword;
    private Text textPassword2;
    private Text textEmail;

    protected AuthenticationPage() {
        super(PAGE_NAME);
    }

    @Override
    protected void initGui(Composite composite) {
        this.setTitle(Messages.AuthenticationPage_1);
        this.setMessage(this.createMessage());
        this.createLabel(composite, Messages.AuthenticationPage_3);
        this.textLogin = this.createTextfield(composite);
        this.setText(this.textLogin, this.getLogin());
        this.textLogin.addModifyListener(e -> {
            this.login = StringUtil.replaceEmptyStringByNull((String)this.textLogin.getText());
            this.setPageComplete(this.isPageComplete());
        });
        if (this.isPasswordManagedInternally()) {
            this.createLabel(composite, Messages.AuthenticationPage_4);
            this.textPassword = this.createPasswordField(composite);
            this.textPassword.addModifyListener(e -> {
                this.password = StringUtil.replaceEmptyStringByNull((String)this.textPassword.getText());
                this.setPageComplete(this.isPageComplete());
            });
            this.createLabel(composite, Messages.AuthenticationPage_5);
            this.textPassword2 = this.createPasswordField(composite);
            this.textPassword2.addModifyListener(e -> {
                this.password2 = StringUtil.replaceEmptyStringByNull((String)this.textPassword2.getText());
                this.setPageComplete(this.isPageComplete());
            });
        }
        this.createLabel(composite, Messages.AuthenticationPage_6);
        this.textEmail = this.createTextfield(composite);
        this.setText(this.textEmail, this.getEmail());
        this.textEmail.addModifyListener(e -> {
            this.email = StringUtil.replaceEmptyStringByNull((String)this.textEmail.getText());
            this.setPageComplete(this.isPageComplete());
        });
    }

    private String createMessage() {
        if (this.isPasswordManagedInternally()) {
            return Messages.AuthenticationPage_2;
        }
        return Messages.AuthenticationPage_0;
    }

    @Override
    protected void initData() throws Exception {
    }

    public boolean isPageComplete() {
        boolean complete = this.getLogin() != null && this.isPassword() && this.getEmail() != null;
        boolean isPasswordValid = this.validatePassword();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("page complete: " + complete));
        }
        return complete && isPasswordValid;
    }

    private boolean isPasswordManagedInternally() {
        return AccountWizard.getAuthService().isHandlingPasswords();
    }

    private boolean isPassword() {
        return this.getPassword() != null && this.getPassword2() != null || this.getPassword() == null && this.getPassword2() == null;
    }

    private boolean validatePassword() {
        boolean valid = this.isPassword();
        if (valid && this.getPassword() != null) {
            valid = this.getPassword().equals(this.getPassword2());
            if (!valid) {
                this.setErrorMessage(Messages.AuthenticationPage_7);
            } else {
                this.setErrorMessage(null);
                this.setMessage(Messages.AuthenticationPage_8);
            }
        }
        return valid;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = StringUtil.replaceEmptyStringByNull((String)login);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = StringUtil.replaceEmptyStringByNull((String)password);
    }

    public String getPassword2() {
        return this.password2;
    }

    public void setPassword2(String password2) {
        this.password2 = StringUtil.replaceEmptyStringByNull((String)password2);
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = StringUtil.replaceEmptyStringByNull((String)email);
    }
}

