/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.account;

import org.apache.log4j.Logger;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import sernet.verinice.interfaces.bpm.KeyValue;
import sernet.verinice.iso27k.rcp.ComboModel;
import sernet.verinice.iso27k.rcp.IComboModelLabelProvider;
import sernet.verinice.rcp.TextEventAdapter;
import sernet.verinice.rcp.account.BaseWizardPage;
import sernet.verinice.rcp.account.Messages;

public class AuditorNotificationPage
extends BaseWizardPage {
    private static final Logger LOG = Logger.getLogger(AuditorNotificationPage.class);
    public static final String PAGE_NAME = "account-wizard-auditor-notification-page";
    private boolean isGlobal = false;
    private boolean isDeadlineWarning = false;
    private Integer deadlineInDays = 14;
    private Button cbDeadlineWarning;
    private Text textDeadlineInDays;
    private ComboModel<KeyValue> comboModelGlobal;
    private Combo comboGlobal;

    protected AuditorNotificationPage() {
        super(PAGE_NAME);
    }

    public AuditorNotificationPage(String pageName) {
        super(pageName);
    }

    @Override
    protected void initGui(Composite composite) {
        this.setTitle(Messages.AuditorNotificationPage_1);
        this.setMessage(Messages.AuditorNotificationPage_2);
        this.addAllControlsFields(composite, "configuration_auditmailing_owner_all", "configuration_auditmailing_owner_self");
        this.addDeadlineFields(composite);
    }

    @Override
    protected void initData() throws Exception {
    }

    protected void addAllControlsFields(Composite composite, final String keyYes, String keyNo) {
        this.createLabel(composite, Messages.AuditorNotificationPage_3);
        this.comboGlobal = new Combo(composite, 12);
        this.comboGlobal.setLayoutData((Object)new GridData(768));
        this.comboGlobal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AuditorNotificationPage.this.comboModelGlobal.setSelectedIndex(AuditorNotificationPage.this.comboGlobal.getSelectionIndex());
                KeyValue keyValue = AuditorNotificationPage.this.comboModelGlobal.getSelectedObject();
                if (keyValue != null) {
                    AuditorNotificationPage.this.isGlobal = keyValue.getKey().equals(keyYes);
                }
            }
        });
        this.comboModelGlobal = new ComboModel<KeyValue>(new IComboModelLabelProvider<KeyValue>(){

            @Override
            public String getLabel(KeyValue element) {
                return element.getValue();
            }
        });
        this.comboModelGlobal.add(new KeyValue(keyYes, Messages.AuditorNotificationPage_4));
        this.comboModelGlobal.add(new KeyValue(keyNo, Messages.AuditorNotificationPage_5));
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                AuditorNotificationPage.this.comboGlobal.setItems(AuditorNotificationPage.this.comboModelGlobal.getLabelArray());
                int i = AuditorNotificationPage.this.isGlobal() ? 0 : 1;
                AuditorNotificationPage.this.comboGlobal.select(i);
                AuditorNotificationPage.this.comboModelGlobal.setSelectedIndex(AuditorNotificationPage.this.comboGlobal.getSelectionIndex());
            }
        });
    }

    protected void addDeadlineFields(Composite composite) {
        this.cbDeadlineWarning = this.createCheckbox(composite, Messages.AuditorNotificationPage_6, this.isDeadlineWarning);
        this.cbDeadlineWarning.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AuditorNotificationPage.this.isDeadlineWarning = AuditorNotificationPage.this.cbDeadlineWarning.getSelection();
            }
        });
        final String label = Messages.AuditorNotificationPage_7;
        this.createLabel(composite, label);
        this.textDeadlineInDays = this.createTextfield(composite);
        this.textDeadlineInDays.setText(String.valueOf(this.getDeadlineInDays()));
        this.textDeadlineInDays.addKeyListener((KeyListener)new TextEventAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                try {
                    AuditorNotificationPage.this.deadlineInDays = Integer.parseInt(AuditorNotificationPage.this.textDeadlineInDays.getText());
                    AuditorNotificationPage.this.setErrorMessage(null);
                }
                catch (NumberFormatException ex) {
                    AuditorNotificationPage.this.setErrorMessage(NLS.bind((String)Messages.AuditorNotificationPage_0, (Object)label));
                    AuditorNotificationPage.this.textDeadlineInDays.setText("14");
                    AuditorNotificationPage.this.deadlineInDays = 14;
                }
            }
        });
    }

    public boolean isPageComplete() {
        boolean complete = true;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("page complete: " + complete));
        }
        return complete;
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public void setGlobal(boolean isGlobal) {
        this.isGlobal = isGlobal;
    }

    public boolean isDeadlineWarning() {
        return this.isDeadlineWarning;
    }

    public void setDeadlineWarning(boolean isDeadlineWarning) {
        this.isDeadlineWarning = isDeadlineWarning;
    }

    public Integer getDeadlineInDays() {
        return this.deadlineInDays;
    }

    public void setDeadlineInDays(Integer deadlineInDays) {
        this.deadlineInDays = deadlineInDays;
    }
}

