/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.account;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.IAuthService;
import sernet.verinice.model.common.configuration.Configuration;
import sernet.verinice.rcp.account.AuditorNotificationPage;
import sernet.verinice.rcp.account.AuthenticationPage;
import sernet.verinice.rcp.account.GroupPage;
import sernet.verinice.rcp.account.LicenseMgmtPage;
import sernet.verinice.rcp.account.LimitationPage;
import sernet.verinice.rcp.account.Messages;
import sernet.verinice.rcp.account.NotificationPage;
import sernet.verinice.rcp.account.PersonPage;
import sernet.verinice.rcp.account.ProfilePage;

public class AccountWizard
extends Wizard {
    private Configuration account;
    private PersonPage personPage;
    private AuthenticationPage authenticationPage;
    private LimitationPage limitationPage;
    private GroupPage groupPage;
    private NotificationPage notificationPage;
    private AuditorNotificationPage auditorNotificationPage;
    private LicenseMgmtPage licenseMgmtPage;

    public AccountWizard(Configuration account) {
        this.account = account;
        this.init();
    }

    private void init() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.AccountWizard_0);
        if (this.isNewAccount() && AccountWizard.isCurrentUserLocalAdmin() && this.account != null) {
            this.account.deleteAllRoles();
        }
    }

    public void addPages() {
        this.personPage = new PersonPage();
        this.addPage((IWizardPage)this.personPage);
        this.authenticationPage = new AuthenticationPage();
        this.addPage((IWizardPage)this.authenticationPage);
        this.limitationPage = new LimitationPage(this.account);
        this.addPage((IWizardPage)this.limitationPage);
        this.groupPage = new GroupPage(this.account);
        this.addPage((IWizardPage)this.groupPage);
        this.licenseMgmtPage = new LicenseMgmtPage(this.account);
        this.addPage((IWizardPage)this.licenseMgmtPage);
        this.notificationPage = new NotificationPage();
        this.addPage((IWizardPage)this.notificationPage);
        this.auditorNotificationPage = new AuditorNotificationPage();
        this.addPage((IWizardPage)this.auditorNotificationPage);
        ProfilePage profilePage = new ProfilePage();
        this.addPage((IWizardPage)profilePage);
        if (this.account != null) {
            this.personPage.setPerson(this.account.getPerson());
            this.personPage.setNewAccount(this.isNewAccount());
            this.authenticationPage.setLogin(this.account.getUser());
            this.authenticationPage.setEmail(this.account.getNotificationEmail());
            this.limitationPage.setAdmin(this.account.isAdminUser());
            this.limitationPage.setLocalAdmin(this.account.isLocalAdminUser());
            this.limitationPage.setScopeOnly(this.account.isScopeOnly());
            this.limitationPage.setWeb(this.account.isWebUser());
            this.limitationPage.setDesktop(this.account.isRcpUser());
            this.limitationPage.setDeactivated(this.account.isDeactivatedUser());
            this.licenseMgmtPage.setUser(this.account.getUser());
            this.licenseMgmtPage.setAssignedLicenseIds(this.account.getAssignedLicenseIds());
            this.licenseMgmtPage.setSendEmail(this.account.getNotificationLicense());
            this.notificationPage.setNotification(this.getAccount().isNotificationEnabled());
            this.notificationPage.setGlobal(this.getAccount().isNotificationGlobal());
            this.notificationPage.setModifyReminder(this.getAccount().isNotificationMeasureModification());
            this.notificationPage.setDeadlineWarning(this.getAccount().isNotificationExpirationEnabled());
            this.notificationPage.setDeadlineInDays(this.getAccount().getNotificationExpirationDays());
            this.auditorNotificationPage.setGlobal(this.getAccount().isAuditorNotificationGlobal());
            this.auditorNotificationPage.setDeadlineWarning(this.getAccount().isAuditorNotificationExpirationEnabled());
            this.auditorNotificationPage.setDeadlineInDays(this.getAccount().getAuditorNotificationExpirationDays());
            profilePage.setLogin(this.account.getUser());
        }
    }

    public boolean performFinish() {
        this.getAccount().setPerson(this.personPage.getPerson());
        this.getAccount().setUserNew(this.authenticationPage.getLogin());
        this.getAccount().setPassNew(this.authenticationPage.getPassword());
        this.getAccount().setNotificationEmail(this.authenticationPage.getEmail());
        this.getAccount().setAdminUser(this.limitationPage.isAdmin());
        this.getAccount().setLocalAdminUser(this.limitationPage.isLocalAdmin());
        this.getAccount().setScopeOnly(this.limitationPage.isScopeOnly());
        this.getAccount().setWebUser(this.limitationPage.isWeb());
        this.getAccount().setRcpUser(this.limitationPage.isDesktop());
        this.getAccount().setIsDeactivatedUser(this.limitationPage.isDeactivated());
        this.groupPage.syncCheckboxesToAccountGroups();
        this.getAccount().setNotificationEnabled(this.notificationPage.isNotification());
        this.getAccount().setNotificationGlobal(this.notificationPage.isGlobal());
        this.getAccount().setNotificationMeasureModification(this.notificationPage.isModifyReminder());
        this.getAccount().setNotificationExpirationEnabled(this.notificationPage.isDeadlineWarning());
        this.getAccount().setNotificationExpirationDays(this.notificationPage.getDeadlineInDays().intValue());
        this.getAccount().setAuditorNotificationGlobal(this.auditorNotificationPage.isGlobal());
        this.getAccount().setAuditorNotificationExpirationEnabled(this.auditorNotificationPage.isDeadlineWarning());
        this.getAccount().setAuditorNotificationExpirationDays(this.auditorNotificationPage.getDeadlineInDays().intValue());
        this.getAccount().setNotificationLicense(this.licenseMgmtPage.isSendEmail());
        return true;
    }

    public IWizardPage getStartingPage() {
        Object startingPage = super.getStartingPage();
        if (!this.isNewAccount()) {
            startingPage = this.authenticationPage;
        }
        return startingPage;
    }

    private boolean isNewAccount() {
        boolean isNew = true;
        if (this.account != null) {
            isNew = this.account.getDbId() == null;
        }
        return isNew;
    }

    public static boolean isCurrentUserLocalAdmin() {
        return AccountWizard.getAuthService().currentUserHasRole(new String[]{"ROLE_LOCAL_ADMIN"});
    }

    public static IAuthService getAuthService() {
        return ServiceFactory.lookupAuthService();
    }

    public Configuration getAccount() {
        return this.account;
    }

    public void setAccount(Configuration account) {
        this.account = account;
    }
}

