/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.account;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.gs.ui.rcp.main.actions.ConfigurationAction;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.common.model.DefaultModelLoadListener;
import sernet.gs.ui.rcp.main.common.model.IModelLoadListener;
import sernet.gs.ui.rcp.main.common.model.PlaceHolder;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.hui.common.VeriniceContext;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.IAccountSearchParameter;
import sernet.verinice.interfaces.IAccountService;
import sernet.verinice.interfaces.IAuthService;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.ICommandService;
import sernet.verinice.interfaces.licensemanagement.ILicenseManagementService;
import sernet.verinice.iso27k.rcp.ComboModel;
import sernet.verinice.iso27k.rcp.JobScheduler;
import sernet.verinice.model.bp.IBpModelListener;
import sernet.verinice.model.bp.elements.BpModel;
import sernet.verinice.model.bsi.BSIModel;
import sernet.verinice.model.bsi.IBSIModelListener;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.common.NullListener;
import sernet.verinice.model.common.configuration.Configuration;
import sernet.verinice.model.iso27k.IISO27KModelListener;
import sernet.verinice.model.iso27k.ISO27KModel;
import sernet.verinice.model.licensemanagement.LicenseManagementException;
import sernet.verinice.model.licensemanagement.LicenseMessageInfos;
import sernet.verinice.rcp.RightsEnabledView;
import sernet.verinice.rcp.account.AccountContentProvider;
import sernet.verinice.rcp.account.AccountLabelProvider;
import sernet.verinice.rcp.account.AccountSortSelectionAdapter;
import sernet.verinice.rcp.account.AccountTableComparator;
import sernet.verinice.rcp.account.LicenseMgmtPage;
import sernet.verinice.rcp.account.Messages;
import sernet.verinice.service.account.AccountLoader;
import sernet.verinice.service.account.AccountSearchParameter;
import sernet.verinice.service.commands.LoadCnAElementByEntityTypeId;

public class AccountView
extends RightsEnabledView {
    private static final Logger LOG = Logger.getLogger(AccountView.class);
    public static final String ID = "sernet.verinice.rcp.account.AccountView";
    private static final int COMBO_INDEX_BOTH = 0;
    private static final int COMBO_INDEX_YES = 1;
    private static final int COMBO_INDEX_NO = 2;
    private static final int TEXT_COLUMN_WIDTH = 150;
    private static final int BOOLEAN_COLUMN_WIDTH = 70;
    private static final int MIN_WIDTH_TEXT = 100;
    private static final int MAX_LMCOLUMN_HEADER_LENGTH = 8;
    private static final String LMCOLUM_HEADER_EXTENSION = "...";
    private IAccountSearchParameter parameter = new AccountSearchParameter();
    private Action searchAction;
    private ConfigurationAction editAction;
    private Action runEditAction;
    private Action removeAction;
    private Action createAction;
    private IModelLoadListener modelLoadListener;
    private IModelLoadListener modelLoadListener2;
    private IAccountService accountService;
    private ICommandService commandService;
    private Text textLogin;
    private Text textFirstName;
    private Text textFamilyName;
    private ComboModel<CnATreeElement> comboModel;
    private Combo comboOrganization;
    private Combo comboAdmin;
    private Combo comboLocalAdmin;
    private Combo comboScopeOnly;
    private TableViewer viewer;
    private AccountTableComparator tableSorter = new AccountTableComparator();
    private AccountContentProvider contentProvider = new AccountContentProvider();
    private ISelectionListener selectionListener;
    private Map<String, Integer> columnIndexesByLicenseId;
    private ModelChangeListener modelChangeListener;

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        if (Activator.getDefault().isStandalone()) {
            return;
        }
        try {
            this.initView(parent);
            this.hookPageSelection();
            this.registerModelLoadListener();
        }
        catch (Exception e) {
            LOG.error((Object)"Error while creating control", (Throwable)e);
            ExceptionUtil.log(e, Messages.AccountView_2);
        }
    }

    private void registerModelLoadListener() {
        this.modelChangeListener = new ModelChangeListener();
        this.modelLoadListener2 = new DefaultModelLoadListener(){

            @Override
            public void loaded(ISO27KModel model) {
                model.addISO27KModelListener((IISO27KModelListener)AccountView.this.modelChangeListener);
            }

            @Override
            public void loaded(BpModel model) {
                model.addModITBOModelListener((IBpModelListener)AccountView.this.modelChangeListener);
            }

            @Override
            public void loaded(BSIModel model) {
                model.addBSIModelListener((IBSIModelListener)AccountView.this.modelChangeListener);
            }
        };
        CnAElementFactory.getInstance().addLoadListener(this.modelLoadListener2);
    }

    private void initView(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.createComposite(parent);
        this.comboModel = new ComboModel<CnATreeElement>(CnATreeElement::getTitle);
        this.makeActions();
        this.fillLocalToolBar();
        this.startInitDataJob();
    }

    private void createComposite(Composite parent) {
        Composite composite = this.createContainerComposite(parent);
        Composite searchComposite = this.createSearchComposite(composite);
        this.createSearchForm(searchComposite);
        Composite tableComposite = this.createTableComposite(composite);
        this.createTable(tableComposite);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.viewer.setInput((Object)new PlaceHolder(Messages.AccountView_3));
    }

    private Composite createContainerComposite(Composite parent) {
        Composite composite = new Composite(parent, 4);
        composite.setLayout((Layout)new GridLayout());
        return composite;
    }

    private Composite createSearchComposite(Composite composite) {
        Composite comboComposite = new Composite(composite, 0);
        GridData gridData = new GridData(4, 0, true, false);
        comboComposite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(7, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        comboComposite.setLayout((Layout)gridLayout);
        return comboComposite;
    }

    private Composite createTableComposite(Composite composite) {
        Composite tableComposite = new Composite(composite, 0);
        GridData gridData = new GridData(4, 4, true, true);
        tableComposite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        tableComposite.setLayout((Layout)gridLayout);
        return tableComposite;
    }

    private void createSearchForm(Composite searchComposite) {
        this.addLabels(searchComposite);
        this.textLogin = this.addLoginSearchField(searchComposite);
        this.textFirstName = this.addFirstNameSearchField(searchComposite);
        this.textFamilyName = this.addFamilyNameSearchField(searchComposite);
        this.comboOrganization = this.addOrganizationSearchField(searchComposite);
        this.comboAdmin = this.addAdminSearchField(searchComposite);
        this.comboLocalAdmin = this.addLocalAdminSearchField(searchComposite);
        this.comboScopeOnly = this.addScopeOnlySearchField(searchComposite);
        Button searchButton = new Button(searchComposite, 8);
        searchButton.setText(Messages.AccountView_10);
        searchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AccountView.this.findAccounts();
            }
        });
    }

    private Combo addScopeOnlySearchField(Composite searchComposite) {
        final Combo combo = new Combo(searchComposite, 12);
        combo.setLayoutData((Object)new GridData(768));
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (1 == combo.getSelectionIndex()) {
                    AccountView.this.parameter.setIsScopeOnly(Boolean.valueOf(true));
                }
                if (2 == combo.getSelectionIndex()) {
                    AccountView.this.parameter.setIsScopeOnly(Boolean.valueOf(false));
                }
                if (combo.getSelectionIndex() == 0) {
                    AccountView.this.parameter.setIsScopeOnly(null);
                }
                AccountView.this.findAccounts();
            }
        });
        AccountView.initYesNoCombo(combo);
        return combo;
    }

    private Combo addLocalAdminSearchField(Composite searchComposite) {
        final Combo combo = new Combo(searchComposite, 12);
        combo.setLayoutData((Object)new GridData(768));
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (1 == combo.getSelectionIndex()) {
                    AccountView.this.parameter.setIsLocalAdmin(Boolean.valueOf(true));
                }
                if (2 == combo.getSelectionIndex()) {
                    AccountView.this.parameter.setIsLocalAdmin(Boolean.valueOf(false));
                }
                if (combo.getSelectionIndex() == 0) {
                    AccountView.this.parameter.setIsLocalAdmin(null);
                }
                AccountView.this.findAccounts();
            }
        });
        AccountView.initYesNoCombo(combo);
        return combo;
    }

    private Combo addAdminSearchField(Composite searchComposite) {
        final Combo combo = new Combo(searchComposite, 12);
        combo.setLayoutData((Object)new GridData(768));
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (1 == combo.getSelectionIndex()) {
                    AccountView.this.parameter.setIsAdmin(Boolean.valueOf(true));
                }
                if (2 == combo.getSelectionIndex()) {
                    AccountView.this.parameter.setIsAdmin(Boolean.valueOf(false));
                }
                if (combo.getSelectionIndex() == 0) {
                    AccountView.this.parameter.setIsAdmin(null);
                }
                AccountView.this.findAccounts();
            }
        });
        AccountView.initYesNoCombo(combo);
        return combo;
    }

    private Combo addOrganizationSearchField(Composite searchComposite) {
        final Combo combo = new Combo(searchComposite, 12);
        combo.setLayoutData((Object)new GridData(768));
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AccountView.this.comboModel.setSelectedIndex(combo.getSelectionIndex());
                Integer dbId = null;
                CnATreeElement scope = AccountView.this.comboModel.getSelectedObject();
                if (scope != null) {
                    dbId = scope.getDbId();
                }
                AccountView.this.parameter.setScopeId(dbId);
                AccountView.this.findAccounts();
            }
        });
        return combo;
    }

    private Text addFamilyNameSearchField(Composite searchComposite) {
        final Text text = new Text(searchComposite, 2048);
        GridData gridData = new GridData(4, 0, true, false);
        gridData.minimumWidth = 100;
        text.setLayoutData((Object)gridData);
        text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                AccountView.this.parameter.setFamilyName(AccountView.this.getInput(text));
                AccountView.this.findAccounts();
            }
        });
        return text;
    }

    private Text addFirstNameSearchField(Composite searchComposite) {
        final Text text = new Text(searchComposite, 2048);
        GridData gridData = new GridData(4, 0, true, false);
        gridData.minimumWidth = 100;
        text.setLayoutData((Object)gridData);
        text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                AccountView.this.parameter.setFirstName(AccountView.this.getInput(text));
                AccountView.this.findAccounts();
            }
        });
        return text;
    }

    private Text addLoginSearchField(Composite searchComposite) {
        final Text text = new Text(searchComposite, 2048);
        GridData gridData = new GridData(4, 0, true, false);
        gridData.minimumWidth = 100;
        text.setLayoutData((Object)gridData);
        text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                AccountView.this.parameter.setLogin(AccountView.this.getInput(text));
                AccountView.this.findAccounts();
            }
        });
        return text;
    }

    private void addLabels(Composite searchComposite) {
        Label label = new Label(searchComposite, 64);
        label.setText(Messages.AccountView_4);
        label = new Label(searchComposite, 64);
        label.setText(Messages.AccountView_5);
        label = new Label(searchComposite, 64);
        label.setText(Messages.AccountView_6);
        label = new Label(searchComposite, 64);
        label.setText(Messages.AccountView_7);
        label = new Label(searchComposite, 64);
        label.setText(Messages.AccountView_8);
        label = new Label(searchComposite, 64);
        label.setText(Messages.AccountView_39);
        label = new Label(searchComposite, 64);
        label.setText(Messages.AccountView_9);
    }

    private void createTable(Composite tableComposite) {
        this.viewer = new TableViewer(tableComposite, 66306);
        GridData gd = new GridData(4, 4, true, true);
        this.viewer.getControl().setLayoutData((Object)gd);
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        HashMap<Integer, LicenseMessageInfos> lmColumnsMap = new HashMap<Integer, LicenseMessageInfos>();
        this.viewer.setLabelProvider((IBaseLabelProvider)new AccountLabelProvider(lmColumnsMap, Stream.of(AccountView.getAuthService().getRoles()).collect(Collectors.toSet())));
        Table table = this.viewer.getTable();
        int columnIndex = 0;
        this.createTableColumn(Messages.AccountView_12, 150, columnIndex++, "");
        this.createTableColumn(Messages.AccountView_13, 150, columnIndex++, "");
        this.createTableColumn(Messages.AccountView_14, 150, columnIndex++, "");
        this.createTableColumn(Messages.AccountView_15, 150, columnIndex++, "");
        this.createTableColumn(Messages.AccountView_16, 150, columnIndex++, "");
        this.createTableColumn(Messages.AccountView_17, 70, columnIndex++, "");
        this.createTableColumn(Messages.AccountView_38, 70, columnIndex++, "");
        this.createTableColumn(Messages.AccountView_18, 70, columnIndex++, "");
        this.createTableColumn(Messages.AccountView_19, 70, columnIndex++, "");
        this.createTableColumn(Messages.AccountView_20, 70, columnIndex++, "");
        this.createTableColumn(Messages.AccountView_21, 70, columnIndex++, "");
        try {
            this.columnIndexesByLicenseId = this.creatLMColumns(lmColumnsMap, columnIndex);
        }
        catch (LicenseManagementException e) {
            String msg = "Error creating license-mgmt-Colums";
            ExceptionUtil.log(e, msg);
            LOG.error((Object)msg, (Throwable)e);
        }
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer.setComparator((ViewerComparator)this.tableSorter);
        ((AccountTableComparator)this.viewer.getComparator()).setColumn(2);
    }

    private Map<String, Integer> creatLMColumns(Map<Integer, LicenseMessageInfos> lmColumnsMap, int columnIndex) throws LicenseManagementException {
        ArrayList licenseInfos = new ArrayList();
        licenseInfos.addAll(this.getLMService().getAllLicenseMessageInfos());
        Collections.sort(licenseInfos, (infos0, infos1) -> infos0.getContentId().compareToIgnoreCase(infos1.getContentId()));
        HashMap<String, Integer> columnIndexesByLicenseId = new HashMap<String, Integer>(licenseInfos.size());
        int index = 0;
        while (index < licenseInfos.size()) {
            LicenseMessageInfos infos = (LicenseMessageInfos)licenseInfos.get(index);
            if (infos != null) {
                infos.setAccountWizardLabel(LicenseMgmtPage.getLicenseLabelString(infos.getLicenseId()));
                infos.setAccountViewColumnHeader(this.getLMColumnHeader(infos.getContentId(), index + 1));
                lmColumnsMap.put(columnIndex, infos);
                columnIndexesByLicenseId.put(infos.getLicenseId(), columnIndex);
                this.createTableColumn(infos.getAccountViewColumnHeader(), 70, columnIndex++, infos.getAccountWizardLabel());
            }
            ++index;
        }
        return columnIndexesByLicenseId;
    }

    private String getLMColumnHeader(String contentId, int index) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(index));
        sb.append(". ");
        if (contentId.length() >= 8) {
            sb.append(contentId.substring(0, 8));
            sb.append(LMCOLUM_HEADER_EXTENSION);
        } else {
            sb.append(contentId);
        }
        return sb.toString();
    }

    private void createTableColumn(String title, int width, int index, String tooltip) {
        TableColumn column = new TableColumn(this.viewer.getTable(), 16384);
        column.setText(title);
        column.setWidth(width);
        if (StringUtils.isEmpty((String)tooltip)) {
            column.setToolTipText(title);
        } else {
            column.setToolTipText(tooltip);
        }
        column.addSelectionListener((SelectionListener)new AccountSortSelectionAdapter(this, column, index));
    }

    private void makeActions() {
        this.makeEditAction();
        this.makeSearchAction();
        this.makeRunEditAction();
        this.makeRemoveAction();
        this.makeCreateAction();
        this.getViewer().addDoubleClickListener(event -> {
            Configuration account = (Configuration)((IStructuredSelection)event.getSelection()).getFirstElement();
            if (AccountLoader.isEditAllowed((Configuration)account)) {
                this.runEditAction.run();
            }
        });
        this.textLogin.addKeyListener((KeyListener)new EnterKeylistener(this.textLogin, "login", this.searchAction));
        this.textFirstName.addKeyListener((KeyListener)new EnterKeylistener(this.textFirstName, "firstName", this.searchAction));
        this.textFamilyName.addKeyListener((KeyListener)new EnterKeylistener(this.textFamilyName, "familyName", this.searchAction));
    }

    private void makeCreateAction() {
        this.createAction = new Action(){

            public void run() {
                Configuration account = Configuration.createDefaultAccount();
                AccountView.this.editAction.setConfiguration(account);
                AccountView.this.editAction.run();
                AccountView.this.findAccounts();
            }
        };
        this.createAction.setText("New...");
        this.createAction.setToolTipText("New Account...");
        this.createAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("user_add.png"));
    }

    private void makeRemoveAction() {
        this.removeAction = new Action(){

            public void run() {
                if (AccountView.this.getViewer().getSelection() instanceof IStructuredSelection && ((IStructuredSelection)AccountView.this.getViewer().getSelection()).getFirstElement() instanceof Configuration) {
                    try {
                        Configuration account = (Configuration)((IStructuredSelection)AccountView.this.getViewer().getSelection()).getFirstElement();
                        if (AccountLoader.isEditAllowed((Configuration)account)) {
                            AccountView.this.deactivateAccount(account);
                            AccountView.this.findAccounts();
                        }
                    }
                    catch (Exception t) {
                        LOG.error((Object)"Error while opening control.", (Throwable)t);
                    }
                }
            }
        };
        this.removeAction.setText(Messages.AccountView_30);
        this.removeAction.setToolTipText(Messages.AccountView_31);
        this.removeAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("user_disabled.png"));
        this.removeAction.setEnabled(false);
    }

    private void makeRunEditAction() {
        this.runEditAction = new Action(){

            public void run() {
                if (AccountView.this.getViewer().getSelection() instanceof IStructuredSelection && ((IStructuredSelection)AccountView.this.getViewer().getSelection()).getFirstElement() instanceof Configuration) {
                    try {
                        Configuration account = (Configuration)((IStructuredSelection)AccountView.this.getViewer().getSelection()).getFirstElement();
                        if (AccountLoader.isEditAllowed((Configuration)account)) {
                            account = AccountView.this.getAccountService().getAccountById(account.getDbId());
                            AccountView.this.editAction.setConfiguration(account);
                            AccountView.this.editAction.run();
                            AccountView.this.findAccounts();
                        }
                    }
                    catch (Exception t) {
                        LOG.error((Object)"Error while opening control.", (Throwable)t);
                    }
                }
            }
        };
        this.runEditAction.setText(Messages.AccountView_28);
        this.runEditAction.setToolTipText(Messages.AccountView_29);
        this.runEditAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("edit.png"));
        this.runEditAction.setEnabled(false);
    }

    private void makeSearchAction() {
        this.searchAction = new Action(){

            public void run() {
                AccountView.this.findAccounts();
            }
        };
        this.searchAction.setText(Messages.AccountView_26);
        this.searchAction.setToolTipText(Messages.AccountView_27);
        this.searchAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("search.png"));
    }

    private void makeEditAction() {
        this.editAction = new ConfigurationAction();
        this.editAction.setText(Messages.AccountView_23);
        this.editAction.setToolTipText(Messages.AccountView_24);
        this.editAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("edit.png"));
    }

    private void hookPageSelection() {
        this.selectionListener = (part, selection) -> this.pageSelectionChanged(selection);
        this.getSite().getPage().addPostSelectionListener(this.selectionListener);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
    }

    protected void pageSelectionChanged(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        if (((IStructuredSelection)selection).size() != 1) {
            this.runEditAction.setEnabled(false);
            this.removeAction.setEnabled(false);
            return;
        }
        Object element = ((IStructuredSelection)selection).getFirstElement();
        if (element instanceof Configuration && AccountLoader.isEditAllowed((Configuration)((Configuration)element))) {
            this.runEditAction.setEnabled(true);
            this.removeAction.setEnabled(true);
        } else {
            this.runEditAction.setEnabled(false);
            this.removeAction.setEnabled(false);
        }
    }

    protected void findAccounts() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"findAccounts called...");
        }
        List accountList = this.getAccountService().findAccounts(this.parameter);
        AccountView.getDisplay().syncExec(() -> {
            this.viewer.setInput((Object)accountList);
            this.columnIndexesByLicenseId.forEach((licenseId, columnIndex) -> {
                String newTooltip = LicenseMgmtPage.getLicenseLabelString(licenseId);
                this.viewer.getTable().getColumn(columnIndex.intValue()).setToolTipText(newTooltip);
            });
            Stream.of(this.viewer.getTable().getColumns()).forEach(TableColumn::pack);
        });
    }

    protected void deactivateAccount(Configuration account) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"removeAccount called...");
        }
        if (MessageDialog.openQuestion((Shell)AccountView.getDisplay().getActiveShell(), (String)Messages.AccountView_32, (String)NLS.bind((String)Messages.AccountView_33, (Object)account.getUser()))) {
            this.getAccountService().deactivate(account);
        }
    }

    private List<CnATreeElement> loadEntitiesByTypeId(String typeId) throws CommandException {
        LoadCnAElementByEntityTypeId command = new LoadCnAElementByEntityTypeId(typeId);
        return ((LoadCnAElementByEntityTypeId)this.getCommandService().executeCommand((ICommand)command)).getElements();
    }

    private void loadScopes() throws CommandException {
        this.comboModel.clear();
        this.comboModel.addAll(this.loadEntitiesByTypeId("org"));
        this.comboModel.addAll(this.loadEntitiesByTypeId("it-verbund"));
        this.comboModel.addAll(this.loadEntitiesByTypeId("bp_itnetwork"));
        this.comboModel.sort();
        this.comboModel.addNoSelectionObject(Messages.AccountView_34);
        AccountView.getDisplay().syncExec(() -> {
            this.comboOrganization.setItems(this.comboModel.getLabelArray());
            this.comboOrganization.select(0);
            this.comboModel.setSelectedIndex(this.comboOrganization.getSelectionIndex());
        });
    }

    protected void startInitDataJob() {
        WorkspaceJob initDataJob = new WorkspaceJob(Messages.AccountView_0){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                IStatus status = Status.OK_STATUS;
                try {
                    try {
                        monitor.beginTask(Messages.AccountView_0, -1);
                        Activator.inheritVeriniceContextState();
                        AccountView.this.findAccounts();
                        AccountView.this.loadScopes();
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Error while loading data.", (Throwable)e);
                        status = new Status(4, "sernet.gs.ui.rcp.main", "Error while loading data.", (Throwable)e);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
                return status;
            }
        };
        if (CnAElementFactory.isIsoModelLoaded()) {
            JobScheduler.scheduleInitJob(initDataJob);
        } else if (this.modelLoadListener == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"No model loaded, adding model load listener.");
            }
            this.createModelLoadListener(initDataJob);
        }
    }

    private static void initYesNoCombo(Combo combo) {
        combo.add(Messages.AccountView_35, 0);
        combo.add(Messages.AccountView_36, 1);
        combo.add(Messages.AccountView_37, 2);
        combo.select(0);
    }

    private void createModelLoadListener(final WorkspaceJob initDataJob) {
        this.modelLoadListener = new DefaultModelLoadListener(){

            @Override
            public void loaded(ISO27KModel model) {
                JobScheduler.scheduleInitJob(initDataJob);
                CnAElementFactory.getInstance().removeLoadListener(AccountView.this.modelLoadListener);
            }
        };
        CnAElementFactory.getInstance().addLoadListener(this.modelLoadListener);
    }

    @Override
    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private String getInput(Text textFirstName) {
        String input = textFirstName.getText();
        if (input != null && (input = input.trim()).isEmpty()) {
            input = null;
        }
        return input;
    }

    private void fillLocalToolBar() {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager manager = bars.getToolBarManager();
        manager.add((IAction)this.createAction);
        manager.add((IAction)this.removeAction);
        manager.add((IAction)this.runEditAction);
        manager.add((IAction)this.searchAction);
    }

    private static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    @Override
    public String getRightID() {
        return "accountsettings";
    }

    @Override
    public String getViewId() {
        return ID;
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    public AccountTableComparator getTableSorter() {
        return this.tableSorter;
    }

    public void setTableSorter(AccountTableComparator tableSorter) {
        this.tableSorter = tableSorter;
    }

    public ICommandService getCommandService() {
        if (this.commandService == null) {
            this.commandService = this.createCommandServive();
        }
        return this.commandService;
    }

    private ICommandService createCommandServive() {
        return ServiceFactory.lookupCommandService();
    }

    public IAccountService getAccountService() {
        if (this.accountService == null) {
            this.accountService = this.createAccountServive();
        }
        return this.accountService;
    }

    private IAccountService createAccountServive() {
        return ServiceFactory.lookupAccountService();
    }

    private static IAuthService getAuthService() {
        return (IAuthService)VeriniceContext.get((String)"authService");
    }

    public void dispose() {
        CnAElementFactory.getInstance().removeLoadListener(this.modelLoadListener);
        CnAElementFactory.getInstance().removeLoadListener(this.modelLoadListener2);
        this.getSite().getPage().removePostSelectionListener(this.selectionListener);
        if (CnAElementFactory.isModelLoaded()) {
            CnAElementFactory.getLoadedModel().removeBSIModelListener((IBSIModelListener)this.modelChangeListener);
        }
        if (CnAElementFactory.isIsoModelLoaded()) {
            CnAElementFactory.getInstance().getISO27kModel().removeISO27KModelListener((IISO27KModelListener)this.modelChangeListener);
        }
        if (CnAElementFactory.isBpModelLoaded()) {
            CnAElementFactory.getInstance().getBpModel().removeBpModelListener((IBpModelListener)this.modelChangeListener);
        }
        super.dispose();
    }

    private ILicenseManagementService getLMService() {
        return ServiceFactory.lookupLicenseManagementService();
    }

    class EnterKeylistener
    implements KeyListener {
        private Text textField;
        private Action enterAction;
        private String parameter;

        public EnterKeylistener(Text textField, String parameter, Action enterAction) {
            this.textField = textField;
            this.enterAction = enterAction;
            this.parameter = parameter;
        }

        public void keyReleased(KeyEvent e) {
            AccountView.this.parameter.setParameter(this.parameter, (Object)this.getInput(this.textField));
        }

        public void keyPressed(KeyEvent e) {
            if ('\r' == e.character) {
                AccountView.this.parameter.setParameter(this.parameter, (Object)this.getInput(this.textField));
                this.enterAction.run();
            }
        }

        private String getInput(Text textFirstName) {
            String input = textFirstName.getText();
            if (input != null && (input = input.trim()).isEmpty()) {
                input = null;
            }
            return input;
        }
    }

    private final class ModelChangeListener
    extends NullListener
    implements IBSIModelListener,
    IISO27KModelListener,
    IBpModelListener {
        private ModelChangeListener() {
        }

        public void childChanged(CnATreeElement child) {
            this.refreshViewer();
        }

        public void modelReload(BSIModel newModel) {
            this.refreshViewer();
        }

        public void modelReload(BpModel newModel) {
            this.refreshViewer();
        }

        public void modelReload(ISO27KModel newModel) {
            this.refreshViewer();
        }

        private void refreshViewer() {
            AccountView.this.startInitDataJob();
        }
    }
}

