/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.account;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import sernet.gs.service.NumericStringComparator;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.common.configuration.Configuration;
import sernet.verinice.rcp.ElementTitleCache;
import sernet.verinice.rcp.account.GenericPerson;

class AccountTableComparator
extends ViewerComparator {
    private int propertyIndex = 0;
    private static final int DEFAULT_SORT_COLUMN = 0;
    private static final int DESCENDING = 1;
    private static final int ASCENDING = 0;
    private int direction = 0;
    private static final NumericStringComparator nsc = new NumericStringComparator();

    public void setColumn(int column) {
        if (column == this.propertyIndex) {
            this.direction = this.direction == 0 ? 1 : 0;
        } else {
            this.propertyIndex = column;
            this.direction = 0;
        }
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int rc = 0;
        if (e1 == null && e2 != null) {
            rc = 1;
        } else if (e2 == null && e1 != null) {
            rc = -1;
        } else {
            Configuration a1 = (Configuration)e1;
            Configuration a2 = (Configuration)e2;
            rc = this.compareNullSafe(a1, a2);
        }
        if (this.direction == 1) {
            rc = -rc;
        }
        return rc;
    }

    private int compareNullSafe(Configuration a1, Configuration a2) {
        int rc = 0;
        CnATreeElement p1 = a1.getPerson();
        CnATreeElement p2 = a2.getPerson();
        PersonAdapter adapter = new PersonAdapter(p1, p2);
        switch (this.propertyIndex) {
            case 0: {
                rc = this.compareTitle(p1, p2);
                break;
            }
            case 1: {
                rc = adapter.compareParentName();
                break;
            }
            case 2: {
                rc = nsc.compare((Object)a1.getUser().toLowerCase(), (Object)a2.getUser().toLowerCase());
                break;
            }
            case 3: {
                rc = adapter.compareName();
                break;
            }
            case 4: {
                rc = nsc.compare((Object)a1.getEmail().toLowerCase(), (Object)a2.getEmail().toLowerCase());
                break;
            }
            case 5: {
                rc = Boolean.valueOf(a1.isAdminUser()).compareTo(a2.isAdminUser());
                break;
            }
            case 6: {
                rc = Boolean.valueOf(a1.isScopeOnly()).compareTo(a2.isScopeOnly());
                break;
            }
            case 7: {
                rc = Boolean.valueOf(a1.isWebUser()).compareTo(a2.isWebUser());
                break;
            }
            case 8: {
                rc = Boolean.valueOf(a1.isRcpUser()).compareTo(a2.isRcpUser());
                break;
            }
            case 9: {
                rc = Boolean.valueOf(a1.isDeactivatedUser()).compareTo(a2.isDeactivatedUser());
                break;
            }
            default: {
                rc = 0;
            }
        }
        return rc;
    }

    private int compareTitle(CnATreeElement p1, CnATreeElement p2) {
        int rc = 0;
        String title1 = ElementTitleCache.getInstance().get(p1.getScopeId());
        String title2 = ElementTitleCache.getInstance().get(p2.getScopeId());
        if (title1 != null && title2 != null) {
            rc = nsc.compare((Object)title1.toLowerCase(), (Object)title2.toLowerCase());
        }
        return rc;
    }

    class PersonAdapter {
        GenericPerson p1;
        GenericPerson p2;
        NumericStringComparator nsc = new NumericStringComparator();

        public PersonAdapter(CnATreeElement p1, CnATreeElement p2) {
            this.p1 = new GenericPerson(p1);
            this.p2 = new GenericPerson(p2);
        }

        public int compareName() {
            String name2;
            String name1 = this.p1.getName();
            if (name1 != null) {
                name1 = name1.toLowerCase();
            }
            if ((name2 = this.p2.getName()) != null) {
                name2 = name2.toLowerCase();
            }
            return this.nsc.compare((Object)name1, (Object)name2);
        }

        public int compareParentName() {
            String name2;
            String name1 = this.p1.getParentName();
            if (name1 != null) {
                name1 = name1.toLowerCase();
            }
            if ((name2 = this.p2.getParentName()) != null) {
                name2 = name2.toLowerCase();
            }
            return this.nsc.compare((Object)name1, (Object)name2);
        }
    }
}

