/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.account;

import java.time.LocalDate;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import sernet.gs.ui.rcp.main.common.model.PlaceHolder;
import sernet.hui.swt.SWTResourceManager;
import sernet.verinice.model.common.configuration.Configuration;
import sernet.verinice.model.licensemanagement.LicenseMessageInfos;
import sernet.verinice.rcp.ElementTitleCache;
import sernet.verinice.rcp.account.GenericPerson;
import sernet.verinice.rcp.account.Messages;
import sernet.verinice.service.account.AccountLoader;

class AccountLabelProvider
extends ColumnLabelProvider
implements ITableLabelProvider {
    private static final Logger LOG = Logger.getLogger(AccountLabelProvider.class);
    boolean titleMapInitialized = false;
    private Map<Integer, LicenseMessageInfos> lmInfosMap;
    private final Set<String> currentUserRoles;

    public AccountLabelProvider(Map<Integer, LicenseMessageInfos> lmInfosMap, Set<String> currentUserRoles) {
        this.lmInfosMap = lmInfosMap;
        this.currentUserRoles = currentUserRoles;
    }

    public String getColumnText(Object element, int columnIndex) {
        try {
            if (element instanceof PlaceHolder) {
                return this.getPlaceHolderText(element, columnIndex);
            }
            Configuration account = (Configuration)element;
            GenericPerson person = new GenericPerson(account.getPerson());
            Integer scopeId = account.getPerson().getScopeId();
            switch (columnIndex) {
                case 0: {
                    return ElementTitleCache.getInstance().get(scopeId);
                }
                case 1: {
                    return person.getParentName();
                }
                case 2: {
                    return account.getUser();
                }
                case 3: {
                    return person.getName();
                }
                case 4: {
                    return account.getEmail();
                }
                case 5: {
                    return this.convertToX(account.isAdminUser());
                }
                case 6: {
                    return this.convertToX(account.isLocalAdminUser());
                }
                case 7: {
                    return this.convertToX(account.isScopeOnly());
                }
                case 8: {
                    return this.convertToX(account.isWebUser());
                }
                case 9: {
                    return this.convertToX(account.isRcpUser());
                }
                case 10: {
                    return this.convertToX(account.isDeactivatedUser());
                }
                case 11: {
                    return this.getLMColumnLabel(11, account);
                }
            }
            if (columnIndex > 10) {
                return this.getLMColumnLabel(columnIndex, account);
            }
            return null;
        }
        catch (Exception e) {
            LOG.error((Object)"Error while getting column text", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private String getLMColumnLabel(int columnIndex, Configuration account) {
        LicenseMessageInfos infos = this.lmInfosMap.get(columnIndex);
        String licenseId = infos.getLicenseId();
        if (infos.getValidUntil().isBefore(LocalDate.now())) {
            return Messages.AccountView_LicenseExpired;
        }
        return this.convertToX(account.getAssignedLicenseIds().contains(licenseId));
    }

    private String getPlaceHolderText(Object element, int columnIndex) {
        if (columnIndex == 1) {
            PlaceHolder ph = (PlaceHolder)element;
            return ph.getTitle();
        }
        return "";
    }

    public String convertToX(boolean value) {
        return value ? "X" : "";
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public Color getForeground(Object o) {
        if (o instanceof Configuration && !AccountLoader.isEditAllowed((Configuration)((Configuration)o), this.currentUserRoles)) {
            return SWTResourceManager.getColor((int)15);
        }
        return super.getForeground(o);
    }
}

