/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp.account;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.swt.widgets.Composite;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.IAccountService;
import sernet.verinice.model.common.accountgroup.AccountGroup;
import sernet.verinice.model.common.configuration.Configuration;
import sernet.verinice.rcp.MultiselectWidget;
import sernet.verinice.service.account.AccountLoader;

public class AccountGroupMultiselectWidget
extends MultiselectWidget<AccountGroup> {
    private static final Logger LOG = Logger.getLogger(AccountGroupMultiselectWidget.class);
    private Configuration account;
    private IAccountService accountService;

    public AccountGroupMultiselectWidget(Composite parent, Configuration account) {
        this.account = account;
        try {
            this.initData();
            this.initGui(parent);
        }
        catch (Exception e) {
            String message = "Error while creating widget.";
            LOG.error((Object)message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
    }

    @Override
    protected String getLabel(AccountGroup accountGroup) {
        return accountGroup.getName();
    }

    @Override
    protected void initData() throws CommandException {
        this.itemList = this.getAccountService().listGroups();
        boolean isLocalAdmin = ServiceFactory.lookupAuthService().currentUserHasRole(new String[]{"ROLE_LOCAL_ADMIN"});
        if (isLocalAdmin) {
            List groupNamesForLocalAdmin = AccountLoader.loadGroupNamesForLocalAdmin();
            this.itemList = this.itemList.stream().filter(g -> groupNamesForLocalAdmin.contains(g.getName())).collect(Collectors.toList());
        }
        this.itemList = this.sortItems(this.itemList);
        Set rolesOfAccount = this.account.getRoles(false);
        for (AccountGroup group : this.itemList) {
            if (!rolesOfAccount.contains(group.getName())) continue;
            this.preSelectedElements.add(group);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)(String.valueOf(group.getName()) + " added to preSelectedElements"));
        }
        if (rolesOfAccount.isEmpty()) {
            this.setShowOnlySelected(false);
        }
    }

    public void resetData() {
        try {
            this.initData();
        }
        catch (CommandException e) {
            LOG.error((Object)"Error while resetting data.", (Throwable)e);
        }
        this.removeCheckboxes();
        this.addCheckboxes();
    }

    public IAccountService getAccountService() {
        if (this.accountService == null) {
            this.accountService = this.createAccountServive();
        }
        return this.accountService;
    }

    private IAccountService createAccountServive() {
        return ServiceFactory.lookupAccountService();
    }

    @Override
    protected List<AccountGroup> sortItems(List<AccountGroup> list) {
        Collections.sort(list);
        return list;
    }

    public void setAccount(Configuration account) {
        this.account = account;
    }

    public void removeSelectedElements(AccountGroup accountGroup) {
        this.preSelectedElements.remove(accountGroup);
        this.selectedElementSet.remove(accountGroup);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(accountGroup + " removed from preSelectedElements"));
        }
    }
}

