/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.common.model.CnAElementHome;
import sernet.hui.common.VeriniceContext;
import sernet.hui.common.connect.HUITypeFactory;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.iso27k.rcp.Messages;
import sernet.verinice.model.common.ElementFilter;
import sernet.verinice.rcp.CheckStateProvider;
import sernet.verinice.rcp.ViewFilterAction;

public class ViewFilterDialog
extends Dialog {
    private static final int CHECKBOX_COLUMN_WIDTH = 430;
    private static final int VIEWER_TABLE_WIDTH = 470;
    private static final int VIEWER_TABLE_HEIGHT = 135;
    private String[][] types = ViewFilterAction.ISO_TYPES;
    private boolean state = true;
    private String[] tagPattern;
    private CheckboxTableViewer viewer;
    private String[] checkedElements;
    private Button filterOrgCheckbox;
    private boolean filterOrg;
    private Button hideEmptyCheckbox;
    private boolean hideEmpty;
    private CheckboxTableViewer viewerType;
    private Set<String[]> visibleTypes = new HashSet<String[]>();

    public ViewFilterDialog(Shell parent, ViewFilterAction viewFilter) {
        super(parent);
        int style = 2144;
        style = style | 0x10000 | 0x10;
        this.setShellStyle(style);
        this.tagPattern = viewFilter.getTagParameter().getPattern();
        this.filterOrg = viewFilter.getTagParameter().isFilterOrg();
        this.hideEmpty = viewFilter.getHideEmptyFilter().isHideEmpty();
        this.visibleTypes = viewFilter.getTypeParameter().getVisibleTypeSet();
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        container.setLayout((Layout)layout);
        Label intro = new Label(container, 0);
        intro.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        intro.setText(Messages.ISMViewFilterDialog_0);
        this.createTypeGroup(container);
        this.createTagfilterGroup(container);
        this.createFilterOrgGroup(container);
        this.createHideEmptyGroup(container);
        this.initContent();
        container.layout();
        return container;
    }

    private void createTypeGroup(Composite parent) {
        Group groupComposite = new Group(parent, 2048);
        groupComposite.setText(Messages.ISMViewFilterDialog_2);
        GridData gridData = new GridData(4, 2, true, false, 1, 1);
        groupComposite.setLayoutData((Object)gridData);
        groupComposite.setLayout((Layout)new GridLayout(1, false));
        ScrolledComposite comp = new ScrolledComposite((Composite)groupComposite, 512);
        comp.setLayoutData((Object)new GridData(1808));
        comp.setExpandHorizontal(true);
        this.viewerType = CheckboxTableViewer.newCheckList((Composite)comp, (int)2048);
        Table table = this.viewerType.getTable();
        table.setLayoutData((Object)new GridData(4, 1, false, false));
        table.setHeaderVisible(false);
        table.setLinesVisible(false);
        TableColumn checkboxColumn = new TableColumn(table, 16384);
        checkboxColumn.setWidth(430);
        comp.setContent(this.viewerType.getControl());
        this.viewerType.getTable().setSize(470, 135);
        this.viewerType.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewerType.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                return ViewFilterDialog.this.getTypeFactory().getMessage(((String[])element)[0]);
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public void addListener(ILabelProviderListener listener) {
            }
        });
        this.viewerType.setCheckStateProvider((ICheckStateProvider)new CheckStateProvider(this.getVisibleTypes()));
        this.viewerType.setInput((Object)this.getTypes());
        this.viewerType.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ViewFilterDialog.this.state = !ViewFilterDialog.this.state;
                ViewFilterDialog.this.viewerType.setAllChecked(ViewFilterDialog.this.state);
            }
        });
    }

    private void createTagfilterGroup(Composite parent) {
        Group groupComposite = new Group(parent, 2048);
        groupComposite.setText(Messages.ISMViewFilterDialog_1);
        GridData gridData = new GridData(4, 2, true, false, 1, 1);
        groupComposite.setLayoutData((Object)gridData);
        groupComposite.setLayout((Layout)new GridLayout(1, false));
        ScrolledComposite comp = new ScrolledComposite((Composite)groupComposite, 512);
        comp.setLayoutData((Object)new GridData(1808));
        comp.setExpandHorizontal(true);
        this.viewer = CheckboxTableViewer.newCheckList((Composite)comp, (int)2048);
        Table table = this.viewer.getTable();
        table.setLayoutData((Object)new GridData(4, 1, false, false));
        table.setHeaderVisible(false);
        table.setLinesVisible(false);
        TableColumn checkboxColumn = new TableColumn(table, 16384);
        checkboxColumn.setWidth(430);
        comp.setContent(this.viewer.getControl());
        this.viewer.getTable().setSize(470, 135);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                return (String)element;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
    }

    private Group createFilterOrgGroup(Composite parent) {
        Group groupComposite = new Group(parent, 2048);
        GridData gridData = new GridData(4, 3, true, false);
        groupComposite.setLayoutData((Object)gridData);
        groupComposite.setLayout((Layout)new GridLayout(1, false));
        this.filterOrgCheckbox = new Button((Composite)groupComposite, 32);
        this.filterOrgCheckbox.setText(Messages.ISMViewFilterDialog_7);
        return groupComposite;
    }

    private Group createHideEmptyGroup(Composite parent) {
        Group groupComposite = new Group(parent, 2048);
        GridData gridData = new GridData(4, 3, true, false);
        groupComposite.setLayoutData((Object)gridData);
        groupComposite.setLayout((Layout)new GridLayout(1, false));
        this.hideEmptyCheckbox = new Button((Composite)groupComposite, 32);
        this.hideEmptyCheckbox.setText(Messages.ISMViewFilterDialog_6);
        return groupComposite;
    }

    public String[] getCheckedElements() {
        return this.checkedElements != null ? (String[])this.checkedElements.clone() : null;
    }

    public boolean getHideEmpty() {
        return this.hideEmpty;
    }

    public boolean isHideEmpty() {
        return this.getHideEmpty();
    }

    public boolean isFilterOrgs() {
        return this.getFilterOrgs();
    }

    public boolean getFilterOrgs() {
        return this.filterOrg;
    }

    public Set<String[]> getVisibleTypes() {
        return this.visibleTypes;
    }

    protected void initContent() {
        try {
            List<String> tags = CnAElementHome.getInstance().getTags();
            tags.add(0, "NO_TAG");
            this.viewer.setInput(tags);
        }
        catch (CommandException e) {
            ExceptionUtil.log(e, Messages.ISMViewFilterDialog_4);
        }
        if (this.tagPattern != null) {
            this.viewer.setCheckedElements((Object[])this.tagPattern);
        }
        this.filterOrgCheckbox.setSelection(this.getFilterOrgs());
        this.hideEmptyCheckbox.setSelection(this.getHideEmpty());
    }

    public boolean close() {
        List<Object> tagList = Arrays.asList(this.viewer.getCheckedElements());
        this.checkedElements = tagList.toArray(new String[tagList.size()]);
        this.filterOrg = this.filterOrgCheckbox.getSelection();
        this.hideEmpty = this.hideEmptyCheckbox.getSelection();
        this.visibleTypes.clear();
        List<Object> typeList = Arrays.asList(this.viewerType.getCheckedElements());
        if (typeList.size() >= this.getTypes().length) {
            this.visibleTypes.add(ElementFilter.ALL_TYPES);
        } else {
            for (Object object : typeList) {
                this.visibleTypes.add((String[])object);
            }
        }
        return super.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        int shellWidth = 500;
        int shellHeight = 570;
        newShell.setText(Messages.ISMViewFilterDialog_5);
        newShell.setSize(500, 570);
    }

    protected HUITypeFactory getTypeFactory() {
        return (HUITypeFactory)VeriniceContext.get((String)"huiTypeFactory");
    }

    public String[][] getTypes() {
        return this.types;
    }

    public void setTypes(String[][] types) {
        this.types = types;
    }
}

